/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.search.AssigneeService;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.AbstractOrderableNavigableFieldImpl;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.HideableField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.option.AssigneeOption;
import com.atlassian.jira.issue.fields.option.AssigneeOptions;
import com.atlassian.jira.issue.fields.option.OptionGroup;
import com.atlassian.jira.issue.fields.rest.AssigneeRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.RestAwareField;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.util.MessagedResult;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.WorkflowIssueOperation;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.AssigneeSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.AssigneeStatisticsMapper;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.plugin.assignee.AssigneeResolver;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.Action;

public class AssigneeSystemField
extends AbstractOrderableNavigableFieldImpl
implements HideableField,
UserField,
RestAwareField,
RestFieldOperations {
    private static final Logger log = Logger.getLogger(AssigneeSystemField.class);
    private static final String SEPERATOR_STRING = "---------------";
    private static final String ASSIGNEE_NAME_KEY = "issue.field.assignee";
    public static final String AUTOMATIC_ASSIGNEE_STRING = "-automatic-";
    private final AssigneeStatisticsMapper assigneeStatisticsMapper;
    private final AssigneeResolver assigneeResolver;
    private final UserManager userManager;
    private final AssigneeService assigneeService;
    private final AvatarService avatarService;
    private final UserPickerSearchService userPickerSearchService;
    private final JiraBaseUrls jiraBaseUrls;
    private final TimeZoneManager timeZoneManager;

    public AssigneeSystemField(VelocityManager velocityManager, PermissionManager permissionManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, AssigneeStatisticsMapper assigneeStatisticsMapper, AssigneeResolver assigneeResolver, AssigneeSearchHandlerFactory assigneeSearchHandlerFactory, UserManager userManager, AssigneeService assigneeService, AvatarService avatarService, UserPickerSearchService userPickerSearchService, TimeZoneManager timeZoneManager, JiraBaseUrls jiraBaseUrls) {
        super("assignee", ASSIGNEE_NAME_KEY, velocityManager, applicationProperties, authenticationContext, permissionManager, assigneeSearchHandlerFactory);
        this.assigneeStatisticsMapper = assigneeStatisticsMapper;
        this.assigneeResolver = assigneeResolver;
        this.userManager = userManager;
        this.assigneeService = assigneeService;
        this.avatarService = avatarService;
        this.userPickerSearchService = userPickerSearchService;
        this.timeZoneManager = timeZoneManager;
        this.jiraBaseUrls = jiraBaseUrls;
    }

    private Map<String, Object> makeSoyRenderData(String currentAssigneeName, AssigneeOptions assigneeOptions) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, String> field = new HashMap<String, String>();
        field.put("id", this.getId());
        field.put("name", this.getId());
        data.put("field", field);
        String textOnlyValue = "";
        User loggedInUser = this.getAuthenticationContext().getLoggedInUser();
        if (StringUtils.isNotBlank((String)currentAssigneeName) && !currentAssigneeName.equals("-1")) {
            User user = this.getUser(currentAssigneeName);
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("name", currentAssigneeName);
            userMap.put("displayName", user.getDisplayName());
            URI avatarURL = this.avatarService.getAvatarURL(loggedInUser, currentAssigneeName, Avatar.Size.SMALL);
            userMap.put("avatarURL", avatarURL.toString());
            data.put("user", userMap);
            textOnlyValue = currentAssigneeName;
        }
        boolean disabled = !this.userPickerSearchService.canPerformAjaxSearch(loggedInUser);
        data.put("disabled", disabled);
        if (disabled) {
            data.put("textOnlyValue", textOnlyValue);
        }
        data.put("assigneeOptions", assigneeOptions);
        data.put("isLoggedInUserAssignable", assigneeOptions.isLoggedInUserAssignable());
        return data;
    }

    public String getCreateHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        return this.getEditHtml(fieldLayoutItem, operationContext, action, issue, displayParameters);
    }

    public String getEditHtml(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        FeatureManager featureManager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
        boolean frotherAssignee = featureManager.isEnabled("frother.assignee.field");
        String currentAssigneeName = (String)operationContext.getFieldValuesHolder().get(this.getId());
        velocityParams.put("currentAssignee", currentAssigneeName);
        if (this.hasContext(operationContext, issue)) {
            if (frotherAssignee) {
                AssigneeOptions assigneeOptions = this.getAssigneeOptions(issue, this.extractActionDescriptor(operationContext));
                velocityParams.put("soyRenderData", this.makeSoyRenderData(currentAssigneeName, assigneeOptions));
            } else {
                velocityParams.put("assigneeOptions", this.getAssigneeOptionsList(issue, this.extractActionDescriptor(operationContext)));
            }
            return this.renderTemplate("assignee-edit.vm", velocityParams);
        }
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:autocomplete");
        velocityParams.put("allowUnassigned", this.isUnassignedIssuesEnabled());
        return this.renderTemplate("assignee-edit-no-context.vm", velocityParams);
    }

    @Override
    public String getBulkEditHtml(OperationContext operationContext, Action action, BulkEditBean bulkEditBean, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(null, action, null, displayParameters);
        velocityParams.put("currentAssignee", operationContext.getFieldValuesHolder().get(this.getId()));
        velocityParams.put("assigneeOptions", this.getAssigneeOptions(bulkEditBean));
        return this.renderTemplate("assignee-edit.vm", velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, issue, displayParameters);
        User assignee = issue.getAssignee();
        if (assignee != null) {
            velocityParams.put("assignee", assignee.getName());
        } else {
            velocityParams.put("assignee", null);
        }
        return this.getViewHtml(velocityParams);
    }

    public String getViewHtml(FieldLayoutItem fieldLayoutItem, Action action, Issue issue, Object value, Map displayParameters) {
        Map<String, Object> velocityParams = this.getVelocityParams(fieldLayoutItem, action, null, displayParameters);
        velocityParams.put("assignee", value);
        return this.getViewHtml(velocityParams);
    }

    private String getViewHtml(Map velocityParams) {
        velocityParams.put("userutils", new UserUtils());
        return this.renderTemplate("assignee-view.vm", velocityParams);
    }

    public void validateParams(OperationContext operationContext, ErrorCollection errorCollectionToAddTo, I18nHelper i18n, Issue issue, FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem) {
        Map fieldValuesHolder = operationContext.getFieldValuesHolder();
        String assigneeId = (String)fieldValuesHolder.get(this.getId());
        if ("-2".equals(assigneeId)) {
            errorCollectionToAddTo.addError(this.getId(), i18n.getText("assign.error.invaliduser"), ErrorCollection.Reason.VALIDATION_FAILED);
            return;
        }
        if ("-1".equals(assigneeId)) {
            errorCollectionToAddTo.addErrorCollection(this.assigneeResolver.validateDefaultAssignee(issue, fieldValuesHolder));
            return;
        }
        if (!this.hasPermission(issue, 13)) {
            errorCollectionToAddTo.addErrorMessage(i18n.getText("assign.error.no.permission"), ErrorCollection.Reason.FORBIDDEN);
            return;
        }
        if (assigneeId != null) {
            User assigneeUser = this.userManager.getUserObject(assigneeId);
            if (assigneeUser == null) {
                errorCollectionToAddTo.addError(this.getId(), i18n.getText("assign.error.user.cannot.be.assigned", "'" + assigneeId + "'"), ErrorCollection.Reason.VALIDATION_FAILED);
            } else if (!ManagerFactory.getPermissionManager().hasPermission(17, issue.getProjectObject(), assigneeUser)) {
                errorCollectionToAddTo.addError("assignee", i18n.getText("assign.error.user.cannot.be.assigned", "'" + assigneeId + "'"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else if (!this.isUnassignedIssuesEnabled()) {
            log.info((Object)"Validation error: Issues must be assigned");
            errorCollectionToAddTo.addError("assignee", i18n.getText("assign.error.issues.unassigned"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private boolean isUnassignedIssuesEnabled() {
        return this.getApplicationProperties().getOption("jira.option.allowunassigned");
    }

    public Object getDefaultValue(Issue issue) {
        return null;
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            String assigneeId = (String)this.getValueFromParams(fieldValueHolder);
            User assignee = "-1".equals(assigneeId) ? this.assigneeResolver.getDefaultAssigneeObject((Issue)issue, fieldValueHolder) : this.getUser(assigneeId);
            issue.setAssignee(assignee);
        }
    }

    public MessagedResult needsMove(Collection originalIssues, Issue targetIssue, FieldLayoutItem targetFieldLayoutItem) {
        for (Issue originalIssue : originalIssues) {
            if (!(this.hasValue(originalIssue) ? !this.getPermissionManager().hasPermission(17, targetIssue.getProjectObject(), originalIssue.getAssigneeUser()) : !this.isUnassignedIssuesEnabled())) continue;
            return new MessagedResult(true);
        }
        return new MessagedResult(false);
    }

    public void populateForMove(Map fieldValuesHolder, Issue originalIssue, Issue targetIssue) {
        this.populateDefaults(fieldValuesHolder, targetIssue);
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setAssignee(null);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public boolean hasValue(Issue issue) {
        return issue.getAssignee() != null;
    }

    public void createValue(Issue issue, Object value) {
    }

    public void updateValue(FieldLayoutItem fieldLayoutItem, Issue issue, ModifiedValue modifiedValue, IssueChangeHolder issueChangeHolder) {
        Object currentValue = modifiedValue.getOldValue();
        Object value = modifiedValue.getNewValue();
        ChangeItemBean cib = null;
        if (currentValue == null) {
            if (value != null) {
                User assignee = (User)value;
                cib = new ChangeItemBean("jira", this.getId(), null, null, assignee.getName(), assignee.getDisplayName());
            }
        } else if (!this.valuesEqual(value, currentValue)) {
            User currentAssignee = (User)currentValue;
            if (value != null) {
                User assignee = (User)value;
                cib = new ChangeItemBean("jira", this.getId(), currentAssignee.getName(), currentAssignee.getDisplayName(), assignee.getName(), assignee.getDisplayName());
            } else {
                cib = new ChangeItemBean("jira", this.getId(), currentAssignee.getName(), currentAssignee.getDisplayName(), null, null);
            }
        }
        if (cib != null) {
            issueChangeHolder.addChangeItem(cib);
        }
    }

    private User getUser(String assigneeId) {
        if (assigneeId != null) {
            User user = this.userManager.getUser(assigneeId);
            if (user == null) {
                throw new DataAccessException("Error while retrieving user with id '" + assigneeId + "'.");
            }
            return user;
        }
        return null;
    }

    private boolean hasContext(OperationContext operationContext, Issue issue) {
        return issue != null;
    }

    private AssigneeOptions getAssigneeOptions(Issue issue, ActionDescriptor actionDescriptor) {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        List assignableUsers = this.assigneeService.getAssignableUsers(issue, actionDescriptor);
        List suggestedAssignees = this.assigneeService.getSuggestedAssignees(issue, loggedInUser, assignableUsers);
        return this.makeAssigneeOptions(assignableUsers, suggestedAssignees, loggedInUser, issue.getAssignee());
    }

    private List<AssigneeOption> getAssigneeOptionsList(Issue issue, ActionDescriptor actionDescriptor) {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        List assignableUsers = this.assigneeService.getAssignableUsers(issue, actionDescriptor);
        List suggestedAssignees = this.assigneeService.getSuggestedAssignees(issue, loggedInUser, assignableUsers);
        return this.makeAssigneeOptionsList(assignableUsers, suggestedAssignees);
    }

    private List<AssigneeOption> getAssigneeOptions(BulkEditBean bulkEditBean) {
        Collection<Object> issues = "BulkMove".equals(bulkEditBean.getOperationName()) ? bulkEditBean.getTargetIssueObjects().values() : bulkEditBean.getSelectedIssues();
        List bulkAssignableUsers = null;
        ActionDescriptor actionDescriptor = this.extractActionDescriptor((OperationContext)bulkEditBean);
        HashSet suggestedAssigneeNames = new HashSet();
        for (Issue issue : issues) {
            List issueAssignableUsers = this.assigneeService.getAssignableUsers(issue, actionDescriptor);
            if (bulkAssignableUsers == null) {
                bulkAssignableUsers = issueAssignableUsers;
            } else {
                bulkAssignableUsers.retainAll(issueAssignableUsers);
            }
            suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForIssue(issue));
        }
        Collections.sort(bulkAssignableUsers, new UserBestNameComparator(this.authenticationContext.getLocale()));
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        suggestedAssigneeNames.addAll(this.assigneeService.getRecentAssigneeNamesForUser(loggedInUser));
        List list = this.assigneeService.getSuggestedAssignees(suggestedAssigneeNames, bulkAssignableUsers);
        return this.makeAssigneeOptionsList(bulkAssignableUsers, list);
    }

    private ActionDescriptor extractActionDescriptor(OperationContext operationContext) {
        IssueOperation issueOperation = operationContext.getIssueOperation();
        if (issueOperation instanceof WorkflowIssueOperation) {
            return ((WorkflowIssueOperation)issueOperation).getActionDescriptor();
        }
        return null;
    }

    private AssigneeOptions makeAssigneeOptions(List<User> assignableUsers, List<User> suggestedUsers, User loggedInUser, User currentAssignee) {
        AssigneeOptions options = new AssigneeOptions();
        I18nHelper i18n = this.getAuthenticationContext().getI18nHelper();
        Map uniqueFullNames = this.assigneeService.makeUniqueFullNamesMap(assignableUsers);
        OptionGroup suggestedAssignees = new OptionGroup("suggested", "Suggestions", 0);
        String defaultAvatarURL = "/jira/secure/useravatar?size=small&avatarId=10062";
        if (this.isUnassignedIssuesEnabled()) {
            suggestedAssignees.add(new AssigneeOption(null, i18n.getText("common.concepts.unassigned"), "", defaultAvatarURL));
        }
        suggestedAssignees.add(new AssigneeOption("-1", i18n.getText("common.concepts.automatic"), "", defaultAvatarURL));
        for (User suggestedUser : suggestedUsers) {
            AssigneeOption assigneeOption = this.createAssigneeOption(suggestedUser, uniqueFullNames, loggedInUser);
            if (suggestedUser.equals(loggedInUser)) {
                assigneeOption.setLoggedInUser(true);
                options.setLoggedInUserIsAssignable(true);
            }
            if (suggestedUser.equals(currentAssignee)) {
                assigneeOption.setSelected(true);
            }
            suggestedAssignees.add(assigneeOption);
        }
        options.add(suggestedAssignees);
        options.add(new OptionGroup("search", "All Users", 1));
        if (assignableUsers.contains(loggedInUser)) {
            options.setLoggedInUserIsAssignable(true);
        }
        return options;
    }

    private List<AssigneeOption> makeAssigneeOptionsList(List<User> assignableUsers, List<User> suggestedUsers) {
        ArrayList<AssigneeOption> options = new ArrayList<AssigneeOption>();
        I18nHelper i18n = this.getAuthenticationContext().getI18nHelper();
        if (this.isUnassignedIssuesEnabled()) {
            options.add(new AssigneeOption(null, i18n.getText("common.concepts.unassigned"), true));
        }
        options.add(new AssigneeOption("-1", "- " + i18n.getText("common.concepts.automatic") + " -", true));
        AssigneeOption separator = new AssigneeOption("-2", SEPERATOR_STRING, false);
        separator.setOptionEnabled(false);
        options.add(separator);
        Map uniqueFullNames = this.assigneeService.makeUniqueFullNamesMap(assignableUsers);
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        if (!suggestedUsers.isEmpty()) {
            for (User suggestedUser : suggestedUsers) {
                options.add(this.createAssigneeOption(suggestedUser, uniqueFullNames, loggedInUser));
            }
            options.add(separator);
        }
        for (User user : assignableUsers) {
            options.add(this.createAssigneeOption(user, uniqueFullNames, loggedInUser));
        }
        return options;
    }

    private AssigneeOption createAssigneeOption(User user, Map<String, Boolean> fullNames, User loggedInUser) {
        String displayName = user.getDisplayName();
        boolean isUnique = fullNames.get(displayName);
        if (!isUnique) {
            displayName = displayName + " (" + user.getName() + ")";
        }
        URI avatarURL = this.avatarService.getAvatarURL(loggedInUser, user.getName(), Avatar.Size.SMALL);
        return new AssigneeOption(user.getName(), displayName, user.getEmailAddress(), avatarURL.toString());
    }

    public boolean isShown(Issue issue) {
        return this.hasPermission(issue, 13);
    }

    public void populateDefaults(Map fieldValuesHolder, Issue issue) {
        fieldValuesHolder.put(this.getId(), "-1");
    }

    public void populateFromIssue(Map fieldValuesHolder, Issue issue) {
        User assignee = issue.getAssignee();
        String assigneeName = assignee != null ? assignee.getName() : null;
        fieldValuesHolder.put(this.getId(), assigneeName);
    }

    @Override
    protected Object getRelevantParams(Map params) {
        String[] value = (String[])params.get(this.getId());
        if (value != null && value.length > 0 && TextUtils.stringSet((String)value[0])) {
            return value[0];
        }
        return null;
    }

    public String availableForBulkEdit(BulkEditBean bulkEditBean) {
        if (this.isHidden(bulkEditBean.getFieldLayouts())) {
            return "bulk.edit.unavailable.hidden";
        }
        for (Issue issue : bulkEditBean.getSelectedIssues()) {
            if (this.isShown(issue)) continue;
            return "bulk.edit.unavailable.permission";
        }
        return null;
    }

    public Object getValueFromParams(Map params) {
        return params.get(this.getId());
    }

    public void populateParamsFromString(Map fieldValuesHolder, String stringValue, Issue issue) throws FieldValidationException {
        String assignee = AUTOMATIC_ASSIGNEE_STRING.equals(stringValue) ? "-1" : stringValue;
        fieldValuesHolder.put(this.getId(), assignee);
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.assignee";
    }

    public String getDefaultSortOrder() {
        return "ASC";
    }

    public LuceneFieldSorter getSorter() {
        return this.assigneeStatisticsMapper;
    }

    public String getColumnViewHtml(FieldLayoutItem fieldLayoutItem, Map displayParams, Issue issue) {
        String assigneeUserId = null;
        try {
            assigneeUserId = issue.getAssigneeId();
        }
        catch (DataAccessException e) {
            log.debug((Object)"Error occurred retrieving assignee", (Throwable)e);
        }
        Map<String, Object> velocityParams = this.getVelocityParams(this.getAuthenticationContext().getI18nHelper(), displayParams, issue);
        if (assigneeUserId != null) {
            velocityParams.put("assigneeUsername", assigneeUserId);
        }
        return this.renderTemplate("assignee-columnview.vm", velocityParams);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldLayoutItem fieldLayoutItem, OperationContext operationContext, IssueContext issue) {
        return new FieldTypeInfo(JiraDataTypes.getType((Field)this), false, false, null, fieldLayoutItem.isRequired(), !fieldLayoutItem.isHidden(), true, null);
    }

    public JsonType getJsonSchema() {
        return JsonTypeBuilder.system((String)"user", (String)"assignee");
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new AssigneeRestFieldOperationsHandler();
    }

    public JsonData getJsonFromIssue(Issue issue) {
        return new JsonData((Object)UserJsonBean.shortBean((User)issue.getAssignee(), (JiraBaseUrls)this.jiraBaseUrls, (TimeZoneManager)this.timeZoneManager));
    }
}

