/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.util.JiraKeyUtils;
import java.util.Comparator;
import org.ofbiz.core.entity.GenericValue;

public class ProjectComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        GenericValue i1 = (GenericValue)o1;
        GenericValue i2 = (GenericValue)o2;
        if (i1 == null && i2 == null) {
            return 0;
        }
        if (i2 == null) {
            return -1;
        }
        if (i1 == null) {
            return 1;
        }
        String key1 = i1.getString("key");
        String key2 = i2.getString("key");
        return ProjectComparator.compareKeys(key1, key2);
    }

    public static int compareKeys(String key1, String key2) {
        if (key1 == null && key2 == null) {
            return 0;
        }
        if (key1 == null) {
            return 1;
        }
        if (key2 == null) {
            return -1;
        }
        String projectKey1 = JiraKeyUtils.getFastProjectKeyFromIssueKey((String)key1);
        String projectKey2 = JiraKeyUtils.getFastProjectKeyFromIssueKey((String)key2);
        if (projectKey1 == null && projectKey2 == null) {
            return 0;
        }
        if (projectKey1 == null) {
            return 1;
        }
        if (projectKey2 == null) {
            return -1;
        }
        return projectKey1.compareTo(projectKey2);
    }
}

