/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.DocumentIssueImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.IssueUtils;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class IssueUtilsBean {
    private static final Logger log = Logger.getLogger(IssueUtilsBean.class);
    private final IssueManager issueManager;
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext authenticationContext;

    public IssueUtilsBean(IssueManager issueManager, WorkflowManager workflowManager, JiraAuthenticationContext authenticationContext) {
        this.issueManager = issueManager;
        this.workflowManager = workflowManager;
        this.authenticationContext = authenticationContext;
    }

    public Map<Integer, ActionDescriptor> loadAvailableActions(Issue issueObject) {
        Issue originalIssue;
        Project project = issueObject.getProjectObject();
        LinkedHashMap<Integer, ActionDescriptor> availableActions = new LinkedHashMap<Integer, ActionDescriptor>();
        if (issueObject instanceof DocumentIssueImpl) {
            originalIssue = issueObject = this.issueManager.getIssueObject(issueObject.getId());
        } else {
            if (issueObject.getWorkflowId() == null) {
                log.warn((Object)("!!! Issue " + issueObject.getKey() + " has no workflow ID !!! "));
                return availableActions;
            }
            originalIssue = this.issueManager.getIssueObject(issueObject.getId());
        }
        try {
            int[] actionIds;
            Workflow wf = this.getWorkflow();
            WorkflowDescriptor wd = this.workflowManager.getWorkflow(issueObject).getDescriptor();
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("pkey", project.getKey());
            inputs.put("issue", (String)issueObject);
            inputs.put("originalissueobject", (String)originalIssue);
            for (int actionId : actionIds = wf.getAvailableActions(issueObject.getWorkflowId().longValue(), inputs)) {
                ActionDescriptor action = wd.getAction(actionId);
                if (action == null) {
                    log.error((Object)("State of issue [" + issueObject + "] has an action [id=" + actionId + "] which cannot be found in the workflow descriptor"));
                    continue;
                }
                availableActions.put(actionId, action);
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e), (Throwable)e);
        }
        return availableActions;
    }

    public boolean isValidAction(Issue issue, int action) {
        return this.loadAvailableActions(issue).containsKey(action);
    }

    public Workflow getWorkflow() {
        return this.workflowManager.makeWorkflow(this.authenticationContext.getUser() != null ? this.authenticationContext.getUser().getName() : null);
    }

    @Deprecated
    public GenericValue setPriority(GenericValue issue, User remoteUser, String priority) throws Exception {
        return IssueUtils.setPriority(issue, remoteUser, priority);
    }
}

