/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalTrackback;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.TrackbackParser;
import com.atlassian.jira.imports.project.parser.TrackbackParserImpl;
import com.atlassian.jira.imports.project.transformer.TrackbackTransformer;
import com.atlassian.jira.imports.project.transformer.TrackbackTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.log4j.Logger;

public class TrackbackPersisterHandler
extends AbstractPersisterHandler
implements ImportEntityHandler {
    private static final Logger log = Logger.getLogger(TrackbackPersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private TrackbackParser trackbackParser;
    private TrackbackTransformer trackbackTransformer;

    public TrackbackPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.projectImportResults = projectImportResults;
        this.backupSystemInformation = backupSystemInformation;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("TrackbackPing".equals(entityName)) {
            final ExternalTrackback externalTrackback = this.getTrackbackParser().parse(attributes);
            final ExternalTrackback transformedTrackback = this.getTrackbackTransformer().transform(this.projectImportMapper, externalTrackback);
            if (transformedTrackback.getIssueId() != null) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        Long trackbackId = TrackbackPersisterHandler.this.projectImportPersister.createEntity(TrackbackPersisterHandler.this.getTrackbackParser().getEntityRepresentation(transformedTrackback));
                        if (trackbackId == null) {
                            String issueKey = TrackbackPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalTrackback.getIssueId());
                            TrackbackPersisterHandler.this.projectImportResults.addError(TrackbackPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.trackback.error", externalTrackback.getId(), issueKey));
                        }
                    }
                });
            } else {
                String issueKey = this.backupSystemInformation.getIssueKeyForId(externalTrackback.getIssueId());
                log.warn((Object)("Not creating trackback with id '" + externalTrackback.getId() + "' for backup issue '" + issueKey + "', the issue has not been mapped in the new system."));
            }
        }
    }

    TrackbackTransformer getTrackbackTransformer() {
        if (this.trackbackTransformer == null) {
            this.trackbackTransformer = new TrackbackTransformerImpl();
        }
        return this.trackbackTransformer;
    }

    TrackbackParser getTrackbackParser() {
        if (this.trackbackParser == null) {
            this.trackbackParser = new TrackbackParserImpl();
        }
        return this.trackbackParser;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }
}

