/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.i18n;

import com.atlassian.jira.i18n.AbstractI18nResolver;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JiraI18nResolver
extends AbstractI18nResolver {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nHelper.BeanFactory beanFactory;

    public JiraI18nResolver(JiraAuthenticationContext jiraAuthenticationContext, I18nHelper.BeanFactory beanFactory) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.beanFactory = beanFactory;
    }

    @Override
    public String resolveText(String key, Serializable[] arguments) {
        I18nHelper bean = this.beanFactory.getInstance(this.jiraAuthenticationContext.getLocale());
        return bean.getText(key, (Object)arguments);
    }

    public String getRawText(String key) {
        I18nHelper bean = this.beanFactory.getInstance(this.jiraAuthenticationContext.getLocale());
        return bean.getUnescapedText(key);
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix) {
        return this.getAllTranslationsForPrefix(prefix, this.jiraAuthenticationContext.getLocale());
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix, Locale locale) {
        Assertions.notNull((String)"prefix", (Object)prefix);
        Assertions.notNull((String)"locale", (Object)locale);
        I18nHelper i18nBean = this.beanFactory.getInstance(locale);
        Set keys = i18nBean.getKeysForPrefix(prefix);
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String key : keys) {
            ret.put(key, i18nBean.getUnescapedText(key));
        }
        return Collections.unmodifiableMap(ret);
    }
}

