/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.search;

import com.atlassian.core.action.ActionUtils;
import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.action.ActionNames;
import com.atlassian.jira.action.admin.ListenerCreate;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.dispatcher.ActionResult;

public class IssueIndexListener
extends AbstractIssueEventListener {
    private static final Logger log = Logger.getLogger(IssueIndexListener.class);

    public void init(Map params) {
    }

    public String[] getAcceptedParams() {
        return new String[0];
    }

    public boolean isInternal() {
        return true;
    }

    public void issueCreated(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueUpdated(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueAssigned(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueResolved(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueClosed(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueCommented(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueWorkLogged(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueReopened(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueGenericEvent(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueCommentEdited(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueWorklogUpdated(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueWorklogDeleted(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void issueDeleted(IssueEvent event) {
    }

    public void issueMoved(IssueEvent event) {
        IssueIndexListener.reIndex(event);
    }

    public void customEvent(IssueEvent event) {
    }

    private static void reIndex(IssueEvent issueEvent) {
        HashSet<Issue> issuesToReindex = new HashSet<Issue>();
        Issue issue = issueEvent.getIssue();
        issuesToReindex.add(issue);
        if (issueEvent.isSubtasksUpdated()) {
            issuesToReindex.addAll(issue.getSubTaskObjects());
        }
        try {
            ManagerFactory.getIndexManager().reIndexIssueObjects(issuesToReindex);
        }
        catch (Throwable e) {
            log.error((Object)("Error re-indexing changes for issue '" + issue.getKey() + "'"), e);
        }
    }

    public static GenericValue create() throws Exception {
        ActionResult aResult = CoreFactory.getActionDispatcher().execute(ActionNames.LISTENER_CREATE, EasyMap.build((Object)"name", (Object)"Issue Index Listener", (Object)"clazz", (Object)"com.atlassian.jira.event.listeners.search.IssueIndexListener"));
        ActionUtils.checkForErrors(aResult);
        return ((ListenerCreate)aResult.getFirstAction()).getListenerConfig();
    }

    public static void remove() {
        try {
            ActionResult aResult = CoreFactory.getActionDispatcher().execute(ActionNames.LISTENER_DELETE, EasyMap.build((Object)"clazz", (Object)IssueIndexListener.class.getName()));
            ActionUtils.checkForErrors(aResult);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUnique() {
        return true;
    }

    public String getDescription() {
        return this.getI18NBean().getText("admin.listener.issue.index.desc");
    }
}

