/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.core.util.Clock;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeCompleteFormatter;
import com.atlassian.jira.datetime.DateTimeDateFormatter;
import com.atlassian.jira.datetime.DateTimeDatePickerFormatter;
import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeFormatterImpl;
import com.atlassian.jira.datetime.DateTimeFormatterServiceProvider;
import com.atlassian.jira.datetime.DateTimeFormatterSupplier;
import com.atlassian.jira.datetime.DateTimeISO8601DateFormatter;
import com.atlassian.jira.datetime.DateTimeISO8601DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimePickerFormatter;
import com.atlassian.jira.datetime.DateTimeRFC822DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeRelativeDatesAlwaysWithTime;
import com.atlassian.jira.datetime.DateTimeRelativeDatesWithTimeFormatter;
import com.atlassian.jira.datetime.DateTimeRelativeFormatter;
import com.atlassian.jira.datetime.DateTimeRelativeNoTimeFormatter;
import com.atlassian.jira.datetime.DateTimeSettings;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.DateTimeTimeFormatter;
import com.atlassian.jira.datetime.JodaFormatterCache;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import com.atlassian.jira.datetime.Source;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneResolver;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.RealClock;
import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeFormatterFactoryImpl
implements DateTimeFormatterFactory,
Startable {
    private static final Logger log = LoggerFactory.getLogger(DateTimeFormatterFactoryImpl.class);
    private final DateTimeFormatterSupplier formatterSupplier = new FormatterSupplier();
    private final JodaFormatterCache jodaFormatterCache = new JodaFormatterCache();
    private final DateTimeSettings settings = new SettingsSupplier();
    final ImmutableMap<DateTimeStyle, DateTimeFormatStrategy> formatters;
    private final TimeZoneResolver timeZoneResolver;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final I18nHelper.BeanFactory i18n;
    private final Clock clock;

    public DateTimeFormatterFactoryImpl(TimeZoneResolver timeZoneResolver, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, EventPublisher eventPublisher, I18nHelper.BeanFactory i18nFactory) {
        this(timeZoneResolver, jiraAuthenticationContext, applicationProperties, eventPublisher, i18nFactory, RealClock.getInstance());
    }

    DateTimeFormatterFactoryImpl(TimeZoneResolver timeZoneResolver, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, EventPublisher eventPublisher, I18nHelper.BeanFactory i18nFactory, Clock clock) {
        this.timeZoneResolver = timeZoneResolver;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.i18n = i18nFactory;
        this.clock = clock;
        this.formatters = this.createFormatters();
        log.trace("Known date time formatters: {}", this.formatters);
    }

    public DateTimeFormatter formatter() {
        return this.formatterSupplier.getFormatterFor(DateTimeStyle.RELATIVE, null, null);
    }

    public void start() {
        this.eventPublisher.register((Object)this);
        log.trace("Registered {} in event publisher: {}", (Object)this, (Object)this.eventPublisher);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.jodaFormatterCache.clear();
        log.trace("Cleared formatter cache due to event: {}", (Object)event);
    }

    private ImmutableMap<DateTimeStyle, DateTimeFormatStrategy> createFormatters() {
        ServiceProvider serviceProvider = new ServiceProvider();
        return ImmutableMap.builder().put((Object)DateTimeStyle.RELATIVE, (Object)new DateTimeRelativeFormatter(serviceProvider, this.jodaFormatterCache, this.applicationProperties, this.clock)).put((Object)DateTimeStyle.COMPLETE, (Object)new DateTimeCompleteFormatter(serviceProvider, this.jodaFormatterCache)).put((Object)DateTimeStyle.TIME, (Object)new DateTimeTimeFormatter(serviceProvider, this.jodaFormatterCache)).put((Object)DateTimeStyle.DATE, (Object)new DateTimeDateFormatter(serviceProvider, this.jodaFormatterCache)).put((Object)DateTimeStyle.DATE_PICKER, (Object)new DateTimeDatePickerFormatter(serviceProvider, this.jodaFormatterCache)).put((Object)DateTimeStyle.DATE_TIME_PICKER, (Object)new DateTimePickerFormatter(serviceProvider, this.jodaFormatterCache)).put((Object)DateTimeStyle.RELATIVE_WITH_TIME_ONLY, (Object)new DateTimeRelativeDatesWithTimeFormatter(serviceProvider, this.applicationProperties, this.timeZoneResolver, this.jiraAuthenticationContext, this.jodaFormatterCache, this.clock)).put((Object)DateTimeStyle.RELATIVE_WITHOUT_TIME, (Object)new DateTimeRelativeNoTimeFormatter(serviceProvider, this.applicationProperties, this.timeZoneResolver, this.jiraAuthenticationContext, this.jodaFormatterCache, this.clock)).put((Object)DateTimeStyle.RELATIVE_ALWAYS_WITH_TIME, (Object)new DateTimeRelativeDatesAlwaysWithTime(serviceProvider, this.applicationProperties, this.timeZoneResolver, this.jiraAuthenticationContext, this.jodaFormatterCache, this.clock)).put((Object)DateTimeStyle.ISO_8601_DATE, (Object)new DateTimeISO8601DateFormatter(this.jodaFormatterCache)).put((Object)DateTimeStyle.ISO_8601_DATE_TIME, (Object)new DateTimeISO8601DateTimeFormatter(this.jodaFormatterCache)).put((Object)DateTimeStyle.RSS_RFC822_DATE_TIME, (Object)new DateTimeRFC822DateTimeFormatter(this.jodaFormatterCache)).build();
    }

    private class SettingsSupplier
    implements DateTimeSettings {
        private SettingsSupplier() {
        }

        @Override
        public DateTimeZone timeZoneFor(@Nullable User user) {
            TimeZone userTimeZone;
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(user);
            if (user != null && (userTimeZone = DateTimeFormatterFactoryImpl.this.timeZoneResolver.getUserTimeZone((JiraServiceContext)serviceContext)) != null) {
                return DateTimeZone.forTimeZone((TimeZone)userTimeZone);
            }
            return DateTimeZone.forTimeZone((TimeZone)DateTimeFormatterFactoryImpl.this.timeZoneResolver.getDefaultTimeZone((JiraServiceContext)serviceContext));
        }

        @Override
        public Locale localeFor(@Nullable User user) {
            Locale userLocale;
            Locale locale = userLocale = user != null ? DateTimeFormatterFactoryImpl.this.i18n.getInstance(user).getLocale() : null;
            if (userLocale != null) {
                return userLocale;
            }
            Locale defaultLocale = DateTimeFormatterFactoryImpl.this.applicationProperties.getDefaultLocale();
            if (defaultLocale != null) {
                return defaultLocale;
            }
            return Locale.getDefault();
        }
    }

    @ThreadSafe
    class ServiceProvider
    implements DateTimeFormatterServiceProvider {
        ServiceProvider() {
        }

        public org.joda.time.format.DateTimeFormatter formatter(String pattern, Locale locale) {
            return DateTimeFormatterFactoryImpl.this.jodaFormatterCache.get(new JodaFormatterSupplier.Key(pattern, locale));
        }

        @Override
        public String getDefaultBackedString(String key) {
            return DateTimeFormatterFactoryImpl.this.applicationProperties.getDefaultBackedString(key);
        }

        @Override
        public String getUnescapedText(String key) {
            return DateTimeFormatterFactoryImpl.this.i18n.getInstance(DateTimeFormatterFactoryImpl.this.jiraAuthenticationContext.getLoggedInUser()).getUnescapedText(key);
        }

        @Override
        public String getText(String key, Object ... parameters) {
            return DateTimeFormatterFactoryImpl.this.i18n.getInstance(DateTimeFormatterFactoryImpl.this.jiraAuthenticationContext.getLoggedInUser()).getText(key, (Object)parameters);
        }
    }

    @ThreadSafe
    class FormatterSupplier
    implements DateTimeFormatterSupplier {
        FormatterSupplier() {
        }

        @Override
        public DateTimeFormatter getFormatterFor(DateTimeStyle style, Source<DateTimeZone> timeZone, Source<Locale> locale) {
            DateTimeFormatStrategy strategy = (DateTimeFormatStrategy)DateTimeFormatterFactoryImpl.this.formatters.get((Object)(style != null ? style : DateTimeStyle.RELATIVE));
            return new DateTimeFormatterImpl(strategy, DateTimeFormatterFactoryImpl.this.formatterSupplier, DateTimeFormatterFactoryImpl.this.settings, DateTimeFormatterFactoryImpl.this.jiraAuthenticationContext, timeZone, locale);
        }
    }
}

