/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded;

import sun.net.util.IPAddressUtil;

public class RemoteAddressHelper {
    public static boolean isValidIPNotation(String address) {
        String addr = address;
        if (address.contains("/")) {
            String[] addressComponents = address.split("/");
            addr = addressComponents[0];
        }
        return RemoteAddressHelper.getAddressInBytes(addr) != null;
    }

    private static byte[] getAddressInBytes(String address) {
        boolean ipv6Expected = false;
        if (address.charAt(0) == '[') {
            if (address.length() > 2 && address.charAt(address.length() - 1) == ']') {
                address = address.substring(1, address.length() - 1);
                ipv6Expected = true;
            } else {
                return null;
            }
        }
        if (Character.digit(address.charAt(0), 16) != -1 || address.charAt(0) == ':') {
            byte[] addr = null;
            addr = IPAddressUtil.textToNumericFormatV4(address);
            if (addr == null) {
                addr = IPAddressUtil.textToNumericFormatV6(address);
            } else if (ipv6Expected) {
                return null;
            }
            if (addr != null) {
                return addr;
            }
        } else if (ipv6Expected) {
            return null;
        }
        return null;
    }
}

