/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.gui;

import com.atlassian.jira.configurator.Configurator;
import com.atlassian.jira.configurator.config.DatabaseType;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.SettingsLoader;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.DatabaseConfigPanel;
import com.atlassian.jira.configurator.db.HsqlConfigPanel;
import com.atlassian.jira.configurator.db.MySqlConfigPanel;
import com.atlassian.jira.configurator.db.OracleConfigPanel;
import com.atlassian.jira.configurator.db.PostgresConfigPanel;
import com.atlassian.jira.configurator.db.SqlServerConfigPanel;
import com.atlassian.jira.configurator.gui.ConfigPanelBuilder;
import com.atlassian.jira.configurator.gui.ConnectionTestDialog;
import com.atlassian.jira.configurator.gui.VerticalFlowLayout;
import com.atlassian.jira.exception.ParseException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class ConfiguratorFrame
extends JFrame {
    private final JTextField tfJiraHome = new JTextField(32);
    private final JTextField tfConnectionPoolSize = new JTextField(10);
    private final JTextField tfHttpPort = new JTextField(10);
    private final JTextField tfControlPort = new JTextField(10);
    private JComboBox ddDatabaseType;
    private JPanel cardPanel;
    private CardLayout jdbcTypeCardLayout;
    private Map<DatabaseType, DatabaseConfigPanel> configPanelMap = null;
    final ConnectionTestDialog connectionTestDialog;
    private String previousJiraHome;

    public ConfiguratorFrame() {
        this.init();
        this.connectionTestDialog = new ConnectionTestDialog(this);
    }

    private void init() {
        this.setIconImage(new ImageIcon("../atlassian-jira/images/intro-gadget.png").getImage());
        this.setLayout(new BorderLayout());
        this.add(this.newTabbedPanel(), "Center");
        this.add((Component)this.newButtonPanel(), "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConfiguratorFrame.this.closeApplication();
            }
        });
        this.pack();
    }

    private void closeApplication() {
        try {
            if (Configurator.settingsEqual(this.gatherNewSettings())) {
                System.exit(0);
            }
        }
        catch (ValidationException e) {
            // empty catch block
        }
        int option = JOptionPane.showConfirmDialog(this, "Are you sure you wish to close without saving?", "Confirm Exit", 0);
        if (option == 0) {
            System.exit(0);
        }
    }

    private Component newTabbedPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConfiguratorFrame.this.checkForJiraHomeChange();
            }
        });
        tabbedPane.addTab("JIRA Home", this.newJiraHomePanel());
        tabbedPane.addTab("Database", this.newDatabasePanel());
        tabbedPane.addTab("Web Server", this.newWebServerPanel());
        return tabbedPane;
    }

    private JComponent newJiraHomePanel() {
        ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
        panelBuilder.add("JIRA Home Directory", this.getJiraHomePicker());
        JPanel panel = panelBuilder.getPanel();
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        return panel;
    }

    private JComponent getJiraHomePicker() {
        JPanel panel = new JPanel(new BorderLayout(4, 0));
        this.tfJiraHome.setToolTipText("Set the 'JIRA Home' directory (used to store data for this JIRA installation)");
        panel.add((Component)this.tfJiraHome, "Center");
        JButton btnJiraHome = new JButton("Browse");
        btnJiraHome.setToolTipText("Opens a dialog box to select the JIRA Home");
        btnJiraHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguratorFrame.this.browseForJiraHome();
            }
        });
        panel.add((Component)btnJiraHome, "East");
        return panel;
    }

    private void browseForJiraHome() {
        JFileChooser chooser = new JFileChooser(this.tfJiraHome.getText());
        chooser.setDialogTitle("JIRA Home directory");
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Directory";
            }
        });
        chooser.setFileSelectionMode(1);
        int returnVal = chooser.showDialog(this, "OK");
        if (returnVal == 0) {
            this.tfJiraHome.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private JComponent newWebServerPanel() {
        ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
        panelBuilder.add("HTTP Port", this.tfHttpPort);
        panelBuilder.add("Control Port", this.tfControlPort);
        JPanel panel = panelBuilder.getPanel();
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        return panel;
    }

    private JComponent newDatabasePanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 4));
        panel.setBorder(new EmptyBorder(4, 4, 4, 4));
        JPanel pnlNorth = new JPanel(new VerticalFlowLayout());
        panel.add((Component)pnlNorth, "North");
        this.createDataBaseDropDown();
        ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
        panelBuilder.add("Database type", this.ddDatabaseType);
        pnlNorth.add(panelBuilder.getPanel());
        this.createCardPanel();
        pnlNorth.add(this.cardPanel);
        panelBuilder = new ConfigPanelBuilder();
        panelBuilder.add("Pool Size", this.tfConnectionPoolSize);
        this.tfConnectionPoolSize.setToolTipText("The maximum number of database connections in the Connection Pool");
        panelBuilder.setTitle("Connection Pool");
        pnlNorth.add(panelBuilder.getPanel());
        panel.add((Component)this.newTestConnectionButton(), "South");
        return panel;
    }

    private JComponent newTestConnectionButton() {
        JButton button = new JButton("Test Connection");
        button.setToolTipText("Try to connect to the database with these settings");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguratorFrame.this.connectionTestDialog.setText("Attempting to connect to the " + ConfiguratorFrame.this.getSelectedDatabaseConfigPanel().getDisplayName() + " database server...");
                ConfiguratorFrame.this.connectionTestDialog.enableCloseButton(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ConfiguratorFrame.this.testConnection();
                    }
                }).start();
                ConfiguratorFrame.this.connectionTestDialog.setVisible(true);
            }
        });
        return button;
    }

    private void testConnection() {
        DatabaseConfigPanel jdbcPanel = this.getSelectedDatabaseConfigPanel();
        String errorMessage = null;
        try {
            jdbcPanel.validate();
            jdbcPanel.testConnection(this.tfJiraHome.getText());
        }
        catch (UnsupportedClassVersionError ex) {
            errorMessage = "UnsupportedClassVersionError occurred. It is likely your JDBC drivers use a newer version of Java than you are running now.";
        }
        catch (ClassNotFoundException ex) {
            errorMessage = "Driver class '" + jdbcPanel.getClassName() + "' not found. Ensure the DB driver is installed in the 'lib' directory.";
        }
        catch (SQLException ex) {
            String message = ex.getMessage();
            if (message.contains("Stack Trace")) {
                if (message.contains("UnknownHostException")) {
                    message = "Unknown host.";
                } else if (message.contains("Check that the hostname and port are correct")) {
                    message = "Check that the hostname and port are correct.";
                }
            }
            errorMessage = "Could not connect to the DB: " + message;
        }
        catch (ValidationException ex) {
            errorMessage = ex.getMessage();
        }
        catch (RuntimeException ex) {
            errorMessage = "An unexpected error occurred: " + ex.getMessage();
            System.err.println(errorMessage);
            ex.printStackTrace(System.err);
        }
        class SwingRunner
        implements Runnable {
            private String errorMessage;

            SwingRunner(String errorMessage) {
                this.errorMessage = errorMessage;
            }

            @Override
            public void run() {
                if (this.errorMessage == null) {
                    ConfiguratorFrame.this.connectionTestDialog.addText("Connection successful.");
                } else {
                    ConfiguratorFrame.this.connectionTestDialog.addText(this.errorMessage);
                }
                ConfiguratorFrame.this.connectionTestDialog.enableCloseButton(true);
            }
        }
        SwingUtilities.invokeLater(new SwingRunner(errorMessage));
    }

    private DatabaseConfigPanel getSelectedDatabaseConfigPanel() {
        return this.getDatabaseConfigPanel(this.getSelectedDatabaseType());
    }

    private DatabaseType getSelectedDatabaseType() {
        return (DatabaseType)((Object)this.ddDatabaseType.getSelectedItem());
    }

    private void createCardPanel() {
        this.cardPanel = new JPanel();
        this.jdbcTypeCardLayout = new CardLayout();
        this.cardPanel.setLayout(this.jdbcTypeCardLayout);
        this.cardPanel.setBorder(new TitledBorder("Connection Details"));
        for (DatabaseType databaseType : DatabaseType.values()) {
            this.cardPanel.add((Component)this.getDatabaseConfigPanel(databaseType).getPanel(), databaseType.getDisplayName());
        }
    }

    private DatabaseConfigPanel getDatabaseConfigPanel(DatabaseType databaseType) {
        if (this.configPanelMap == null) {
            this.configPanelMap = new HashMap<DatabaseType, DatabaseConfigPanel>(5);
            this.configPanelMap.put(DatabaseType.HSQL, new HsqlConfigPanel());
            this.configPanelMap.put(DatabaseType.SQL_SERVER, new SqlServerConfigPanel());
            this.configPanelMap.put(DatabaseType.MY_SQL, new MySqlConfigPanel());
            this.configPanelMap.put(DatabaseType.ORACLE, new OracleConfigPanel());
            this.configPanelMap.put(DatabaseType.POSTGRES, new PostgresConfigPanel());
        }
        return this.configPanelMap.get((Object)databaseType);
    }

    private void createDataBaseDropDown() {
        this.ddDatabaseType = new JComboBox<DatabaseType>(DatabaseType.values());
        this.ddDatabaseType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseType databaseType = ConfiguratorFrame.this.getSelectedDatabaseType();
                if (databaseType == null) {
                    return;
                }
                ConfiguratorFrame.this.jdbcTypeCardLayout.show(ConfiguratorFrame.this.cardPanel, databaseType.getDisplayName());
            }
        });
    }

    private JPanel newButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.newSaveButton());
        panel.add(this.newCloseButton());
        return panel;
    }

    private Component newSaveButton() {
        JButton button = new JButton("Save");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ConfiguratorFrame.this.checkForJiraHomeChange();
                    Configurator.saveSettings(ConfiguratorFrame.this.gatherNewSettings());
                    ConfiguratorFrame.this.showInformationDialog("Settings saved successfully.");
                }
                catch (ValidationException ex) {
                    ConfiguratorFrame.this.showErrorDialog(ex);
                }
                catch (IOException ex) {
                    ConfiguratorFrame.this.showErrorDialog(ex);
                }
                catch (RuntimeException ex) {
                    ex.printStackTrace();
                    ConfiguratorFrame.this.showErrorDialog("Unexpected error during save:\n" + ex.getMessage());
                }
            }
        });
        return button;
    }

    private Settings gatherNewSettings() throws ValidationException {
        Settings newSettings = new Settings();
        String jiraHome = this.tfJiraHome.getText();
        newSettings.setJiraHome(jiraHome);
        this.setPoolSize(newSettings);
        this.getSelectedDatabaseConfigPanel().saveSettings(newSettings, jiraHome);
        this.saveWebServerSettings(newSettings);
        return newSettings;
    }

    private void setPoolSize(Settings newSettings) throws ValidationException {
        int poolSize;
        String newPoolSize = this.tfConnectionPoolSize.getText().trim();
        if (newPoolSize.length() == 0) {
            newSettings.setDbPoolSize("20");
            return;
        }
        try {
            poolSize = Integer.parseInt(newPoolSize);
            newSettings.setDbPoolSize(newPoolSize);
        }
        catch (NumberFormatException e) {
            throw new ValidationException("Connection Pool size must be a valid integer.");
        }
        if (poolSize < 1) {
            throw new ValidationException("Connection Pool size must be greater than zero.");
        }
    }

    private void saveWebServerSettings(Settings newSettings) throws ValidationException {
        String port = this.tfHttpPort.getText().trim();
        this.validatePort("HTTP Port", port);
        newSettings.setHttpPort(port);
        port = this.tfControlPort.getText().trim();
        this.validatePort("Control Port", port);
        newSettings.setControlPort(port);
    }

    private void validatePort(String fieldName, String port) throws ValidationException {
        if (port.trim().length() == 0) {
            throw new ValidationException(fieldName + " is a mandatory field.");
        }
        try {
            int portNumber = Integer.parseInt(port);
            if (portNumber < 0 || portNumber > 65535) {
                throw new ValidationException(fieldName + " must be a number between 0 and 65535.");
            }
        }
        catch (NumberFormatException e) {
            throw new ValidationException(fieldName + " must be a valid number between 0 and 65535.");
        }
    }

    private Component newCloseButton() {
        JButton button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguratorFrame.this.closeApplication();
            }
        });
        return button;
    }

    public void setSettings(Settings settings) throws ParseException {
        this.tfJiraHome.setText(settings.getJiraHome());
        this.previousJiraHome = settings.getJiraHome();
        this.tfConnectionPoolSize.setText(settings.getDbPoolSize());
        this.ddDatabaseType.setSelectedItem((Object)settings.getDatabaseType());
        this.getSelectedDatabaseConfigPanel().setSettings(settings);
        this.tfHttpPort.setText(settings.getHttpPort());
        this.tfControlPort.setText(settings.getControlPort());
    }

    private void showErrorDialog(Exception ex) {
        this.showErrorDialog(ex.getMessage());
    }

    private void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private void showInformationDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "Information", 1);
    }

    private void checkForJiraHomeChange() {
        String newJiraHome = this.tfJiraHome.getText().trim();
        if (!newJiraHome.equals(this.previousJiraHome)) {
            int option;
            File configFile = new File(newJiraHome, "dbconfig.xml");
            if (configFile.exists() && (option = JOptionPane.showConfirmDialog(this, "Would you like to reload the DB configuration from the new JIRA Home?", "Reload DB Config", 0, 3)) == 0) {
                try {
                    Settings settings = SettingsLoader.reloadDbConfig(newJiraHome);
                    this.ddDatabaseType.setSelectedItem((Object)settings.getDatabaseType());
                    this.getSelectedDatabaseConfigPanel().setSettings(settings);
                    this.tfConnectionPoolSize.setText(settings.getDbPoolSize());
                }
                catch (IOException ex) {
                    this.showErrorDialog(ex);
                }
                catch (ParseException ex) {
                    this.showErrorDialog((Exception)((Object)ex));
                }
            }
            this.previousJiraHome = newJiraHome.trim();
        }
    }
}

