/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.configurator.db.DatabaseConfig;
import com.atlassian.jira.configurator.db.DatabaseInstance;
import com.atlassian.jira.exception.ParseException;

public class MySqlDatabaseConfig
implements DatabaseConfig {
    @Override
    public String getDatabaseType() {
        return "MySql";
    }

    @Override
    public String getInstanceFieldName() {
        return "Database";
    }

    @Override
    public String getClassName() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public String getUrl(String hostname, String port, String instance) {
        String url = "jdbc:mysql://" + hostname.trim();
        if (port.trim().length() > 0) {
            url = url + ':' + port.trim();
        }
        return url + "/" + instance.trim() + "?useUnicode=true&characterEncoding=UTF8&sessionVariables=storage_engine=InnoDB";
    }

    @Override
    public DatabaseInstance parseUrl(String jdbcUrl) throws ParseException {
        if (!jdbcUrl.startsWith("jdbc:mysql://")) {
            throw new ParseException("Unable to parse the MySQL JDBC URL '" + jdbcUrl + "'.");
        }
        String stripped = jdbcUrl.substring("jdbc:mysql://".length());
        String[] hostPort_DatabaseAndProperties = stripped.split("/", 2);
        DatabaseInstance connectionProperties = new DatabaseInstance();
        String[] hostPort = hostPort_DatabaseAndProperties[0].split(":", 2);
        connectionProperties.setHostname(hostPort[0]);
        if (hostPort.length == 1) {
            connectionProperties.setPort("");
        } else {
            connectionProperties.setPort(hostPort[1]);
        }
        String[] database_Properties = hostPort_DatabaseAndProperties[1].split("\\?", 2);
        connectionProperties.setInstance(database_Properties[0]);
        return connectionProperties;
    }
}

