/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.version;

import com.atlassian.core.action.ActionUtils;
import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.action.ActionNames;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.version.DeleteVersionValidator;
import com.atlassian.jira.bc.project.version.SwapVersionAction;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.event.project.VersionArchiveEvent;
import com.atlassian.jira.event.project.VersionCreateEvent;
import com.atlassian.jira.event.project.VersionDeleteEvent;
import com.atlassian.jira.event.project.VersionMergeEvent;
import com.atlassian.jira.event.project.VersionMoveEvent;
import com.atlassian.jira.event.project.VersionReleaseEvent;
import com.atlassian.jira.event.project.VersionUnarchiveEvent;
import com.atlassian.jira.event.project.VersionUnreleaseEvent;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.UpdateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.dispatcher.ActionResult;

public class DefaultVersionService
implements VersionService {
    private static final Logger log = Logger.getLogger(DefaultVersionService.class);
    private final VersionManager versionManager;
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final IssueIndexManager issueIndexManager;
    private final IssueFactory issueFactory;
    private final SearchProvider searchProvider;
    private final DateFieldFormat dateFieldFormat;
    private final EventPublisher eventPublisher;
    private final I18nHelper.BeanFactory i18n;

    public DefaultVersionService(VersionManager versionManager, PermissionManager permissionManager, IssueManager issueManager, IssueIndexManager issueIndexManager, SearchProvider searchProvider, IssueFactory issueFactory, I18nHelper.BeanFactory i18n, DateFieldFormat dateFieldFormat, EventPublisher eventPublisher) {
        this.versionManager = versionManager;
        this.permissionManager = permissionManager;
        this.issueManager = issueManager;
        this.issueIndexManager = issueIndexManager;
        this.issueFactory = issueFactory;
        this.i18n = i18n;
        this.searchProvider = searchProvider;
        this.dateFieldFormat = dateFieldFormat;
        this.eventPublisher = eventPublisher;
    }

    public VersionService.VersionResult getVersionById(User user, Project project, Long versionId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        Assertions.notNull((String)"versionId", (Object)versionId);
        if (!this.hasReadPermission(user, project)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.read.permission"));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        Version version = this.versionManager.getVersion(versionId);
        if (version == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist.with.id", (Object)versionId));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        return new VersionService.VersionResult((ErrorCollection)errors, version);
    }

    public VersionService.VersionResult getVersionById(User user, Long versionId) {
        Version version = this.versionManager.getVersion(versionId);
        if (version == null) {
            I18nHelper i18nBean = this.getI18nBean(user);
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist.with.id", (Object)versionId));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        return this.getVersionById(user, version.getProjectObject(), versionId);
    }

    public VersionService.VersionResult getVersionByProjectAndName(User user, Project project, String versionName) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        Assertions.notNull((String)"project", (Object)project);
        Assertions.notBlank((String)"versionName", (String)versionName);
        if (!this.hasReadPermission(user, project)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.read.permission"));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        Version version = this.versionManager.getVersion(project.getId(), versionName);
        if (version == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist", versionName, project.getName()));
            return new VersionService.VersionResult((ErrorCollection)errors);
        }
        return new VersionService.VersionResult((ErrorCollection)errors, version);
    }

    public VersionService.VersionsResult getVersionsByProject(User user, Project project) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        Assertions.notNull((String)"project", (Object)project);
        if (!this.hasReadPermission(user, project)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.read.permission"));
            return new VersionService.VersionsResult((ErrorCollection)errors, Collections.emptyList());
        }
        return new VersionService.VersionsResult((ErrorCollection)errors, (Collection)this.versionManager.getVersions(project.getId()));
    }

    private boolean hasReadPermission(User user, Project project) {
        return this.hasEditPermission(user, project) || this.permissionManager.hasPermission(10, project, user);
    }

    private boolean hasEditPermission(User user, Project project) {
        return this.permissionManager.hasPermission(0, user) || this.permissionManager.hasPermission(23, project, user);
    }

    public ServiceOutcome<Version> setVersionDetails(User user, Version version, String name, String description) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (this.hasEditPermission(user, version.getProjectObject())) {
            this.versionManager.editVersionDetails(version, name, description, version.getProject());
            return ServiceOutcomeImpl.ok(version);
        }
        String message = this.i18n.getInstance(user).getText("admin.errors.projectversions.could.not.edit", version.getName());
        errors.addErrorMessage(message, ErrorCollection.Reason.FORBIDDEN);
        return new ServiceOutcomeImpl<Version>((ErrorCollection)errors);
    }

    public ErrorCollection validateVersionDetails(User user, Version version, String name, String description) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (this.hasEditPermission(user, version.getProjectObject())) {
            if (StringUtils.isBlank((String)name)) {
                String message = this.i18n.getInstance(user).getText("admin.errors.projectversions.must.specify.version.name");
                errors.addError("name", message, ErrorCollection.Reason.VALIDATION_FAILED);
            } else if (this.versionManager.isDuplicateName(version, name, version.getProject())) {
                String message = this.i18n.getInstance(user).getText("admin.errors.projectversions.version.exists");
                errors.addError("name", message, ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else {
            String message = this.i18n.getInstance(user).getText("admin.errors.projectversions.could.not.edit", version.getName());
            errors.addErrorMessage(message, ErrorCollection.Reason.FORBIDDEN);
        }
        return errors;
    }

    public ServiceOutcome<Version> setReleaseDate(User user, Version version, Date releaseDate) {
        if (this.hasEditPermission(user, version.getProjectObject())) {
            this.versionManager.editVersionReleaseDate(version, releaseDate);
            return ServiceOutcomeImpl.ok(version);
        }
        String message = this.i18n.getInstance(user).getText("admin.errors.projectversions.could.not.edit", version.getName());
        return ServiceOutcomeImpl.error(message);
    }

    public ServiceOutcome<Version> validateReleaseDate(User user, Version version, String releaseDate) {
        try {
            return this.setReleaseDate(user, version, this.parseDate(user, releaseDate));
        }
        catch (ReleaseDateParseException e) {
            return ServiceOutcomeImpl.from(e.parseErrors, version);
        }
    }

    public ServiceOutcome<Version> setReleaseDate(User user, Version version, String releaseDate) {
        try {
            return this.setReleaseDate(user, version, this.parseDate(user, releaseDate));
        }
        catch (ReleaseDateParseException e) {
            return ServiceOutcomeImpl.from(e.parseErrors, version);
        }
    }

    public VersionService.ValidationResult validateDelete(JiraServiceContext context, Long versionId, VersionService.VersionAction affectsAction, VersionService.VersionAction fixAction) {
        log.debug((Object)("Validating delete of version with id " + versionId));
        DeleteVersionValidator validator = new DeleteVersionValidator(context, this.versionManager, this.permissionManager);
        return validator.validate(versionId, affectsAction, fixAction);
    }

    public void delete(JiraServiceContext context, VersionService.ValidationResult result) {
        if (!result.isValid()) {
            throw new IllegalArgumentException("Result from validation is invalid");
        }
        Version version = result.getVersionToDelete();
        log.debug((Object)("Deleting version with id " + version.getId()));
        Collection<GenericValue> issues = this.getAllAssociatedIssues(version);
        if (!issues.isEmpty()) {
            this.swapVersionsForIssues(context.getLoggedInUser(), version, result.getAffectsSwapVersion(), result.getFixSwapVersion(), issues);
            try {
                this.issueIndexManager.reIndexIssues(issues);
            }
            catch (IndexException e) {
                log.warn((Object)"Could not reindex issues after swapping versions", (Throwable)e);
            }
        }
        this.versionManager.deleteVersion(version);
        if (!issues.isEmpty() && result.getFixSwapVersion() != null) {
            this.eventPublisher.publish((Object)new VersionMergeEvent(result.getFixSwapVersion().getId().longValue(), version.getId().longValue()));
        }
        this.eventPublisher.publish((Object)new VersionDeleteEvent(version.getId().longValue()));
    }

    public VersionService.ValidationResult validateMerge(JiraServiceContext context, Long versionId, Long swapVersionId) {
        SwapVersionAction swapVersionAction = new SwapVersionAction(swapVersionId);
        return this.validateDelete(context, versionId, swapVersionAction, swapVersionAction);
    }

    public void merge(JiraServiceContext context, VersionService.ValidationResult result) {
        this.delete(context, result);
    }

    Collection<GenericValue> getAllAssociatedIssues(Version version) {
        try {
            HashSet<GenericValue> affectedIssues = new HashSet<GenericValue>();
            affectedIssues.addAll(this.getGvIssuesByAffectsVersion(version));
            affectedIssues.addAll(this.getGvIssuesByFixVersion(version));
            return affectedIssues;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error getting issues for version with id " + version.getId(), (Throwable)e);
        }
    }

    List<GenericValue> getGvIssuesByAffectsVersion(Version version) throws GenericEntityException {
        return this.issueManager.getIssuesByEntity("IssueVersion", version.getGenericValue());
    }

    List<GenericValue> getGvIssuesByFixVersion(Version version) throws GenericEntityException {
        return this.issueManager.getIssuesByEntity("IssueFixVersion", version.getGenericValue());
    }

    void swapVersionsForIssues(User user, Version version, Version affectsSwapVersion, Version fixSwapVersion, Collection<GenericValue> issues) {
        for (GenericValue gvIssue : issues) {
            MutableIssue issue = this.issueFactory.getIssue(gvIssue);
            issue.setAffectedVersions(this.getNewVersions(version, issue.getAffectedVersions(), affectsSwapVersion));
            issue.setFixVersions(this.getNewVersions(version, issue.getFixVersions(), fixSwapVersion));
            try {
                Map actionParams = MapBuilder.newBuilder((Object)"issueObject", (Object)issue, (Object)"remoteUser", (Object)user, (Object)"sendMail", (Object)Boolean.FALSE, (Object)"issue", (Object)issue.getGenericValue()).toMutableMap();
                this.executeIssueUpdate(actionParams);
            }
            catch (Exception e) {
                throw new DataAccessException("Unable to swap versions for issue with key: " + issue.getKey(), (Throwable)e);
            }
        }
    }

    void executeIssueUpdate(Map<String, Object> actionParams) throws Exception {
        ActionResult aResult = CoreFactory.getActionDispatcher().execute(ActionNames.ISSUE_UPDATE, actionParams);
        ActionUtils.checkForErrors(aResult);
    }

    private Collection<Version> getNewVersions(Version versionToRemove, Collection<Version> versions, Version versionToSwap) {
        HashSet<Version> newVersions = new HashSet<Version>(versions);
        boolean oldVersionRemoved = false;
        boolean alreadyContainsNewVersion = false;
        Iterator iterator = newVersions.iterator();
        while (iterator.hasNext()) {
            Version version = (Version)iterator.next();
            if (version.getId().equals(versionToRemove.getId())) {
                iterator.remove();
                oldVersionRemoved = true;
                continue;
            }
            if (versionToSwap == null || !version.getId().equals(versionToSwap.getId())) continue;
            alreadyContainsNewVersion = true;
        }
        if (oldVersionRemoved && versionToSwap != null && !alreadyContainsNewVersion) {
            newVersions.add(versionToSwap);
        }
        return newVersions;
    }

    public VersionService.CreateVersionValidationResult validateCreateVersion(User user, Project project, String versionName, String releaseDate, String description, Long scheduleAfterVersion) {
        ValidateResult result = this.validateCreateParameters(user, project, versionName, releaseDate);
        if (!result.isValid()) {
            return new VersionService.CreateVersionValidationResult(result.errors, result.reasons);
        }
        return new VersionService.CreateVersionValidationResult(result.errors, project, versionName, result.parsedDate, description, scheduleAfterVersion);
    }

    public VersionService.CreateVersionValidationResult validateCreateVersion(User user, Project project, String versionName, Date releaseDate, String description, Long scheduleAfterVersion) {
        ValidateResult result = this.validateCreateParameters(user, project, versionName, null);
        if (!result.isValid()) {
            return new VersionService.CreateVersionValidationResult(result.errors, result.reasons);
        }
        return new VersionService.CreateVersionValidationResult(result.errors, project, versionName, DefaultVersionService.makeMidnight(releaseDate, this.getI18nBean(user).getLocale()), description, scheduleAfterVersion);
    }

    public Version createVersion(User user, VersionService.CreateVersionValidationResult request) {
        try {
            Version version = this.versionManager.createVersion(request.getVersionName(), request.getReleaseDate(), request.getDescription(), request.getProject().getId(), request.getScheduleAfterVersion());
            this.eventPublisher.publish((Object)new VersionCreateEvent(version.getId().longValue()));
            return version;
        }
        catch (CreateException ex) {
            throw new RuntimeException("createVersion failed", ex);
        }
    }

    public VersionService.ReleaseVersionValidationResult validateReleaseVersion(User user, Version version, Date releaseDate) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        this.checkVersionValid((ErrorCollection)errors, i18nBean, user, version);
        if (errors.hasAnyErrors()) {
            return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors);
        }
        if (version.isReleased()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.release.already.released"));
        }
        if (errors.hasAnyErrors()) {
            return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors);
        }
        return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors, version, releaseDate);
    }

    public VersionService.ReleaseVersionValidationResult validateReleaseVersion(User user, Version version, String releaseDate) {
        try {
            return this.validateReleaseVersion(user, version, this.parseDate(user, releaseDate));
        }
        catch (ReleaseDateParseException e) {
            return new VersionService.ReleaseVersionValidationResult(e.parseErrors);
        }
    }

    public VersionService.ReleaseVersionValidationResult validateUnreleaseVersion(User user, Version version, Date releaseDate) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        this.checkVersionValid((ErrorCollection)errors, i18nBean, user, version);
        if (errors.hasAnyErrors()) {
            return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors);
        }
        if (!version.isReleased()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.release.not.released"));
        }
        if (errors.hasAnyErrors()) {
            return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors);
        }
        return new VersionService.ReleaseVersionValidationResult((ErrorCollection)errors, version, releaseDate);
    }

    public VersionService.ReleaseVersionValidationResult validateUnreleaseVersion(User user, Version version, String releaseDate) {
        try {
            return this.validateUnreleaseVersion(user, version, this.parseDate(user, releaseDate));
        }
        catch (ReleaseDateParseException e) {
            return new VersionService.ReleaseVersionValidationResult(e.parseErrors);
        }
    }

    public VersionService.ArchiveVersionValidationResult validateArchiveVersion(User user, Version version) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        this.checkVersionValid((ErrorCollection)errors, i18nBean, user, version);
        if (version.isArchived()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.archive.already.archived"));
        }
        if (errors.hasAnyErrors()) {
            return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors);
        }
        return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors, version);
    }

    public VersionService.ArchiveVersionValidationResult validateUnarchiveVersion(User user, Version version) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        this.checkVersionValid((ErrorCollection)errors, i18nBean, user, version);
        if (errors.hasAnyErrors()) {
            return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors);
        }
        if (!version.isArchived()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.archive.not.archived"));
        }
        if (errors.hasAnyErrors()) {
            return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors);
        }
        return new VersionService.ArchiveVersionValidationResult((ErrorCollection)errors, version);
    }

    private void checkVersionValid(ErrorCollection errors, I18nHelper i18nHelper, User user, Version version) {
        Assertions.notNull((String)"version", (Object)version);
        Project project = version.getProjectObject();
        if (project == null) {
            errors.addErrorMessage(i18nHelper.getText("admin.errors.must.specify.valid.project"));
            return;
        }
        if (!this.permissionManager.hasPermission(0, user) && !this.permissionManager.hasPermission(23, project, user)) {
            errors.addErrorMessage(i18nHelper.getText("admin.errors.version.no.permission"));
            return;
        }
        if (StringUtils.isEmpty((String)version.getName())) {
            errors.addError("name", i18nHelper.getText("admin.errors.enter.valid.version.name"));
        }
    }

    public Version releaseVersion(VersionService.ReleaseVersionValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not release a version with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not release a version with an invalid validation result.");
        }
        Version version = result.getVersion();
        version.setReleaseDate(result.getReleaseDate());
        version.setReleased(true);
        this.versionManager.releaseVersion(version, true);
        version = this.versionManager.getVersion(version.getId());
        this.eventPublisher.publish((Object)new VersionReleaseEvent(version.getId().longValue()));
        return version;
    }

    public void moveUnreleasedToNewVersion(User user, Version currentVersion, Version newVersion) {
        List<Issue> issues = this.getUnresolvedIssues(user, currentVersion);
        if (!issues.isEmpty()) {
            for (Issue issue : issues) {
                MutableIssue mutableIssue = this.issueManager.getIssueObject(issue.getId());
                Collection versions = mutableIssue.getFixVersions();
                versions.remove(currentVersion);
                versions.add(newVersion);
                mutableIssue.setFixVersions(versions);
                try {
                    this.issueManager.updateIssue(user, mutableIssue, EventDispatchOption.ISSUE_UPDATED, true);
                }
                catch (UpdateException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private List<Issue> getUnresolvedIssues(User user, Version toRelease) {
        try {
            SearchResults results;
            List issues;
            Long pid = toRelease.getProjectObject().getId();
            JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().project(new Long[]{pid}).and().unresolved();
            if (toRelease != null) {
                builder.and().fixVersion(toRelease.getId());
            }
            return (issues = (results = this.searchProvider.search(builder.buildQuery(), user, PagerFilter.getUnlimitedFilter())).getIssues()) == null ? Collections.emptyList() : issues;
        }
        catch (Exception e) {
            log.error((Object)("Exception whilst getting unresolved issues " + e.getMessage()), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Version unreleaseVersion(VersionService.ReleaseVersionValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not unrelease a version with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not unrelease a version with an invalid validation result.");
        }
        Version version = result.getVersion();
        version.setReleaseDate(result.getReleaseDate());
        version.setReleased(false);
        this.versionManager.releaseVersion(version, false);
        version = this.versionManager.getVersion(version.getId());
        this.eventPublisher.publish((Object)new VersionUnreleaseEvent(version.getId().longValue()));
        return version;
    }

    public Version archiveVersion(VersionService.ArchiveVersionValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not archive a version with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not archive a version with an invalid validation result.");
        }
        Version version = result.getVersion();
        version.setArchived(true);
        this.versionManager.archiveVersion(version, true);
        version = this.versionManager.getVersion(version.getId());
        this.eventPublisher.publish((Object)new VersionArchiveEvent(version.getId().longValue()));
        return version;
    }

    public Version unarchiveVersion(VersionService.ArchiveVersionValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not unarchive a version with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not unarchive a version with an invalid validation result.");
        }
        Version version = result.getVersion();
        version.setArchived(false);
        this.versionManager.archiveVersion(version, false);
        version = this.versionManager.getVersion(version.getId());
        this.eventPublisher.publish((Object)new VersionUnarchiveEvent(version.getId().longValue()));
        return version;
    }

    public VersionService.MoveVersionValidationResult validateMoveToStartVersionSequence(User user, long versionId) {
        return this.validateMove(user, versionId);
    }

    public VersionService.MoveVersionValidationResult validateIncreaseVersionSequence(User user, long versionId) {
        return this.validateMove(user, versionId);
    }

    public VersionService.MoveVersionValidationResult validateDecreaseVersionSequence(User user, long versionId) {
        return this.validateMove(user, versionId);
    }

    public VersionService.MoveVersionValidationResult validateMoveToEndVersionSequence(User user, long versionId) {
        return this.validateMove(user, versionId);
    }

    public VersionService.MoveVersionValidationResult validateMoveVersionAfter(User user, long versionId, Long scheduleAfterVersionId) {
        VersionService.MoveVersionValidationResult moveVersionValidationResult = this.validateMove(user, versionId);
        if (!moveVersionValidationResult.getErrorCollection().hasAnyErrors()) {
            SimpleErrorCollection errors = new SimpleErrorCollection();
            I18nHelper i18nBean = this.getI18nBean(user);
            Version version = moveVersionValidationResult.getVersion();
            Version scheduleAfterVersion = this.versionManager.getVersion(scheduleAfterVersionId);
            if (scheduleAfterVersion == null || !scheduleAfterVersion.getProjectObject().equals(version.getProjectObject())) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist.with.id.for.project", scheduleAfterVersionId.toString(), version.getProjectObject().getKey()));
                moveVersionValidationResult = new VersionService.MoveVersionValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.MoveVersionValidationResult.Reason.SCHEDULE_AFTER_VERSION_NOT_FOUND));
            } else {
                moveVersionValidationResult = new VersionService.MoveVersionValidationResult((ErrorCollection)new SimpleErrorCollection(), version, scheduleAfterVersionId);
            }
        }
        return moveVersionValidationResult;
    }

    private VersionService.MoveVersionValidationResult validateMove(User user, long versionId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        Version version = this.versionManager.getVersion(Long.valueOf(versionId));
        if (version == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.not.exist.with.id", String.valueOf(versionId)));
            return new VersionService.MoveVersionValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.MoveVersionValidationResult.Reason.NOT_FOUND));
        }
        Project project = version.getProjectObject();
        if (!this.permissionManager.hasPermission(0, user) && !this.permissionManager.hasPermission(23, project, user)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.permission"));
            return new VersionService.MoveVersionValidationResult((ErrorCollection)errors, EnumSet.of(VersionService.MoveVersionValidationResult.Reason.FORBIDDEN));
        }
        return new VersionService.MoveVersionValidationResult((ErrorCollection)errors, version);
    }

    public void moveToStartVersionSequence(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.moveToStartVersionSequence(moveVersionValidationResult.getVersion());
        this.eventPublisher.publish((Object)new VersionMoveEvent(moveVersionValidationResult.getVersion().getId().longValue()));
    }

    public void increaseVersionSequence(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.increaseVersionSequence(moveVersionValidationResult.getVersion());
        this.eventPublisher.publish((Object)new VersionMoveEvent(moveVersionValidationResult.getVersion().getId().longValue()));
    }

    public void decreaseVersionSequence(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.decreaseVersionSequence(moveVersionValidationResult.getVersion());
        this.eventPublisher.publish((Object)new VersionMoveEvent(moveVersionValidationResult.getVersion().getId().longValue()));
    }

    public void moveToEndVersionSequence(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.moveToEndVersionSequence(moveVersionValidationResult.getVersion());
        this.eventPublisher.publish((Object)new VersionMoveEvent(moveVersionValidationResult.getVersion().getId().longValue()));
    }

    public void moveVersionAfter(VersionService.MoveVersionValidationResult moveVersionValidationResult) {
        this.versionManager.moveVersionAfter(moveVersionValidationResult.getVersion(), moveVersionValidationResult.getScheduleAfterVersion());
        this.eventPublisher.publish((Object)new VersionMoveEvent(moveVersionValidationResult.getVersion().getId().longValue()));
    }

    public boolean isOverdue(Version version) {
        return this.versionManager.isVersionOverDue((Version)Assertions.notNull((String)"version", (Object)version));
    }

    public long getFixIssuesCount(Version version) {
        return this.versionManager.getFixIssues(version).size();
    }

    public long getAffectsIssuesCount(Version version) {
        return this.versionManager.getAffectsIssues(version).size();
    }

    public long getUnresolvedIssuesCount(User user, Version version) {
        return this.getUnresolvedIssues(user, version).size();
    }

    I18nHelper getI18nBean(User user) {
        return this.i18n.getInstance(user);
    }

    ValidateResult validateCreateParameters(User user, Project project, String versionName, String releaseDate) {
        I18nHelper i18nBean = this.getI18nBean(user);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (project == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.must.specify.valid.project"));
            return new ValidateResult((ErrorCollection)errors, EnumSet.of(VersionService.CreateVersionValidationResult.Reason.BAD_PROJECT));
        }
        if (!this.permissionManager.hasPermission(0, user) && !this.permissionManager.hasPermission(23, project, user)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.version.no.permission"));
            return new ValidateResult((ErrorCollection)errors, EnumSet.of(VersionService.CreateVersionValidationResult.Reason.FORBIDDEN));
        }
        EnumSet<VersionService.CreateVersionValidationResult.Reason> reasons = EnumSet.noneOf(VersionService.CreateVersionValidationResult.Reason.class);
        if (StringUtils.isEmpty((String)versionName)) {
            errors.addError("name", i18nBean.getText("admin.errors.enter.valid.version.name"));
            reasons.add(VersionService.CreateVersionValidationResult.Reason.BAD_NAME);
        } else {
            List versions = this.versionManager.getVersions(project.getId());
            for (Version version : versions) {
                if (!versionName.equalsIgnoreCase(version.getName())) continue;
                errors.addError("name", i18nBean.getText("admin.errors.version.already.exists"));
                reasons.add(VersionService.CreateVersionValidationResult.Reason.DUPLICATE_NAME);
            }
            if (versionName.length() > 255) {
                errors.addError("name", i18nBean.getText("admin.errors.portalpages.description.too.long"));
                reasons.add(VersionService.CreateVersionValidationResult.Reason.VERSION_NAME_TOO_LONG);
            }
        }
        Date date = null;
        try {
            date = this.parseDate(user, releaseDate);
        }
        catch (ReleaseDateParseException e) {
            errors.addErrorCollection(e.parseErrors);
            reasons.add(VersionService.CreateVersionValidationResult.Reason.BAD_RELEASE_DATE);
        }
        return new ValidateResult((ErrorCollection)errors, reasons, date);
    }

    private static Date makeMidnight(Date date, Locale locale) {
        if (date == null) {
            return date;
        }
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    @Nullable
    protected Date parseDate(User user, String releaseDate) throws ReleaseDateParseException {
        if (StringUtils.isEmpty((String)releaseDate)) {
            return null;
        }
        try {
            return this.dateFieldFormat.parseDatePicker(releaseDate);
        }
        catch (IllegalArgumentException e) {
            I18nHelper i18n = this.getI18nBean(user);
            SimpleErrorCollection errors = new SimpleErrorCollection();
            errors.addError("releaseDate", i18n.getText("admin.errors.incorrect.date.format", this.dateFieldFormat.getFormatHint()));
            throw new ReleaseDateParseException((ErrorCollection)errors);
        }
    }

    static class ReleaseDateParseException
    extends Exception {
        final ErrorCollection parseErrors;

        ReleaseDateParseException(ErrorCollection parseErrors) {
            this.parseErrors = parseErrors;
        }
    }

    static class ValidateResult {
        private final ErrorCollection errors;
        private final Set<VersionService.CreateVersionValidationResult.Reason> reasons;
        private final Date parsedDate;

        ValidateResult(ErrorCollection errors, Set<VersionService.CreateVersionValidationResult.Reason> reasons) {
            this(errors, reasons, null);
        }

        ValidateResult(ErrorCollection errors, Set<VersionService.CreateVersionValidationResult.Reason> reasons, Date parsedDate) {
            if (!reasons.isEmpty() && !errors.hasAnyErrors()) {
                throw new IllegalArgumentException("Cannot have reasons without error messages.");
            }
            this.errors = errors;
            this.reasons = reasons;
            this.parsedDate = parsedDate;
        }

        boolean isValid() {
            return !this.errors.hasAnyErrors();
        }

        ErrorCollection getErrors() {
            return this.errors;
        }

        Set<VersionService.CreateVersionValidationResult.Reason> getReasons() {
            return this.reasons;
        }

        Date getParsedDate() {
            return this.parsedDate;
        }
    }
}

