/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.issuelink;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.issuelink.IssueLinkService;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.issuelink.IssueLink;
import com.atlassian.jira.issue.issuelink.IssueLinks;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultIssueLinkService
implements IssueLinkService {
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkManager issueLinkManager;
    private final PermissionManager permissionManager;
    private final IssueManager issueManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final UserHistoryManager userHistoryManager;

    public DefaultIssueLinkService(IssueLinkTypeManager issueLinkTypeManager, IssueManager issueManager, PermissionManager permissionManager, I18nHelper.BeanFactory beanFactory, IssueLinkManager issueLinkManager, UserHistoryManager userHistoryManager) {
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.beanFactory = beanFactory;
        this.issueLinkManager = issueLinkManager;
        this.userHistoryManager = userHistoryManager;
    }

    @Override
    public Collection<com.atlassian.jira.issue.issuelink.IssueLinkType> getIssueLinkTypes() {
        return this.transformIssueLinkType(this.issueLinkTypeManager.getIssueLinkTypes());
    }

    @Override
    public IssueLinkService.IssueLinkResult getIssueLinks(User user, Issue issue) {
        ErrorCollection errorCollection = this.validateIssuePermission(user, issue, 10);
        if (!errorCollection.hasAnyErrors()) {
            LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(issue, user);
            Set linkTypes = linkCollection.getLinkTypes();
            HashMap outwardIssueLinksByName = Maps.newHashMap();
            for (IssueLinkType linkType : linkTypes) {
                String input = linkType.getName();
                List list = linkCollection.getOutwardIssues(input);
                if (list == null) continue;
                outwardIssueLinksByName.put(input, this.transformListToIssueLink(issue, list, linkType));
            }
            HashMap inwardsIssueLinksByName = Maps.newHashMap();
            for (IssueLinkType linkType : linkTypes) {
                String input = linkType.getName();
                List list = linkCollection.getInwardIssues(input);
                if (list == null) continue;
                inwardsIssueLinksByName.put(input, this.transformListToIssueLink(issue, list, linkType));
            }
            ArrayList allIssueLinks = Lists.newArrayList();
            for (List issueLinks : Iterables.concat(outwardIssueLinksByName.values(), inwardsIssueLinksByName.values())) {
                allIssueLinks.addAll(issueLinks);
            }
            return this.makeIssueLinkResult(errorCollection, issue, linkTypes, allIssueLinks, outwardIssueLinksByName, inwardsIssueLinksByName);
        }
        return this.makeIssueLinkResult(errorCollection, issue, Collections.<IssueLinkType>emptyList(), Collections.<IssueLink>emptyList(), Collections.<String, List<IssueLink>>emptyMap(), Collections.<String, List<IssueLink>>emptyMap());
    }

    @Override
    public IssueLinkService.AddIssueLinkValidationResult validateAddIssueLinks(User user, Issue issue, String linkName, Collection<String> linkKeys) {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"linkKeys", linkKeys);
        ErrorCollection errorCollection = this.validateIssuePermission(user, issue, 12);
        if (!errorCollection.hasAnyErrors()) {
            this.validateLinkInput(user, errorCollection, issue, linkName, linkKeys);
        }
        return new IssueLinkService.AddIssueLinkValidationResult(user, errorCollection, issue, linkName, linkKeys);
    }

    @Override
    public IssueLinkService.IssueLinkResult addIssueLinks(User user, IssueLinkService.AddIssueLinkValidationResult result) {
        Assertions.notNull((String)"result", (Object)((Object)result));
        if (!result.isValid()) {
            throw new IllegalStateException("Cannot add issue links with invalid validation result!");
        }
        com.atlassian.jira.issue.issuelink.IssueLinkType linkType = this.matchToIssueLinkType(result.getLinkName());
        if (linkType == null) {
            throw new IllegalArgumentException("Cant find issue link type '" + result.getLinkName() + "'");
        }
        Issue sourceIssue = result.getIssue();
        for (String targetIssueKey : result.getLinkKeys()) {
            MutableIssue destinationIssue = this.issueManager.getIssueObject(targetIssueKey);
            if (destinationIssue == null) {
                throw new IllegalArgumentException("Issue with key '" + targetIssueKey + "' no longer exists!");
            }
            try {
                if (result.getLinkName().equals(linkType.getOutward())) {
                    this.issueLinkManager.createIssueLink(sourceIssue.getId(), destinationIssue.getId(), linkType.getId(), null, result.getUser());
                } else {
                    this.issueLinkManager.createIssueLink(destinationIssue.getId(), sourceIssue.getId(), linkType.getId(), null, result.getUser());
                }
                this.userHistoryManager.addItemToHistory(UserHistoryItem.ISSUELINKTYPE, result.getUser(), String.valueOf(linkType.getId()), result.getLinkName());
            }
            catch (CreateException createE) {
                throw new RuntimeException(createE);
            }
        }
        return this.getIssueLinks(user, result.getIssue());
    }

    private ErrorCollection validateIssuePermission(User user, Issue issue, int permissionsId) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (issue == null) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.issue.doesnt.exist"));
            return errors;
        }
        if (!this.permissionManager.hasPermission(permissionsId, issue, user)) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.issue.no.permission", issue.getKey()));
        }
        return errors;
    }

    private void validateLinkInput(User user, ErrorCollection errors, Issue issue, String linkName, Collection<String> linkKeys) {
        com.atlassian.jira.issue.issuelink.IssueLinkType linkType = this.matchToIssueLinkType(linkName);
        if (linkType == null) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.invalid.link.name", linkName));
        } else if (linkType.isSystemLinkType()) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.invalid.link.type", linkName));
        }
        if (linkKeys == null || linkKeys.isEmpty()) {
            errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.must.provide.issue.links"));
        } else {
            for (String linkKey : linkKeys) {
                MutableIssue linkedIssue;
                if (linkKey.equalsIgnoreCase(issue.getKey())) {
                    errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.self.reference", linkKey));
                }
                if ((linkedIssue = this.issueManager.getIssueObject(linkKey)) != null) continue;
                errors.addErrorMessage(this.beanFactory.getInstance(user).getText("issuelinking.service.error.linked.issue.doesnt.exist", linkKey));
            }
        }
    }

    private IssueLinkService.IssueLinkResult makeIssueLinkResult(ErrorCollection errorCollection, final Issue issue, Collection<IssueLinkType> issueLinkTypes, final Collection<IssueLink> allIssues, final Map<String, List<IssueLink>> outwardIssues, final Map<String, List<IssueLink>> inwardIssues) {
        final HashSet<com.atlassian.jira.issue.issuelink.IssueLinkType> transformedTypes = new HashSet<com.atlassian.jira.issue.issuelink.IssueLinkType>(this.transformIssueLinkType(issueLinkTypes));
        return new IssueLinkService.IssueLinkResult(errorCollection, transformedTypes, new IssueLinks(){

            @Override
            public Issue getIssue() {
                return issue;
            }

            @Override
            public Set<com.atlassian.jira.issue.issuelink.IssueLinkType> getLinkTypes() {
                return transformedTypes;
            }

            @Override
            public Collection<IssueLink> getOutwardIssues(String linkName) {
                return (Collection)outwardIssues.get(linkName);
            }

            @Override
            public Collection<IssueLink> getInwardIssues(String linkName) {
                return (Collection)inwardIssues.get(linkName);
            }

            @Override
            public Collection<IssueLink> getAllIssues() {
                return allIssues;
            }
        });
    }

    private com.atlassian.jira.issue.issuelink.IssueLinkType matchToIssueLinkType(String linkName) {
        Collection linkTypes = this.issueLinkTypeManager.getIssueLinkTypes();
        for (IssueLinkType linkType : linkTypes) {
            if (!linkName.equals(linkType.getOutward()) && !linkName.equals(linkType.getInward())) continue;
            return this.transformIssueLinkType(linkType);
        }
        return null;
    }

    private List<IssueLink> transformListToIssueLink(final Issue sourceIssue, List<Issue> destinationIssues, final IssueLinkType linkType) {
        ArrayList issueLinks = Lists.newArrayList();
        for (final Issue destinationIssue : destinationIssues) {
            issueLinks.add(new IssueLink(){

                @Override
                public Issue getSourceIssue() {
                    return sourceIssue;
                }

                @Override
                public Issue getDestinationIssue() {
                    return destinationIssue;
                }

                @Override
                public com.atlassian.jira.issue.issuelink.IssueLinkType getIssueLinkType() {
                    return DefaultIssueLinkService.this.transformIssueLinkType(linkType);
                }
            });
        }
        return issueLinks;
    }

    private Collection<com.atlassian.jira.issue.issuelink.IssueLinkType> transformIssueLinkType(Collection<IssueLinkType> issueLinkTypes) {
        ArrayList<com.atlassian.jira.issue.issuelink.IssueLinkType> transformedList = new ArrayList<com.atlassian.jira.issue.issuelink.IssueLinkType>(issueLinkTypes.size());
        for (IssueLinkType rawIssueLinkType : issueLinkTypes) {
            transformedList.add(this.transformIssueLinkType(rawIssueLinkType));
        }
        return Collections.unmodifiableCollection(transformedList);
    }

    private com.atlassian.jira.issue.issuelink.IssueLinkType transformIssueLinkType(final IssueLinkType rawIssueLinkType) {
        return new com.atlassian.jira.issue.issuelink.IssueLinkType(){

            @Override
            public Long getId() {
                return rawIssueLinkType.getId();
            }

            @Override
            public String getName() {
                return rawIssueLinkType.getName();
            }

            @Override
            public String getOutward() {
                return rawIssueLinkType.getOutward();
            }

            @Override
            public String getInward() {
                return rawIssueLinkType.getInward();
            }

            @Override
            public String getStyle() {
                return rawIssueLinkType.getStyle();
            }

            @Override
            public boolean isSubTaskLinkType() {
                return rawIssueLinkType.isSubTaskLinkType();
            }

            @Override
            public boolean isSystemLinkType() {
                return rawIssueLinkType.isSystemLinkType();
            }
        };
    }
}

