/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.filter;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserNames;
import com.atlassian.jira.util.FilterCronValidationErrorMappingUtil;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.generator.CronExpressionDescriptor;
import com.atlassian.jira.web.component.cron.parser.CronExpressionParser;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.quartz.CronTrigger;
import org.quartz.Trigger;

public class DefaultFilterSubscriptionService
implements FilterSubscriptionService {
    private static final Logger log = Logger.getLogger(DefaultFilterSubscriptionService.class);
    private final FilterCronValidationErrorMappingUtil errorMapper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SubscriptionManager subscriptionManager;

    public DefaultFilterSubscriptionService(JiraAuthenticationContext jiraAuthenticationContext, SubscriptionManager subscriptionManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.subscriptionManager = subscriptionManager;
        this.errorMapper = new FilterCronValidationErrorMappingUtil(jiraAuthenticationContext);
    }

    DefaultFilterSubscriptionService(FilterCronValidationErrorMappingUtil errorMapper, JiraAuthenticationContext jiraAuthenticationContext, SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.errorMapper = errorMapper;
    }

    public void validateCronExpression(JiraServiceContext context, String expr) {
        this.validateAndCreateCronTrigger(context, expr);
    }

    private CronTrigger validateAndCreateCronTrigger(JiraServiceContext context, String expr) {
        CronTrigger trigger = null;
        try {
            trigger = new CronTrigger("temp", "temp", expr);
            Date nextFireTime = trigger.getFireTimeAfter(null);
            if (nextFireTime == null) {
                String str = this.getText("filter.subsription.cron.errormessage.filter.never.run", expr);
                context.getErrorCollection().addErrorMessage(str);
            }
        }
        catch (ParseException e) {
            this.errorMapper.mapError(context, e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            String str = this.getText("filter.subsription.cron.errormessage.general.error", expr);
            log.info((Object)str, (Throwable)e);
            context.getErrorCollection().addErrorMessage(str);
        }
        return trigger;
    }

    public void storeSubscription(JiraServiceContext context, Long filterId, String groupName, String expr, boolean emailOnEmpty) {
        CronTrigger trigger = this.validateAndCreateCronTrigger(context, expr);
        if (trigger != null && !context.getErrorCollection().hasAnyErrors()) {
            this.subscriptionManager.createSubscription(context.getLoggedInUser(), filterId, groupName, (Trigger)trigger, Boolean.valueOf(emailOnEmpty));
        }
    }

    public void updateSubscription(JiraServiceContext context, Long subscriptionId, String groupName, String expr, boolean emailOnEmpty) {
        CronTrigger trigger = this.validateAndCreateCronTrigger(context, expr);
        if (trigger != null && !context.getErrorCollection().hasAnyErrors()) {
            this.subscriptionManager.updateSubscription(context.getLoggedInUser(), subscriptionId, groupName, (Trigger)trigger, Boolean.valueOf(emailOnEmpty));
        }
    }

    public String getPrettySchedule(JiraServiceContext context, String cronExpression) {
        CronExpressionParser cronExpresionParser = new CronExpressionParser(cronExpression);
        if (cronExpresionParser.isValidForEditor()) {
            CronEditorBean cronEditorBean = cronExpresionParser.getCronEditorBean();
            return new CronExpressionDescriptor(this.jiraAuthenticationContext.getI18nHelper()).getPrettySchedule(cronEditorBean);
        }
        return cronExpression;
    }

    public Collection<GenericValue> getVisibleSubscriptions(User user, SearchRequest filter) {
        if (filter != null && user != null) {
            try {
                if (UserNames.equal(filter.getOwnerUserName(), user)) {
                    return this.subscriptionManager.getAllSubscriptions(filter.getId());
                }
                return this.subscriptionManager.getSubscriptions(user, filter.getId());
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    protected String getText(String key, Object param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }
}

