/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.config;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultConstantsService
implements ConstantsService {
    private final I18nHelper.BeanFactory i18n;
    private final ConstantsManager constantsMgr;
    private final PermissionManager permissionMgr;
    private final WorkflowSchemeManager workflowSchemeMgr;
    private final WorkflowManager workflowMgr;
    private final IssueTypeSchemeManager issueTypeSchemeMgr;

    public DefaultConstantsService(I18nHelper.BeanFactory i18n, ConstantsManager constantsManager, PermissionManager permissionManager, WorkflowSchemeManager workflowSchemeMgr, WorkflowManager workflowMgr, IssueTypeSchemeManager issueTypeSchemeMgr) {
        this.constantsMgr = constantsManager;
        this.permissionMgr = permissionManager;
        this.workflowSchemeMgr = workflowSchemeMgr;
        this.workflowMgr = workflowMgr;
        this.i18n = i18n;
        this.issueTypeSchemeMgr = issueTypeSchemeMgr;
    }

    public ServiceOutcome<Status> getStatusById(User user, String statusId) {
        Status status = this.constantsMgr.getStatusObject(statusId);
        if (status != null) {
            Collection visibleProjects = this.permissionMgr.getProjectObjects(10, user);
            for (Project project : visibleProjects) {
                List<JiraWorkflow> workflows = this.getWorkflows(project);
                for (JiraWorkflow workflow : workflows) {
                    List steps = workflow.getDescriptor().getSteps();
                    for (StepDescriptor step : steps) {
                        String linkedStatusId = (String)step.getMetaAttributes().get("jira.status.id");
                        if (!statusId.equals(linkedStatusId)) continue;
                        return ServiceOutcomeImpl.ok(status);
                    }
                }
            }
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusId));
    }

    public ServiceOutcome<IssueType> getIssueTypeById(User user, String issueTypeId) {
        IssueType issueType = this.constantsMgr.getIssueTypeObject(issueTypeId);
        if (issueType != null) {
            Collection visibleProjects = this.permissionMgr.getProjectObjects(10, user);
            for (Project project : visibleProjects) {
                for (IssueType visibleType : this.issueTypeSchemeMgr.getIssueTypesForProject(project)) {
                    if (!issueTypeId.equals(visibleType.getId())) continue;
                    return ServiceOutcomeImpl.ok(issueType);
                }
            }
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.issuetype.not.found", issueTypeId));
    }

    private List<JiraWorkflow> getWorkflows(Project project) {
        try {
            GenericValue workflowScheme = this.workflowSchemeMgr.getWorkflowScheme(project.getGenericValue());
            if (workflowScheme == null) {
                return Collections.singletonList(this.workflowMgr.getDefaultWorkflow());
            }
            ArrayList<GenericValue> workflows = new ArrayList<GenericValue>();
            workflows.add(this.workflowSchemeMgr.getDefaultEntity(workflowScheme));
            workflows.addAll(this.workflowSchemeMgr.getNonDefaultEntities(workflowScheme));
            if (workflows.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<JiraWorkflow> result = new ArrayList<JiraWorkflow>(workflows.size());
            for (GenericValue workflow : workflows) {
                result.add(this.workflowMgr.getWorkflow(workflow.getString("workflow")));
            }
            return result;
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
    }
}

