/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarImpl;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarPickerHelper;
import com.atlassian.jira.avatar.Selection;
import com.atlassian.jira.avatar.TemporaryAvatar;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.LimitedOutputStream;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import com.google.common.collect.Lists;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;
import webwork.config.Configuration;

public class AvatarPickerHelperImpl
implements AvatarPickerHelper {
    private static final Logger log = Logger.getLogger(AvatarPickerHelperImpl.class);
    private static final List<String> CONTENT_TYPES = Lists.newArrayList((Object[])new String[]{"image/jpeg", "image/gif", "image/png", "image/pjpeg", "image/x-png"});
    private static final int MAX_SIDE_LENGTH = 500;
    private static final String AVATAR_IMAGE_FORMAT = "png";
    private static final String TEMP_FILE_PREFIX = "JIRA-avatar";
    private static final String TEMP_FILE_EXTENSION = ".png";
    private static final int DEFAULT_MAX_MEGAPIXELS = 5;
    private AvatarManager avatarManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory requestContextFactory;
    private Thumber thumber;

    public AvatarPickerHelperImpl(AvatarManager avatarManager, JiraAuthenticationContext authenticationContext, ApplicationProperties properties, VelocityRequestContextFactory requestContextFactory) {
        this.avatarManager = avatarManager;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = properties;
        this.requestContextFactory = requestContextFactory;
        this.thumber = new Thumber(Thumbnail.MimeType.PNG);
    }

    @Override
    public Result<TemporaryAvatarBean> upload(InputStream stream, String fileName, String contentType, long size, String ownerId, Avatar.Type type) {
        if (!this.isAllowedToPickAvatar(ownerId, type)) {
            return new Result().addError(null, ErrorCollection.Reason.FORBIDDEN);
        }
        if (!this.isImageContent(contentType)) {
            if (fileName != null && !fileName.contains(".")) {
                log.info((Object)("Received avatar upload with unsupported content type: " + contentType + " and no extension"));
                return new Result().addError(this.getText("avatarpicker.upload.contenttype.no.ext.failure"), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            log.info((Object)("Received avatar upload with unsupported content type: " + contentType));
            return new Result().addError(this.getText("avatarpicker.upload.contenttype.failure"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        Long largestAttachmentSize = new Long(Configuration.getString((String)"webwork.multipart.maxSize"));
        if (size > largestAttachmentSize) {
            return new Result().addError(this.getText("avatarpicker.upload.size.toobig", fileName, FileSize.format((Long)largestAttachmentSize)), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        Result<File> copyResult = this.copyStreamToTempFile(stream, fileName, size);
        if (!copyResult.isValid()) {
            return new Result<TemporaryAvatarBean>(copyResult);
        }
        File file = copyResult.getResult();
        String invalidChars = new FileNameCharacterCheckerUtil().assertFileNameDoesNotContainInvalidChars(fileName);
        if (invalidChars == null) {
            Image image;
            Result<File> scaledFile = this.clampSize(file, 500);
            if (!scaledFile.isValid()) {
                return new Result<TemporaryAvatarBean>(scaledFile);
            }
            try {
                image = this.thumber.getImage(scaledFile.getResult());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            TemporaryAvatar tempAvatar = new TemporaryAvatar(contentType, fileName, scaledFile.getResult());
            ExecutingHttpRequest.get().getSession().setAttribute("tempAvatarFile", (Object)tempAvatar);
            if (image.getWidth(null) <= AvatarManager.ImageSize.LARGE.getPixels() && image.getHeight(null) == image.getWidth(null)) {
                return new Result<TemporaryAvatarBean>(new TemporaryAvatarBean(this.getTemporaryAvatarUrl(), image.getWidth(null), image.getHeight(null), false));
            }
            return new Result<TemporaryAvatarBean>(new TemporaryAvatarBean(this.getTemporaryAvatarUrl(), image.getWidth(null), image.getHeight(null), true));
        }
        return new Result().addError(this.getText("avatarpicker.upload.filename.failure", invalidChars), ErrorCollection.Reason.VALIDATION_FAILED);
    }

    @Override
    public Result<Avatar> convertTemporaryToReal(String ownerId, Avatar.Type type, Selection selection) {
        if (!this.isAllowedToPickAvatar(ownerId, type)) {
            return new Result().addError(null, ErrorCollection.Reason.FORBIDDEN);
        }
        TemporaryAvatar temporaryAvatar = (TemporaryAvatar)ExecutingHttpRequest.get().getSession().getAttribute("tempAvatarFile");
        if (temporaryAvatar == null) {
            return new Result().addError(this.getText("avatarpicker.upload.failure"), ErrorCollection.Reason.SERVER_ERROR);
        }
        int maxOffset = 500 - AvatarManager.ImageSize.LARGE.getPixels();
        if (selection.getTopLeftX() < 0 || selection.getTopLeftY() < 0 || selection.getTopLeftX() > maxOffset || selection.getTopLeftY() > maxOffset) {
            return new Result().addError(this.getText("avatarpicker.upload.failure"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        AvatarImpl newAvatar = AvatarImpl.createCustomAvatar(temporaryAvatar.getOriginalFilename(), temporaryAvatar.getContentType(), type, ownerId);
        try {
            newAvatar = this.avatarManager.create((Avatar)newAvatar, (InputStream)new FileInputStream(temporaryAvatar.getFile()), selection);
        }
        catch (IOException e) {
            log.error((Object)"Unable to create avatar.", (Throwable)e);
            return new Result().addError(this.getText("avatarpicker.upload.temp.io", e.getMessage()), ErrorCollection.Reason.SERVER_ERROR);
        }
        if (temporaryAvatar.getFile().delete()) {
            log.debug((Object)("Deleted temporary avatar file " + temporaryAvatar.getFile().getAbsolutePath()));
        } else {
            log.info((Object)("Couldn't delete temporary avatar file. Will retry on shutdown. " + temporaryAvatar.getFile().getAbsolutePath()));
        }
        return new Result<Avatar>(newAvatar);
    }

    private boolean isAllowedToPickAvatar(String ownerId, Avatar.Type type) {
        return StringUtils.isBlank((String)ownerId) || this.avatarManager.hasPermissionToEdit(this.authenticationContext.getLoggedInUser(), type, ownerId);
    }

    private Result<File> copyStreamToTempFile(InputStream stream, String fileName, long size) {
        Result<File> fileResult = this.createTemporaryFile(null);
        if (!fileResult.isValid()) {
            return fileResult;
        }
        File tempFile = fileResult.getResult();
        LimitedOutputStream limitedOutput = null;
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
            if (size >= 0L) {
                limitedOutput = new LimitedOutputStream(new BufferedOutputStream(outputStream), size);
                outputStream = limitedOutput;
            }
            IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
            ((OutputStream)outputStream).close();
            if (limitedOutput != null && limitedOutput.getCurrentLength() != size) {
                AvatarPickerHelperImpl.deleteFileIfExists(tempFile);
                String text = limitedOutput.getCurrentLength() == 0L ? this.getText("avatarpicker.upload.size.zero") : this.getText("avatarpicker.upload.size.wrong");
                return new Result().addError(text, ErrorCollection.Reason.VALIDATION_FAILED);
            }
            return fileResult;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(outputStream);
            AvatarPickerHelperImpl.deleteFileIfExists(tempFile);
            if (e instanceof LimitedOutputStream.TooBigIOException) {
                LimitedOutputStream.TooBigIOException tooBigIOException = (LimitedOutputStream.TooBigIOException)e;
                return new Result().addError(this.getText("avatarpicker.upload.size.toobig", fileName, FileSize.format((long)tooBigIOException.getMaxSize())), ErrorCollection.Reason.VALIDATION_FAILED);
            }
            log.debug((Object)"I/O error occured while attaching file.", (Throwable)e);
            return new Result().addError(this.getText("attachfile.error.io.error", fileName, e.getMessage()), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    private String getBaseUrl() {
        return this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    private boolean isImageContent(String contentType) {
        return contentType != null && CONTENT_TYPES.contains(contentType.toLowerCase());
    }

    private Result<File> clampSize(File sourceFile, int edgeSize) {
        int maxPixels;
        int sourceWidth;
        Image sourceImage = null;
        try {
            sourceImage = this.thumber.getImage(sourceFile);
        }
        catch (IOException e) {
            log.error((Object)e);
            new Result().addError(this.getText("avatarpicker.upload.image.corrupted"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (sourceImage == null) {
            return new Result().addError(this.getText("avatarpicker.upload.image.corrupted"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        int sourceHeight = sourceImage.getHeight(null);
        if (sourceHeight * (sourceWidth = sourceImage.getWidth(null)) > (maxPixels = this.getMaxMegaPixels()) * 1000000) {
            return new Result().addError(this.getText("avatarpicker.upload.too.big", maxPixels), ErrorCollection.Reason.VALIDATION_FAILED);
        }
        if (sourceHeight > edgeSize || sourceWidth > edgeSize) {
            return this.cropImageToFile(edgeSize, sourceImage);
        }
        return new Result<File>(sourceFile);
    }

    private Result<File> cropImageToFile(int edgeSize, Image sourceImage) {
        Result<File> prescaledFile = this.createTemporaryFile(TEMP_FILE_EXTENSION);
        if (!prescaledFile.isValid()) {
            return prescaledFile;
        }
        Thumber.WidthHeightHelper dimensions = this.thumber.determineScaleSize(edgeSize, edgeSize, sourceImage.getWidth(null), sourceImage.getHeight(null));
        BufferedImage scaledImage = this.thumber.scaleImage(sourceImage, dimensions);
        try {
            ImageIO.write((RenderedImage)scaledImage, AVATAR_IMAGE_FORMAT, prescaledFile.getResult());
        }
        catch (IOException e) {
            return new Result().addError(this.getText("avatarpicker.upload.temp.io", e.getMessage()), ErrorCollection.Reason.SERVER_ERROR);
        }
        return prescaledFile;
    }

    private int getMaxMegaPixels() {
        String megaPixels = this.applicationProperties.getDefaultBackedString("jira.avatar.megapixels");
        if (StringUtils.isNotBlank((String)megaPixels) && StringUtils.isNumeric((String)megaPixels)) {
            return Integer.parseInt(megaPixels);
        }
        return 5;
    }

    public boolean isTemporaryAvatarExistent() {
        boolean tempAvatarExists = null != ActionContext.getSession().get("tempAvatarFile");
        log.debug((Object)("does avatar exist? " + tempAvatarExists));
        return tempAvatarExists;
    }

    @Override
    public String getTemporaryAvatarUrl() {
        return this.getBaseUrl() + "/secure/temporaryavatar?cropped=true&magic=" + System.currentTimeMillis();
    }

    private static void deleteFileIfExists(File file) {
        if (file.exists() && !file.delete()) {
            log.warn((Object)("Unable to delete file '" + file + "'."));
        }
    }

    private String getText(String text) {
        return this.authenticationContext.getI18nHelper().getText(text);
    }

    private String getText(String text, Object ... args) {
        return this.authenticationContext.getI18nHelper().getText(text, (Object)args);
    }

    private Result<File> createTemporaryFile(String suffix) {
        try {
            File tempFile = File.createTempFile(TEMP_FILE_PREFIX, suffix);
            tempFile.deleteOnExit();
            return new Result<File>(tempFile);
        }
        catch (IOException e) {
            return new Result().addError(this.getText("avatarpicker.upload.temp.fail"), ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    public static class TemporaryAvatarBean {
        private final String url;
        private final boolean needsCropping;
        private int cropperWidth = -1;
        private int cropperOffsetX = -1;
        private int cropperOffsetY = -1;

        public TemporaryAvatarBean(String url, int width, int height, boolean needsCropping) {
            this.url = url;
            this.needsCropping = needsCropping;
            if (needsCropping) {
                this.setCroppingCoordinates(width, height);
            }
        }

        public boolean isCroppingNeeded() {
            return this.needsCropping;
        }

        public String getUrl() {
            return this.url;
        }

        public int getCropperWidth() {
            return this.cropperWidth;
        }

        public int getCropperOffsetX() {
            return this.cropperOffsetX;
        }

        public int getCropperOffsetY() {
            return this.cropperOffsetY;
        }

        private void setCroppingCoordinates(int width, int height) {
            int baseSize = AvatarManager.ImageSize.LARGE.getPixels();
            this.cropperOffsetX = width <= baseSize ? 0 : (width - baseSize) / 5;
            this.cropperOffsetY = height <= baseSize ? 0 : (height - baseSize) / 5;
            if (this.cropperWidth == -1) {
                int minWidth = Math.min(width, height);
                this.cropperWidth = minWidth <= baseSize ? minWidth : baseSize + (minWidth - baseSize) / 3;
            }
        }
    }

    public static class Result<T> {
        ErrorCollection errorCollection = new SimpleErrorCollection();
        private T result;

        Result() {
        }

        Result(T t) {
            this.result = t;
        }

        Result(Result<?> result) {
            this.errorCollection = result.getErrorCollection();
        }

        public ErrorCollection getErrorCollection() {
            return this.errorCollection;
        }

        public T getResult() {
            return this.result;
        }

        public boolean isValid() {
            return !this.errorCollection.hasAnyErrors();
        }

        Result<T> setResult(T t) {
            this.result = t;
            return this;
        }

        Result<T> addError(String message, ErrorCollection.Reason reason) {
            this.errorCollection.addErrorMessage(message, reason);
            return this;
        }
    }
}

