/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;

public final class AvatarImpl
implements Avatar {
    private final Long id;
    private final String fileName;
    private final Avatar.Type avatarType;
    private final String owner;
    private final boolean systemAvatar;
    private String contentType;

    AvatarImpl(Long id, String fileName, String contentType, Avatar.Type avatarType, String owner, boolean systemAvatar) {
        this.id = id;
        this.fileName = (String)Assertions.notNull((String)"fileName", (Object)fileName);
        this.contentType = (String)Assertions.notNull((String)"contentType", (Object)contentType);
        this.avatarType = (Avatar.Type)Assertions.notNull((String)"avatarType", (Object)avatarType);
        if (!systemAvatar) {
            Assertions.notNull((String)"owner", (Object)owner);
        } else if (owner != null) {
            throw new IllegalArgumentException("owner must be null for system avatars");
        }
        this.owner = owner;
        this.systemAvatar = systemAvatar;
    }

    public static AvatarImpl createCustomAvatar(String fileName, String contentType, Avatar.Type avatarType, String owner) {
        return new AvatarImpl(null, fileName, contentType, avatarType, owner, false);
    }

    public static AvatarImpl createSystemAvatar(String fileName, String contentType, Avatar.Type avatarType) {
        return new AvatarImpl(null, fileName, contentType, avatarType, null, true);
    }

    public Avatar.Type getAvatarType() {
        return this.avatarType;
    }

    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    public String getContentType() {
        return this.contentType;
    }

    public Long getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isSystemAvatar() {
        return this.systemAvatar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvatarImpl avatar = (AvatarImpl)o;
        if (this.systemAvatar != avatar.systemAvatar) {
            return false;
        }
        if (this.avatarType != avatar.avatarType) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(avatar.fileName) : avatar.fileName != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(avatar.id) : avatar.id != null) {
            return false;
        }
        return !(this.owner != null ? !this.owner.equals(avatar.owner) : avatar.owner != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + (this.avatarType != null ? this.avatarType.hashCode() : 0);
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + (this.systemAvatar ? 1 : 0);
        return result;
    }
}

