/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.db;

import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.upgrade.util.UpgradeUtils;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BuildVersionCheck
implements StartupCheck {
    private static final Logger log = Logger.getLogger(BuildVersionCheck.class);
    private static final String NAME = "JIRA Build Version Check";
    private static final String JIRA_IGNORE_BUILD_VERSION = "jira.ignore.buildversion";
    private final BuildUtilsInfo buildUtilsInfo = new BuildUtilsInfoImpl();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isOk() {
        Boolean dontPerformCheck = Boolean.valueOf(System.getProperty(JIRA_IGNORE_BUILD_VERSION));
        if (dontPerformCheck.booleanValue()) {
            log.warn((Object)"Not performing Jira Build Version check since jira.ignore.buildversion is set to 'true'");
        } else if (this.databaseSetup()) {
            log.debug((Object)"Performing version check");
            int applicationBuildVersionNumber = this.getAppBuildNumber();
            int databaseBuildVersionNumber = this.getDbBuildNumber();
            if (databaseBuildVersionNumber > applicationBuildVersionNumber) {
                log.debug((Object)("There is a data consistency error: Database build number is: " + databaseBuildVersionNumber + ", Application build number is: " + applicationBuildVersionNumber));
                return false;
            }
        }
        return true;
    }

    private boolean databaseSetup() {
        return UpgradeUtils.tableExists("project");
    }

    @Override
    public String getHTMLFaultDescription() {
        StringBuffer message = new StringBuffer(512);
        message.append("<p>Failed to start JIRA due to a build number inconsistency.</p>");
        message.append("<p>The data present in your database is newer than the version of JIRA you are trying to startup.</p>");
        message.append("<p>Database version is: ").append(this.getDbBuildNumber()).append("</p>");
        message.append("<p>JIRA app version is: ").append(this.getAppBuildNumber()).append("</p>");
        message.append("<p>Please use the correct version of JIRA. You are running: ").append(this.buildUtilsInfo.getBuildInformation()).append("</p>");
        return message.toString();
    }

    @Override
    public void stop() {
    }

    @Override
    public String getFaultDescription() {
        StringBuffer message = new StringBuffer(512);
        message.append("\n\n");
        message.append(StringUtils.repeat((String)"*", (int)100)).append("\n");
        message.append("Failed to start JIRA due to a build number inconsistency.\n");
        message.append("The data present in your database is newer than the version of JIRA you are trying to startup.\n");
        message.append("Database version is: ").append(this.getDbBuildNumber()).append("\n");
        message.append("JIRA app version is: ").append(this.getAppBuildNumber()).append("\n");
        message.append("Please use the correct version of JIRA. You are running: ").append(this.buildUtilsInfo.getBuildInformation()).append("\n");
        message.append(StringUtils.repeat((String)"*", (int)100)).append("\n");
        return message.toString();
    }

    private int getDbBuildNumber() {
        return this.buildUtilsInfo.getDatabaseBuildNumber();
    }

    private int getAppBuildNumber() {
        return this.buildUtilsInfo.getApplicationBuildNumber();
    }

    public String toString() {
        return NAME;
    }
}

