/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.diff;

import com.atlassian.diff.DiffChunk;
import com.atlassian.diff.DiffType;
import com.atlassian.diff.WordChunk;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.lang.StringUtils;

public class WordLevelDiffer {
    private static final Pattern WORD = Pattern.compile("[\\p{Alnum}_]+|\\S|(\r\n|\r|\n)");

    public static List<DiffChunk> diffLine(String originalLine, String revisedLine) throws DifferentiationFailedException {
        Word[] originalWords = WordLevelDiffer.tokenize(originalLine);
        Word[] revisedWords = WordLevelDiffer.tokenize(revisedLine);
        return WordLevelDiffer.diffWords(originalWords, revisedWords);
    }

    static List<DiffChunk> diffWords(Word[] originalContent, Word[] revisedContent) throws DifferentiationFailedException {
        ArrayList<DiffChunk> wordChunks = new ArrayList<DiffChunk>();
        if (originalContent.length == 0 && revisedContent.length == 0) {
            return null;
        }
        Revision revision = new Diff((Object[])originalContent).diff((Object[])revisedContent);
        Chunk previousOriginalChunk = null;
        int numDeltas = revision.size();
        for (int deltaIndex = 0; deltaIndex < numDeltas; ++deltaIndex) {
            Delta delta = revision.getDelta(deltaIndex);
            Chunk originalChunk = delta.getOriginal();
            Chunk revisedChunk = delta.getRevised();
            WordChunk unchangedChunk = WordLevelDiffer.getUnchangedWordsBetweenChunks(originalContent, previousOriginalChunk, originalChunk);
            if (unchangedChunk != null) {
                wordChunks.add(unchangedChunk);
            }
            List originalChunkWords = originalChunk.chunk();
            List revisedChunkWords = revisedChunk.chunk();
            if (delta instanceof DeleteDelta || delta instanceof ChangeDelta) {
                String deletedChunkText = WordLevelDiffer.join(originalChunkWords);
                if (StringUtils.isEmpty((String)deletedChunkText)) {
                    deletedChunkText = " ";
                }
                wordChunks.add(new WordChunk(DiffType.DELETED_WORDS, deletedChunkText));
            }
            if (delta instanceof AddDelta || delta instanceof ChangeDelta) {
                String addedChunkText = WordLevelDiffer.join(revisedChunkWords);
                if (StringUtils.isEmpty((String)addedChunkText)) {
                    addedChunkText = " ";
                }
                wordChunks.add(new WordChunk(DiffType.ADDED_WORDS, addedChunkText));
            }
            previousOriginalChunk = originalChunk;
        }
        WordChunk unchangedChunk = WordLevelDiffer.getUnchangedWordsBetweenChunks(originalContent, previousOriginalChunk, null);
        if (unchangedChunk != null) {
            wordChunks.add(unchangedChunk);
        }
        return wordChunks;
    }

    static WordChunk getUnchangedWordsBetweenChunks(Word[] originalContent, Chunk chunkBefore, Chunk chunkAfter) {
        int unchangedEnd;
        int unchangedStart = chunkBefore != null ? chunkBefore.last() + 1 : 0;
        int n = unchangedEnd = chunkAfter != null ? chunkAfter.first() : originalContent.length;
        if (unchangedEnd <= unchangedStart) {
            return null;
        }
        String chunkText = WordLevelDiffer.join(originalContent, unchangedStart, unchangedEnd);
        return new WordChunk(DiffType.UNCHANGED, chunkText);
    }

    static Word[] tokenize(String input) {
        LinkedList<Word> tokens = new LinkedList<Word>();
        Matcher m = WORD.matcher(input);
        int last = 0;
        while (m.find(last)) {
            int start = m.start();
            String leading = input.substring(last, start);
            tokens.add(new Word(leading, m.group(), ""));
            last = m.end();
        }
        if (last < input.length()) {
            tokens.add(new Word("", input.substring(last), ""));
        }
        return tokens.toArray(new Word[tokens.size()]);
    }

    private static String join(Iterable<Word> words) {
        StringBuilder b = new StringBuilder();
        for (Word w : words) {
            b.append(w.leading);
            b.append(w.word);
            b.append(w.trailing);
        }
        return b.toString();
    }

    private static String join(Word[] words, int start, int end) {
        StringBuilder b = new StringBuilder();
        for (int i = start; i < words.length && i < end; ++i) {
            Word w = words[i];
            b.append(w.leading);
            b.append(w.word);
            b.append(w.trailing);
        }
        return b.toString();
    }

    static class Word {
        final String leading;
        final String word;
        final String trailing;

        Word(String leading, String word, String trailing) {
            this.leading = leading;
            this.word = word;
            this.trailing = trailing;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Word word1 = (Word)o;
            return this.word.equals(word1.word);
        }

        public int hashCode() {
            return this.word.hashCode();
        }
    }
}

