/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.velocity.DefaultVelocityManager;
import com.atlassian.velocity.DelegateDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class JiraVelocityManager
extends DefaultVelocityManager {
    private static final Logger log = Logger.getLogger(JiraVelocityManager.class);
    private final DateTimeFormatter dateTimeFormatter;
    private final LazyReference<VelocityEngine> velocityEngine = new LazyReference<VelocityEngine>(){

        protected VelocityEngine create() throws Exception {
            VelocityEngine result = new VelocityEngine();
            JiraVelocityManager.this.initVe(result);
            return result;
        }
    };

    public JiraVelocityManager(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE) : null;
    }

    public DateFormat getDateFormat() {
        return new DelegateDateFormat((Supplier<DateFormat>)new DateFormatSupplier());
    }

    protected VelocityContext createVelocityContext(Map params) {
        return super.createVelocityContext(CompositeMap.of(new HashMap(), (Map)params));
    }

    protected Map<String, ?> createContextParams(String baseurl, Map contextParameters) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("baseurl", baseurl);
        result.put("formatter", this.getDateFormat());
        return CompositeMap.of((Map)contextParameters, result);
    }

    protected VelocityEngine getVe() {
        return (VelocityEngine)this.velocityEngine.get();
    }

    protected void initVe(VelocityEngine velocityEngine) {
        try {
            Properties props = new Properties();
            try {
                props.load(ClassLoaderUtils.getResourceAsStream((String)"velocity.properties", ((Object)((Object)this)).getClass()));
            }
            catch (Exception e) {
                props.put("resource.loader", "class");
                props.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
                props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            }
            if (JiraSystemProperties.isDevMode()) {
                props.put("class.resource.loader.cache", "false");
                props.put("velocimacro.library.autoreload", "true");
                props.put("plugin.resource.loader.cache", "false");
            }
            velocityEngine.init(props);
        }
        catch (Exception e) {
            log.error((Object)("Exception initialising Velocity: " + e), (Throwable)e);
        }
    }

    class DateFormatSupplier
    extends LazyReference<DateFormat> {
        DateFormatSupplier() {
        }

        protected DateFormat create() {
            return new SimpleDateFormat(JiraVelocityManager.this.dateTimeFormatter.getFormatHint());
        }
    }

    static final class Key {
        static final String BASE_URL = "baseurl";
        static final String FORMATTER = "formatter";

        Key() {
        }
    }
}

