/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultWorkflowSchemeManager
extends AbstractSchemeManager
implements WorkflowSchemeManager,
Startable {
    private static final Logger log = Logger.getLogger(DefaultWorkflowSchemeManager.class);
    private static final String ALL_ISSUE_TYPES = "0";
    private static final String SCHEME_ENTITY_NAME = "WorkflowScheme";
    private static final String WORKFLOW_ENTITY_NAME = "WorkflowSchemeEntity";
    private static final String SCHEME_DESC = "Workflow";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.workflows.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.workflows.default.desc";
    private static final String COLUMN_ISSUETYPE = "issuetype";
    private static final String COLUMN_WORKFLOW = "workflow";
    private final Map<Long, Map<String, GenericValue>> cache = new ConcurrentHashMap<Long, Map<String, GenericValue>>();
    private final ActiveWorkflowCache activeWorkflowCache = new ActiveWorkflowCache();
    private final WorkflowManager workflowManager;
    private final ConstantsManager constantsManager;
    private final OfBizDelegator ofBizDelegator;
    private final EventPublisher eventPublisher;

    public DefaultWorkflowSchemeManager(ProjectManager projectManager, PermissionTypeManager permissionTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, WorkflowManager workflowManager, ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, EventPublisher eventPublisher, AssociationManager associationManager, GroupManager groupManager) {
        super(projectManager, permissionTypeManager, permissionContextFactory, schemeFactory, associationManager, ofBizDelegator, groupManager);
        this.workflowManager = workflowManager;
        this.constantsManager = constantsManager;
        this.ofBizDelegator = ofBizDelegator;
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.clearWorkflowCache();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return WORKFLOW_ENTITY_NAME;
    }

    public void clearWorkflowCache() {
        this.activeWorkflowCache.clear();
        this.clearCache();
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    public GenericValue getWorkflowScheme(GenericValue project) throws GenericEntityException {
        return EntityUtil.getOnly(this.getSchemes(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (!(schemeEntity.getEntityTypeId() instanceof String)) {
            throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
        }
        try {
            GenericValue genericValue = EntityUtils.createValue(this.getEntityName(), ImmutableMap.of((Object)"scheme", (Object)scheme.getLong("id"), (Object)COLUMN_WORKFLOW, (Object)schemeEntity.getType(), (Object)COLUMN_ISSUETYPE, (Object)schemeEntity.getEntityTypeId().toString()));
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    private void clearCache() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing workflow scheme entity cache, had " + this.cache.size() + " entries"));
        }
        this.cache.clear();
    }

    public List<GenericValue> getEntities(GenericValue scheme, String issuetype) throws GenericEntityException {
        Map<String, GenericValue> genericValueMap = this.getSchemeMap(scheme);
        GenericValue value = genericValueMap.get(issuetype);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(value);
    }

    public Map<String, String> getWorkflowMap(Project project) {
        GenericValue schemeForProject = this.getSchemeForProject(project);
        if (schemeForProject == null) {
            return MapBuilder.build(null, (Object)"jira");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, GenericValue> schemeMap = this.getSchemeMap(schemeForProject);
        for (Map.Entry<String, GenericValue> entry : schemeMap.entrySet()) {
            String workflow = entry.getValue().getString(COLUMN_WORKFLOW);
            if (entry.getKey() == null || workflow == null) continue;
            if (ALL_ISSUE_TYPES.equals(entry.getKey())) {
                result.put(null, workflow);
                continue;
            }
            result.put(entry.getKey(), workflow);
        }
        return result;
    }

    public String getWorkflowName(Project project, String issueType) {
        return this.getWorkflowName(this.getSchemeForProject(project), issueType);
    }

    public String getWorkflowName(GenericValue scheme, String issueType) {
        if (scheme != null) {
            Map<String, GenericValue> map = this.getSchemeMap(scheme);
            GenericValue value = map.get(issueType);
            if (value == null) {
                value = map.get(ALL_ISSUE_TYPES);
            }
            if (value != null) {
                return value.getString(COLUMN_WORKFLOW);
            }
        }
        return "jira";
    }

    private GenericValue getSchemeForProject(Project project) {
        try {
            return EntityUtil.getOnly(this.getSchemes(project.getGenericValue()));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private static Long getCacheKeyForScheme(GenericValue scheme) {
        return scheme.getLong("id");
    }

    private Map<String, GenericValue> getSchemeMap(GenericValue scheme) {
        List<GenericValue> valueList;
        if (scheme == null) {
            return Collections.emptyMap();
        }
        Long cacheKeyForScheme = DefaultWorkflowSchemeManager.getCacheKeyForScheme(scheme);
        Map<String, GenericValue> cachedEntry = this.cache.get(cacheKeyForScheme);
        if (cachedEntry != null) {
            return cachedEntry;
        }
        try {
            valueList = this.getEntities(scheme);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        HashMap<String, GenericValue> schemeMap = new HashMap();
        for (GenericValue value : valueList) {
            String issueType = value.getString(COLUMN_ISSUETYPE);
            if (issueType == null) continue;
            schemeMap.put(issueType, value);
        }
        schemeMap = Collections.unmodifiableMap(schemeMap);
        this.cache.put(cacheKeyForScheme, schemeMap);
        return schemeMap;
    }

    @Override
    public GenericValue copySchemeEntity(GenericValue scheme, GenericValue entity) throws GenericEntityException {
        SchemeEntity schemeEntity = new SchemeEntity(entity.getString(COLUMN_WORKFLOW), (Object)entity.getString(COLUMN_ISSUETYPE));
        return this.createSchemeEntity(scheme, schemeEntity);
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long entityTypeId, String parameter) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Workflow scheme IDs must be String values.");
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity) {
        return false;
    }

    public boolean hasSchemeAuthority(Long entityType, GenericValue entity, User user, boolean issueCreation) {
        return false;
    }

    public GenericValue getDefaultEntity(GenericValue scheme) throws GenericEntityException {
        return EntityUtil.getOnly(this.getEntities(scheme, ALL_ISSUE_TYPES));
    }

    public List<GenericValue> getNonDefaultEntities(GenericValue scheme) throws GenericEntityException {
        List<GenericValue> entities = this.getEntities(scheme);
        Iterator<GenericValue> iterator = entities.iterator();
        while (iterator.hasNext()) {
            GenericValue genericValue = iterator.next();
            if (!ALL_ISSUE_TYPES.equals(genericValue.getString(COLUMN_ISSUETYPE))) continue;
            iterator.remove();
            break;
        }
        return entities;
    }

    public Collection<String> getActiveWorkflowNames() throws GenericEntityException, WorkflowException {
        return this.activeWorkflowCache.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkflowToScheme(GenericValue scheme, String workflowName, String issueTypeId) throws GenericEntityException {
        try {
            SchemeEntity schemeEntity = new SchemeEntity(workflowName, (Object)issueTypeId);
            if (this.getEntities(scheme, issueTypeId).isEmpty()) {
                this.createSchemeEntity(scheme, schemeEntity);
            }
        }
        finally {
            this.clearWorkflowCache();
        }
    }

    public void updateSchemesForRenamedWorkflow(String oldWorkflowName, String newWorkflowName) {
        if (StringUtils.isBlank((String)oldWorkflowName)) {
            throw new IllegalArgumentException("oldWorkflowName must not be null or empty string");
        }
        if (StringUtils.isBlank((String)newWorkflowName)) {
            throw new IllegalArgumentException("newWorkflowName must not be null or empty string");
        }
        this.ofBizDelegator.bulkUpdateByAnd(this.getEntityName(), EasyMap.build((Object)COLUMN_WORKFLOW, (Object)newWorkflowName), EasyMap.build((Object)COLUMN_WORKFLOW, (Object)oldWorkflowName));
        this.clearWorkflowCache();
    }

    public Collection<GenericValue> getSchemesForWorkflow(JiraWorkflow workflow) {
        LinkedList<GenericValue> schemes = new LinkedList<GenericValue>();
        try {
            HashSet<Long> schemeIds = new HashSet<Long>();
            List schemeEntities = this.ofBizDelegator.findByAnd(this.getEntityName(), MapBuilder.build((Object)COLUMN_WORKFLOW, (Object)workflow.getName()));
            for (GenericValue schemeEntity : schemeEntities) {
                Long schemeId = schemeEntity.getLong("scheme");
                if (schemeIds.contains(schemeId)) continue;
                schemes.add(this.getScheme(schemeId));
                schemeIds.add(schemeId);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error retrieving scheme entities for workflow '" + workflow.getName() + "'.", (Throwable)e);
        }
        return schemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        try {
            super.deleteEntity(id);
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        try {
            boolean bl = super.removeEntities(scheme, entityTypeId);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        try {
            GenericValue genericValue = super.createScheme(name, description);
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Scheme createSchemeObject(String name, String description) {
        try {
            Scheme scheme = super.createSchemeObject(name, description);
            return scheme;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushProjectSchemes() {
        try {
            super.flushProjectSchemes();
        }
        finally {
            this.clearCache();
        }
    }

    protected List<GenericValue> getAllIssueTypes() {
        return this.constantsManager.getAllIssueTypes();
    }

    protected JiraWorkflow getWorkflowFromScheme(GenericValue workflowScheme, String issueTypeId) {
        return this.workflowManager.getWorkflowFromScheme(workflowScheme, issueTypeId);
    }

    class ActiveWorkflowCache {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        @GuardedBy(value="lock")
        private Set<String> cache = null;

        ActiveWorkflowCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Set<String> get() throws GenericEntityException, WorkflowException {
            this.lock.readLock().lock();
            try {
                this.load();
                Set<String> set = this.cache;
                return set;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            this.lock.writeLock().lock();
            try {
                this.cache = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @GuardedBy(value="lock")
        private void load() throws GenericEntityException, WorkflowException {
            if (this.cache != null) {
                return;
            }
            HashSet<String> set = new HashSet<String>();
            List<GenericValue> schemes = DefaultWorkflowSchemeManager.this.getSchemes();
            for (GenericValue scheme : schemes) {
                if (DefaultWorkflowSchemeManager.this.getProjects(scheme).isEmpty()) continue;
                List<GenericValue> entities = DefaultWorkflowSchemeManager.this.getEntities(scheme);
                for (GenericValue schemeEntity : entities) {
                    set.add((String)schemeEntity.get(DefaultWorkflowSchemeManager.COLUMN_WORKFLOW));
                }
            }
            Collection projects = DefaultWorkflowSchemeManager.this.projectManager.getProjects();
            boolean checkComplete = false;
            for (GenericValue project : projects) {
                GenericValue workflowScheme = DefaultWorkflowSchemeManager.this.getWorkflowScheme(project);
                if (workflowScheme == null) {
                    set.add("jira");
                    checkComplete = true;
                } else {
                    List<GenericValue> issueTypes = DefaultWorkflowSchemeManager.this.getAllIssueTypes();
                    for (GenericValue issueType : issueTypes) {
                        String issueTypeId = issueType.getString("id");
                        JiraWorkflow workflow = DefaultWorkflowSchemeManager.this.getWorkflowFromScheme(workflowScheme, issueTypeId);
                        if (workflow.getName().equals("jira")) {
                            set.add("jira");
                            checkComplete = true;
                        }
                        if (!checkComplete) continue;
                        break;
                    }
                }
                if (!checkComplete) continue;
                break;
            }
            this.cache = Collections.unmodifiableSet(set);
        }
    }
}

