/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.core.util.FileSize;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LimitedOutputStream;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.web.util.AttachmentException;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import com.atlassian.jira.web.util.WebAttachmentManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import webwork.config.Configuration;
import webwork.multipart.MultiPartRequestWrapper;

public class DefaultWebAttachmentManager
implements WebAttachmentManager {
    private static final Logger log = Logger.getLogger(DefaultWebAttachmentManager.class);
    private final FileNameCharacterCheckerUtil fileNameCharacterCheckerUtil;
    private final AttachmentManager attachmentManager;
    private final I18nHelper.BeanFactory beanFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final TemporaryAttachmentsMonitorLocator locator;
    private final AttachmentService service;

    public DefaultWebAttachmentManager(AttachmentManager attachmentManager, I18nHelper.BeanFactory beanFactory, JiraAuthenticationContext authenticationContext, TemporaryAttachmentsMonitorLocator locator, AttachmentService service) {
        this.attachmentManager = attachmentManager;
        this.beanFactory = beanFactory;
        this.authenticationContext = authenticationContext;
        this.locator = locator;
        this.service = service;
        this.fileNameCharacterCheckerUtil = new FileNameCharacterCheckerUtil();
    }

    @Override
    public ChangeItemBean createAttachment(MultiPartRequestWrapper requestWrapper, User remoteUser, Issue issue, String fileParamName, Map<String, Object> attachmentProperties) throws AttachmentException {
        return this.createAttachment(requestWrapper, remoteUser, issue.getGenericValue(), fileParamName, attachmentProperties);
    }

    @Override
    public ChangeItemBean createAttachment(MultiPartRequestWrapper requestWrapper, User remoteUser, GenericValue issue, String fileParamName, Map<String, Object> attachmentProperties) throws AttachmentException {
        File file = requestWrapper.getFile(fileParamName);
        if (file == null) {
            log.warn((Object)String.format("Could not create attachment. No file found in MultiPartRequestWrapper. File param name: %s. Request wrapper filenames: %s.", fileParamName, CollectionBuilder.list((Object[])new Enumeration[]{requestWrapper.getFileNames()})));
            return null;
        }
        String filename = requestWrapper.getFilesystemName(fileParamName);
        String contentType = requestWrapper.getContentType(fileParamName);
        return this.attachmentManager.createAttachment(file, filename, contentType, remoteUser, issue, attachmentProperties, (Date)UtilDateTime.nowTimestamp());
    }

    @Override
    public TemporaryAttachment createTemporaryAttachment(MultiPartRequestWrapper requestWrapper, String fileParamName, Issue issue, Project project) throws AttachmentException {
        if (issue == null && project == null) {
            throw new IllegalArgumentException("'issue' and 'project' cannot be null at the same time.");
        }
        this.validateAttachmentIfExists(requestWrapper, fileParamName, false);
        File file = requestWrapper.getFile(fileParamName);
        if (file == null) {
            log.warn((Object)String.format("Could not create attachment. No file found in MultiPartRequestWrapper. File param name: %s. Request wrapper filenames: %s.", fileParamName, CollectionBuilder.list((Object[])new Enumeration[]{requestWrapper.getFileNames()})));
            return null;
        }
        this.assertCanAttach(issue, project);
        String filename = requestWrapper.getFilesystemName(fileParamName);
        String contentType = requestWrapper.getContentType(fileParamName);
        UniqueFile uniqueFile = this.createUniqueFile(file.getName());
        this.createTemporaryAttachmentOnDisk(file, uniqueFile.getFile());
        Long issueId = issue == null ? null : issue.getId();
        TemporaryAttachment temporaryAttachment = new TemporaryAttachment(Long.valueOf(uniqueFile.getId()), issueId, uniqueFile.getFile(), filename, contentType);
        this.addToMonitor(temporaryAttachment);
        return temporaryAttachment;
    }

    @Override
    public TemporaryAttachment createTemporaryAttachment(InputStream stream, String fileName, String contentType, long size, Issue issue, Project project) throws AttachmentException {
        Assertions.notBlank((String)"fileName", (String)fileName);
        Assertions.notBlank((String)"contentType", (String)contentType);
        Assertions.notNull((String)"stream", (Object)stream);
        if (issue == null && project == null) {
            throw new IllegalArgumentException("'issue' and 'project' cannot be null at the same time.");
        }
        if (size < 0L) {
            throw new IllegalArgumentException("size must be >= 0.");
        }
        if (size == 0L) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.file.zero", fileName));
        }
        long maxAttachmentSize = this.getMaxAttachmentSize();
        if (size > maxAttachmentSize) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.file.large", fileName, FileSize.format((long)maxAttachmentSize)));
        }
        this.assertCanAttach(issue, project);
        this.assertFileNameIsValid(fileName);
        UniqueFile uniqueFile = this.createUniqueFile(fileName);
        LimitedOutputStream limitedOutput = null;
        try {
            FileOutputStream fos = new FileOutputStream(uniqueFile.getFile());
            limitedOutput = this.wrapOutputStream(fos, size);
            IOUtils.copy((InputStream)stream, (OutputStream)limitedOutput);
            limitedOutput.close();
            if (limitedOutput.getCurrentLength() != size) {
                DefaultWebAttachmentManager.deleteFileIfExists(uniqueFile.getFile());
                String text = limitedOutput.getCurrentLength() == 0L ? this.getI18n().getText("attachfile.error.io.bad.size.zero", fileName) : this.getI18n().getText("attachfile.error.io.bad.size", fileName, String.valueOf(limitedOutput.getCurrentLength()), String.valueOf(size));
                throw new AttachmentException(text);
            }
            Long issueId = issue == null ? null : issue.getId();
            TemporaryAttachment temporaryAttachment = new TemporaryAttachment(Long.valueOf(uniqueFile.getId()), issueId, uniqueFile.getFile(), fileName, contentType);
            this.addToMonitor(temporaryAttachment);
            return temporaryAttachment;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(limitedOutput);
            DefaultWebAttachmentManager.deleteFileIfExists(uniqueFile.getFile());
            if (e instanceof LimitedOutputStream.TooBigIOException) {
                LimitedOutputStream.TooBigIOException tooBigIOException = (LimitedOutputStream.TooBigIOException)e;
                throw new AttachmentException(this.getI18n().getText("attachfile.error.file.large", fileName, FileSize.format((long)tooBigIOException.getNextSize())));
            }
            log.debug((Object)"I/O error occured while attaching file.", (Throwable)e);
            throw new AttachmentException(this.getI18n().getText("attachfile.error.io.error", fileName, e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean validateAttachmentIfExists(MultiPartRequestWrapper requestWrapper, String fileParamName, boolean required) throws AttachmentException {
        File file = requestWrapper.getFile(fileParamName);
        String filename = requestWrapper.getFilesystemName(fileParamName);
        return this.assertAttachmentIfExists(file, filename, required, requestWrapper.getContentLength());
    }

    private static void deleteFileIfExists(File file) {
        if (file.exists() && !file.delete()) {
            log.warn((Object)("Unable to delete file '" + file + "'."));
        }
    }

    void addToMonitor(TemporaryAttachment temporaryAttachment) throws AttachmentException {
        TemporaryAttachmentsMonitor attachmentsMonitor = this.locator.get(true);
        if (attachmentsMonitor == null) {
            DefaultWebAttachmentManager.deleteFileIfExists(temporaryAttachment.getFile());
            throw new AttachmentException(this.getI18n().getText("attachfile.error.session.error", temporaryAttachment.getFilename()));
        }
        attachmentsMonitor.add(temporaryAttachment);
    }

    private void createTemporaryAttachmentOnDisk(File file, File targetFile) throws AttachmentException {
        try {
            FileUtils.moveFile((File)file, (File)targetFile);
        }
        catch (IOException e) {
            String message = this.getI18n().getText("attachfile.error.move", (Object)file.getAbsolutePath(), (Object)targetFile.getAbsolutePath(), (Object)e);
            log.error((Object)message, (Throwable)e);
            throw new AttachmentException(message);
        }
    }

    LimitedOutputStream wrapOutputStream(OutputStream fos, long size) {
        return new LimitedOutputStream(new BufferedOutputStream(fos), size);
    }

    void assertFileNameIsValid(String filename) throws AttachmentException {
        if (StringUtils.isBlank((String)filename)) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.no.name"));
        }
        String invalidChar = this.fileNameCharacterCheckerUtil.assertFileNameDoesNotContainInvalidChars(filename);
        if (invalidChar != null) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.invalidcharacter", filename, invalidChar));
        }
    }

    boolean assertAttachmentIfExists(File file, String fileName, boolean required, int contentLength) throws AttachmentException {
        boolean exists = this.exists(file, fileName, contentLength);
        if (!exists) {
            if (required) {
                throw new AttachmentException(this.getI18n().getText("attachfile.error.filerequired"));
            }
        } else {
            this.assertFileNameIsValid(fileName);
        }
        return exists;
    }

    private boolean exists(File file, String fileName, int contentLength) throws AttachmentException {
        if (file == null) {
            if (fileName != null) {
                long attachmentSize = this.getMaxAttachmentSize();
                if ((long)contentLength > attachmentSize) {
                    throw new AttachmentException(this.getI18n().getText("attachfile.error.file.large", fileName, FileSize.format((long)attachmentSize)));
                }
                throw new AttachmentException(this.getI18n().getText("attachfile.error.file.zero", fileName));
            }
            return false;
        }
        if (file.length() == 0L) {
            throw new AttachmentException(this.getI18n().getText("attachfile.error.file.zero", fileName));
        }
        return true;
    }

    private long getUUID() {
        return Math.abs(UUID.randomUUID().getLeastSignificantBits());
    }

    UniqueFile createUniqueFile(String fileName) {
        long uniqueId;
        File tempAttachmentFile;
        File tmpDir = AttachmentUtils.getTemporaryAttachmentDirectory();
        while ((tempAttachmentFile = new File(tmpDir, (uniqueId = this.getUUID()) + "_" + fileName)).exists()) {
        }
        return new UniqueFile(tempAttachmentFile, uniqueId);
    }

    long getMaxAttachmentSize() {
        return Long.parseLong(Configuration.getString((String)"webwork.multipart.maxSize"));
    }

    I18nHelper getI18n() {
        return this.beanFactory.getInstance(this.authenticationContext.getLocale());
    }

    void assertIssueAttachmentDirectoryExists(Issue issue) throws AttachmentException {
        AttachmentUtils.checkValidAttachmentDirectory((Issue)issue);
    }

    void assertTemporaryDirectoryExists() throws AttachmentException {
        AttachmentUtils.checkValidTemporaryAttachmentDirectory();
    }

    void assertCanAttach(Issue issue, Project project) throws AttachmentException {
        if (issue == null) {
            JiraServiceContext context = this.createServiceContext();
            this.service.canCreateAttachments(context, project);
            DefaultWebAttachmentManager.throwForFirstError(context.getErrorCollection());
            this.assertTemporaryDirectoryExists();
        } else {
            JiraServiceContext context = this.createServiceContext();
            this.service.canCreateTemporaryAttachments(context, issue);
            DefaultWebAttachmentManager.throwForFirstError(context.getErrorCollection());
            this.assertIssueAttachmentDirectoryExists(issue);
        }
    }

    private JiraServiceContext createServiceContext() {
        return new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser(), (ErrorCollection)new SimpleErrorCollection(), this.authenticationContext.getI18nHelper());
    }

    private static void throwForFirstError(ErrorCollection collection) throws AttachmentException {
        if (collection.hasAnyErrors()) {
            String message = (String)DefaultWebAttachmentManager.getFirstElement(collection.getErrorMessages());
            if (message == null) {
                message = (String)DefaultWebAttachmentManager.getFirstElement(collection.getErrors().values());
            }
            throw new AttachmentException(message);
        }
    }

    private static <T> T getFirstElement(Collection<? extends T> values) {
        if (!values.isEmpty()) {
            return values.iterator().next();
        }
        return null;
    }

    static class UniqueFile {
        private final File file;
        private final long id;

        UniqueFile(File file, long id) {
            this.file = file;
            this.id = id;
        }

        public File getFile() {
            return this.file;
        }

        public long getId() {
            return this.id;
        }
    }
}

