/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.cron;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.jira.web.component.cron.CronEditorBean;
import com.atlassian.jira.web.component.cron.generator.CronExpressionGenerator;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.atlassian.velocity.VelocityManager;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class CronEditorWebComponent
extends AbstractWebComponent {
    private final JiraAuthenticationContext authenticationContext = ComponentManager.getComponentInstanceOfType(JiraAuthenticationContext.class);
    private final CronExpressionGenerator cronExpressionGenerator = new CronExpressionGenerator();

    public CronEditorWebComponent() {
        this(ManagerFactory.getVelocityManager(), ManagerFactory.getApplicationProperties());
    }

    public CronEditorWebComponent(VelocityManager velocityManager, ApplicationProperties applicationProperties) {
        super(velocityManager, applicationProperties);
    }

    public String getHtml(CronEditorBean cronEditorBean, String paramPrefix) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        return this.getHtml(cronEditorBean, i18n, paramPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtml(CronEditorBean cronEditorBean, I18nHelper i18n, String paramPrefix) {
        try {
            UtilTimerStack.push((String)"CronEditorHtml");
            if (paramPrefix != null && !paramPrefix.endsWith(".")) {
                paramPrefix = paramPrefix + ".";
            }
            WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
            webResourceManager.requireResource("jira.webresources:croneditor");
            DateTimeFormatterFactory dateTimeFormatterFactory = (DateTimeFormatterFactory)ComponentAccessor.getComponentOfType(DateTimeFormatterFactory.class);
            String currentTime = dateTimeFormatterFactory.formatter().withSystemZone().withStyle(DateTimeStyle.COMPLETE).format(new Date());
            Map startingParams = EasyMap.build((Object)"cronEditorBean", (Object)cronEditorBean, (Object)"i18n", (Object)i18n, (Object)"paramPrefix", (Object)paramPrefix, (Object)"helpUtil", (Object)HelpUtil.getInstance(), (Object)"currentTime", (Object)currentTime, (Object)"timezone", (Object)new TimeZoneHelper().getDisplayName(this.authenticationContext.getLocale()));
            Map<String, Object> params = JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
            String string = this.getHtml("templates/jira/cron/croneditor.vm", params);
            return string;
        }
        finally {
            UtilTimerStack.pop((String)"CronEditorHtml");
        }
    }

    public ErrorCollection validateInput(CronEditorBean cronEditorBean, String fieldName) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (cronEditorBean.isDayPerWeekMode() && StringUtils.isBlank((String)cronEditorBean.getSpecifiedDaysPerWeek())) {
            errors.addError(fieldName, i18n.getText("cron.editor.error.daysOfWeek.must.have.selection"));
        }
        if (cronEditorBean.isRange() && !cronEditorBean.isRangeHoursValid()) {
            errors.addError(fieldName, i18n.getText("cron.editor.error.from.hour.after.to.hour"));
        }
        return errors;
    }

    public String getCronExpressionFromInput(CronEditorBean cronEditorBean) {
        return this.cronExpressionGenerator.getCronExpressionFromInput(cronEditorBean);
    }

    static class TimeZoneHelper {
        private final TimeZone timeZone;

        TimeZoneHelper() {
            this(TimeZone.getDefault());
        }

        TimeZoneHelper(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        String getDisplayName(Locale locale) {
            return this.timeZone.getDisplayName(this.useDaylight(new Date()), 1, locale);
        }

        boolean useDaylight(Date date) {
            return this.timeZone.inDaylightTime(date);
        }
    }
}

