/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;

public class ClearRememberMeCookies
extends JiraWebActionSupport {
    private final RememberMeTokenDao rememberMeTokenDao;

    public ClearRememberMeCookies(RememberMeTokenDao rememberMeTokenDao) {
        this.rememberMeTokenDao = rememberMeTokenDao;
    }

    public String doDefault() throws Exception {
        User current = this.getLoggedInUser();
        if (current == null) {
            return "error";
        }
        return super.doDefault();
    }

    protected void doValidation() {
        try {
            this.getLoggedInUser();
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("rememberme.could.not.find.user"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        User current = this.getLoggedInUser();
        if (current == null) {
            return "error";
        }
        if (this.invalidInput()) {
            return "error";
        }
        this.rememberMeTokenDao.removeAllForUser(current.getName());
        return this.returnComplete();
    }

    public String doSuccess() {
        return "success";
    }
}

