/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.event.issue.link.RemoteIssueLinkUICreateEvent;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import java.util.HashMap;
import java.util.Map;
import webwork.action.Action;

public abstract class AbstractIssueLinkAction
extends AbstractCommentableIssue
implements OperationContext {
    protected RemoteIssueLinkService.CreateValidationResult validationResult;
    protected final RemoteIssueLinkService remoteIssueLinkService;
    protected final EventPublisher eventPublisher;
    private boolean requiresCredentials;

    public AbstractIssueLinkAction(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, UserUtil userUtil, RemoteIssueLinkService remoteIssueLinkService, EventPublisher eventPublisher) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.remoteIssueLinkService = remoteIssueLinkService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    protected void doValidation() {
        if (!this.isHasIssuePermission(21, this.getIssue())) {
            this.addErrorMessage(this.getText("linkissue.error.nopermission"));
        }
        super.doValidation();
    }

    public String doDefault() throws Exception {
        try {
            this.getIssueObject();
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return super.doDefault();
    }

    public RemoteIssueLinkService.RemoteIssueLinkResult createLink() {
        RemoteIssueLinkService.RemoteIssueLinkResult result = this.remoteIssueLinkService.create(this.getLoggedInUser(), this.validationResult);
        RemoteIssueLink link = result.getRemoteIssueLink();
        this.eventPublisher.publish((Object)new RemoteIssueLinkUICreateEvent(link.getId(), link.getApplicationType()));
        return result;
    }

    public boolean isValidToView() {
        try {
            if (this.isIssueExists() && this.isHasIssuePermission(21, this.getIssue())) {
                return true;
            }
        }
        catch (IssueNotFoundException e) {
            return false;
        }
        catch (IssuePermissionException e) {
            return false;
        }
        return false;
    }

    protected String getRedirectUrl() {
        return "/browse/" + this.getIssue().getString("key") + "#linkingmodule";
    }

    protected void handleCredentialsRequired() {
        this.addError("non-existent", "");
        this.requiresCredentials = true;
    }

    public boolean isRequiresCredentials() {
        return this.requiresCredentials;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }

    public String getCommentSectionHtml() {
        FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem = this.getFieldScreenRendererLayoutItemForField((OrderableField)this.getField("comment"));
        FieldLayoutItem fieldLayoutItem = fieldScreenRenderLayoutItem.getFieldLayoutItem();
        return fieldLayoutItem.getOrderableField().getEditHtml(fieldLayoutItem, (OperationContext)this, (Action)this, (Issue)this.getIssueObject(), this.getDisplayParams());
    }

    public static String getModifierKey() {
        return BrowserUtils.getModifierKey();
    }

    public static KeyboardShortcutManager.Context getKeyboardShortcutContext() {
        return KeyboardShortcutManager.Context.issuenavigation;
    }
}

