/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.web.action.admin.workflow.scheme.SchemeAwareWorkflowAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class AddWorkflowSchemeEntity
extends SchemeAwareWorkflowAction {
    private String type;
    private String workflow;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final SubTaskManager subTaskManager;
    private final WorkflowManager workflowManager;

    public AddWorkflowSchemeEntity(WorkflowSchemeManager workflowSchemeManager, SubTaskManager subTaskManager, WorkflowManager workflowManager) {
        this.workflowSchemeManager = workflowSchemeManager;
        this.subTaskManager = subTaskManager;
        this.workflowManager = workflowManager;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return this.workflowSchemeManager;
    }

    @Override
    public String getRedirectURL() {
        return "EditWorkflowSchemeEntities!default.jspa?schemeId=";
    }

    protected void doValidation() {
        try {
            if (this.getSchemeId() == null || this.getScheme() == null) {
                this.addErrorMessage(this.getText("admin.errors.workflows.must.select.scheme"));
            }
            if (StringUtils.isBlank((String)this.workflow)) {
                this.addError("workflowname", this.getText("admin.errors.workflows.must.select.workflow.to.assign"));
            }
            if (StringUtils.isBlank((String)this.getType())) {
                this.addErrorMessage(this.getText("admin.errors.workflows.must.select.type"));
            }
        }
        catch (GenericEntityException e) {
            this.addErrorMessage(this.getText("admin.errors.workflows.error.occured", e.getMessage()));
        }
    }

    protected String doExecute() throws Exception {
        this.workflowSchemeManager.addWorkflowToScheme(this.getScheme(), this.getWorkflow(), this.getType());
        return this.returnCompleteWithInlineRedirect(this.getRedirectURL() + this.getSchemeId());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getIssueTypes() throws GenericEntityException {
        LinkedHashMap types = Maps.newLinkedHashMap();
        if (this.getSchemeManager().getEntities(this.getScheme(), "0").size() == 0) {
            types.put("0", this.getText("admin.schemes.workflows.all.unassigned"));
        }
        for (IssueType issueType : this.getConstantsManager().getRegularIssueTypeObjects()) {
            if (this.getSchemeManager().getEntities(this.getScheme(), issueType.getId()).size() != 0) continue;
            types.put(issueType.getId(), issueType.getNameTranslation());
        }
        if (this.subTaskManager.isSubTasksEnabled()) {
            for (IssueType subTaskType : this.getConstantsManager().getSubTaskIssueTypeObjects()) {
                if (this.getSchemeManager().getEntities(this.getScheme(), subTaskType.getId()).size() != 0) continue;
                types.put(subTaskType.getId(), subTaskType.getNameTranslation());
            }
        }
        return types;
    }

    public Collection<JiraWorkflow> getWorkflows() {
        return this.workflowManager.getWorkflows();
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }
}

