/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class PublishDraftWorkflow
extends JiraWebActionSupport {
    private final WorkflowService workflowService;
    private final JiraWorkflow jiraWorkflow;
    private boolean enableBackup = false;
    private boolean enableBackupSubmitted = false;
    private boolean madeDeliberateChoice = false;
    private String newWorkflowName;

    public PublishDraftWorkflow(WorkflowService workflowService, JiraWorkflow jiraWorkflow) {
        this.workflowService = workflowService;
        this.jiraWorkflow = jiraWorkflow;
    }

    public String doDefault() throws Exception {
        this.generateWorkflowName();
        return "input";
    }

    private void generateWorkflowName() {
        this.newWorkflowName = WorkflowUtil.cloneWorkflowName((String)this.getWorkflow().getName());
    }

    protected void doValidation() {
        if (!this.enableBackupSubmitted) {
            this.addError("enableBackup", this.getText("admin.workflows.publish.error.save.backup"));
            if (StringUtils.isBlank((String)this.newWorkflowName)) {
                this.generateWorkflowName();
            }
        } else {
            this.setMadeDeliberateChoice(true);
        }
        if (this.enableBackup) {
            this.workflowService.validateCopyWorkflow(this.getJiraServiceContext(), this.newWorkflowName);
        }
        this.workflowService.validateOverwriteWorkflow(this.getJiraServiceContext(), this.jiraWorkflow.getName());
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.enableBackup) {
            JiraWorkflow activeWorkflow = this.workflowService.getWorkflow(this.getJiraServiceContext(), this.jiraWorkflow.getName());
            this.workflowService.copyWorkflow(this.getJiraServiceContext(), this.newWorkflowName, null, activeWorkflow);
        }
        this.workflowService.overwriteActiveWorkflow(this.getJiraServiceContext(), this.jiraWorkflow.getName());
        if (this.hasAnyErrors()) {
            return "error";
        }
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect("/secure/admin/WorkflowDesigner.jspa?wfName=" + JiraUrlCodec.encode((String)this.jiraWorkflow.getName(), (String)this.getApplicationProperties().getEncoding()) + "&workflowMode=live");
        }
        return this.getRedirect("ListWorkflows.jspa");
    }

    public JiraWorkflow getWorkflow() {
        return this.jiraWorkflow;
    }

    public boolean isEnableBackup() {
        return this.enableBackup;
    }

    public void setEnableBackup(boolean enableBackup) {
        this.enableBackupSubmitted = true;
        this.enableBackup = enableBackup;
    }

    public String getNewWorkflowName() {
        return this.newWorkflowName;
    }

    public void setNewWorkflowName(String newWorkflowName) {
        this.newWorkflowName = newWorkflowName;
    }

    public Collection getBooleanList() {
        return EasyList.build((Object)new TextOption("true", this.getText("common.words.yes")), (Object)new TextOption("false", this.getText("common.words.no")));
    }

    public String getWorkflowDisplayName() {
        return WorkflowUtil.getWorkflowDisplayName((JiraWorkflow)this.getWorkflow());
    }

    public boolean isMadeDeliberateChoice() {
        return this.madeDeliberateChoice;
    }

    public void setMadeDeliberateChoice(boolean madeDeliberateChoice) {
        this.madeDeliberateChoice = madeDeliberateChoice;
    }
}

