/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.ConfigurableJiraWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ListWorkflows
extends JiraWebActionSupport {
    private JiraWorkflow workflow;
    private final WorkflowManager workflowManager;
    private final ProjectManager projectManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private List workflows;
    private String description;
    private String newWorkflowName;
    private String workflowName;
    private String workflowMode;
    private boolean confirmedDelete;

    public ListWorkflows(WorkflowManager workflowManager, ProjectManager projectManager, WorkflowSchemeManager workflowSchemeManager) {
        this.workflowManager = workflowManager;
        this.projectManager = projectManager;
        this.workflowSchemeManager = workflowSchemeManager;
    }

    protected String doExecute() throws Exception {
        this.workflows = this.getWorkflowsIncludingDrafts();
        return "success";
    }

    public String doAddNewWorkflow() throws Exception {
        return "input";
    }

    @RequiresXsrfCheck
    public String doAddWorkflow() throws Exception {
        if (StringUtils.isBlank((String)this.newWorkflowName)) {
            this.addError("newWorkflowName", this.getText("admin.errors.you.must.specify.a.workflow.name"));
        } else if (!WorkflowUtil.isAcceptableName((String)this.newWorkflowName)) {
            this.addError("newWorkflowName", this.getText("admin.errors.please.use.only.ascii.characters"));
        } else if (this.workflowManager.workflowExists(this.newWorkflowName)) {
            this.addError("newWorkflowName", this.getText("admin.errors.a.workflow.with.this.name.already.exists"));
        }
        if (this.invalidInput()) {
            return "input";
        }
        ConfigurableJiraWorkflow newWorkflow = new ConfigurableJiraWorkflow(this.newWorkflowName, this.workflowManager);
        newWorkflow.setDescription(this.description);
        this.workflowManager.createWorkflow(this.getLoggedInUser(), (JiraWorkflow)newWorkflow);
        return this.returnCompleteWithInlineRedirect("WorkflowDesigner.jspa?wfName=" + URLCodec.encode((String)newWorkflow.getName()) + "&workflowMode=" + URLCodec.encode((String)newWorkflow.getMode()));
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    @RequiresXsrfCheck
    public String doDeleteWorkflow() throws Exception {
        if (this.confirmedDelete) {
            if ("draft".equals(this.workflowMode)) {
                this.workflowManager.deleteDraftWorkflow(this.workflowName);
                return this.returnComplete("ListWorkflows.jspa");
            }
            JiraWorkflow workflow = this.workflowManager.getWorkflow(this.workflowName);
            if (workflow != null) {
                if (workflow.isEditable()) {
                    Collection workflowSchemes = this.workflowSchemeManager.getSchemesForWorkflow(workflow);
                    if (workflowSchemes == null || workflowSchemes.isEmpty()) {
                        this.workflowManager.deleteWorkflow(this.workflowManager.getWorkflow(this.workflowName));
                        return this.returnComplete("ListWorkflows.jspa");
                    }
                    StringBuffer schemes = new StringBuffer();
                    for (GenericValue schemeGV : workflowSchemes) {
                        schemes.append('\'').append(schemeGV.getString("name")).append('\'').append(", ");
                    }
                    schemes.delete(schemes.length() - 2, schemes.length() - 1);
                    this.addErrorMessage(this.getText("admin.errors.cannot.delete.this.workflow") + " " + schemes);
                    return this.getResult();
                }
                this.addErrorMessage(this.getText("admin.errors.workflow.cannot.be.deleted.as.it.is.not.editable"));
                return this.getResult();
            }
            this.addErrorMessage(this.getText("admin.errors.workflow.with.name.does.not.exist", "'" + this.workflowName + "'"));
            return this.getResult();
        }
        return "input";
    }

    public List getWorkflows() {
        return this.workflows;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JiraWorkflow getWorkflow() {
        if (this.workflow == null && StringUtils.isNotBlank((String)this.newWorkflowName)) {
            this.workflow = this.workflowManager.getWorkflow(this.newWorkflowName);
        }
        return this.workflow;
    }

    public String getNewWorkflowName() {
        return this.newWorkflowName;
    }

    public void setNewWorkflowName(String newWorkflowName) {
        this.newWorkflowName = newWorkflowName;
    }

    public boolean isNoProjects() throws GenericEntityException {
        return this.projectManager.getProjectObjects().size() == 0;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setConfirmedDelete(boolean confirmedDelete) {
        this.confirmedDelete = confirmedDelete;
    }

    public Collection getSchemesForWorkflow(JiraWorkflow workflow) {
        return this.workflowSchemeManager.getSchemesForWorkflow(workflow);
    }

    private List getWorkflowsIncludingDrafts() {
        List allWorkflows = this.workflowManager.getWorkflowsIncludingDrafts();
        for (JiraWorkflow jiraWorkflow : allWorkflows) {
            if (!jiraWorkflow.isDraftWorkflow() || this.isParentWorkflowActive(jiraWorkflow)) continue;
            this.addErrorMessage("The parent workflow of draft '" + jiraWorkflow.getName() + "' is no longer active. Please delete the draft. You may wish to copy the draft before deleting it.");
        }
        return allWorkflows;
    }

    public void setWorkflowMode(String workflowMode) {
        this.workflowMode = workflowMode;
    }

    public boolean isParentWorkflowActive(JiraWorkflow workflow) {
        if (!workflow.isDraftWorkflow()) {
            return true;
        }
        JiraWorkflow parentWorkflow = this.workflowManager.getWorkflow(workflow.getName());
        return parentWorkflow != null && parentWorkflow.isActive();
    }
}

