/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.trustedapps;

import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationBuilder;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;

public abstract class AbstractTrustedApplicationAction
extends JiraWebActionSupport {
    protected final TrustedApplicationBuilder builder = new TrustedApplicationBuilder();
    protected final TrustedApplicationService service;

    public AbstractTrustedApplicationAction(TrustedApplicationService service) {
        this.service = service;
    }

    public String doDefault() {
        if (this.getId() <= 0L) {
            this.addErrorMessage(this.getText("admin.trustedapps.edit.id.missing"));
            return "error";
        }
        this.loadTrustedApplicationInfo();
        return "input";
    }

    @RequiresXsrfCheck
    protected final String doExecute() throws Exception {
        this.doExecuteAction();
        return this.getJiraServiceContext().getErrorCollection().hasAnyErrors() ? "error" : this.getRedirect("ViewTrustedApplications.jspa");
    }

    protected abstract void doExecuteAction();

    public void setId(long id) {
        this.builder.setId(id);
    }

    public long getId() {
        return this.builder.getId();
    }

    public String getName() {
        return this.builder.getName();
    }

    private void loadTrustedApplicationInfo() {
        TrustedApplicationInfo applicationInfo = this.service.get(this.getJiraServiceContext(), this.getId());
        if (applicationInfo == null) {
            this.addErrorMessage(this.getText("admin.trustedapps.edit.id.not.found", String.valueOf(this.getId())));
            this.setId(0L);
        } else {
            this.builder.set(applicationInfo);
        }
    }

    public boolean isEditable() {
        return this.getErrorMessages().isEmpty();
    }
}

