/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeAction;
import java.util.Collection;

public class AbstractFieldScreenSchemeItemAction
extends AbstractFieldScreenSchemeAction {
    private final FieldScreenManager fieldScreenManager;
    private Long issueOperationId;
    private Long fieldScreenId;
    private Collection fieldScreens;

    public AbstractFieldScreenSchemeItemAction(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenManager fieldScreenManager) {
        super(fieldScreenSchemeManager);
        this.fieldScreenManager = fieldScreenManager;
    }

    @Override
    protected String redirectToView() {
        return this.getRedirect("ConfigureFieldScreenScheme.jspa?id=" + this.getId());
    }

    protected void validateIssueOperationId() {
        if (this.issueOperationId != null && IssueOperations.getIssueOperation((Long)this.issueOperationId) == null) {
            this.addError("issueOperationId", this.getText("admin.errors.screens.invalid.issue.operation.id"));
        }
    }

    protected void validateFieldScreenId() {
        if (this.getFieldScreenId() == null) {
            this.addError("fieldScreenId", this.getText("admin.errors.screens.please.select.screen"));
        } else if (this.getFieldScreenManager().getFieldScreen(this.getFieldScreenId()) == null) {
            this.addError("fieldScreenId", this.getText("admin.errors.screens.invalid.id"));
        }
    }

    public Long getIssueOperationId() {
        return this.issueOperationId;
    }

    public void setIssueOperationId(Long issueOperationId) {
        this.issueOperationId = issueOperationId;
    }

    public Long getFieldScreenId() {
        return this.fieldScreenId;
    }

    public void setFieldScreenId(Long fieldScreenId) {
        this.fieldScreenId = fieldScreenId;
    }

    public Collection getFieldScreens() {
        if (this.fieldScreens == null) {
            this.fieldScreens = this.fieldScreenManager.getFieldScreens();
        }
        return this.fieldScreens;
    }

    protected FieldScreenManager getFieldScreenManager() {
        return this.fieldScreenManager;
    }

    public IssueOperation getIssueOperation() {
        if (this.getIssueOperationId() != null) {
            return IssueOperations.getIssueOperation((Long)this.getIssueOperationId());
        }
        return null;
    }
}

