/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.index;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.action.admin.index.AbstractAsyncIndexerCommand;
import com.atlassian.jira.web.action.admin.index.ActivateAsyncIndexerCommand;
import com.atlassian.jira.web.action.admin.index.IndexAdmin;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.jira.web.action.admin.index.IndexTaskContext;
import com.atlassian.jira.web.action.admin.index.ReIndexAsyncIndexerCommand;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.io.File;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import webwork.action.ServletActionContext;

@WebSudoRequired
public class IndexAdminImpl
extends ProjectActionSupport
implements IndexAdmin {
    public static final String JIRA_IS_BEING_REINDEXED = "JIRA is currently being reindexed. Depending on how large the database is, this may take a few minutes. Jira will automatically become available as soon as this task is complete.";
    private static final String PROGRESS = "progress";
    private final IndexLifecycleManager indexLifecycleManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final TaskManager taskManager;
    private final JiraAuthenticationContext authenticationContext;
    private final FileFactory fileFactory;
    private Long taskId;
    private TaskDescriptorBean<IndexCommandResult> currentTask;
    private long reindexTime = 0L;
    private String indexPath;
    private final OutlookDateManager outlookDateManager;
    private TaskDescriptor<IndexCommandResult> currentTaskDescriptor;
    private final IndexPathManager indexPathManager;
    private IndexPathManager.Mode indexMode;

    public IndexAdminImpl(IndexLifecycleManager indexLifecycleManager, GlobalPermissionManager globalPermissionManager, TaskManager taskManager, JiraAuthenticationContext authenticationContext, OutlookDateManager outlookDateManager, IndexPathManager indexPathManager, FileFactory fileFactory) {
        this(ManagerFactory.getProjectManager(), ManagerFactory.getPermissionManager(), indexLifecycleManager, globalPermissionManager, taskManager, authenticationContext, outlookDateManager, indexPathManager, fileFactory);
    }

    public IndexAdminImpl(ProjectManager projectManager, PermissionManager permissionManager, IndexLifecycleManager indexLifecycleManager, GlobalPermissionManager globalPermissionManager, TaskManager taskManager, JiraAuthenticationContext authenticationContext, OutlookDateManager outlookDateManager, IndexPathManager indexPathManager, FileFactory fileFactory) {
        super(projectManager, permissionManager);
        this.outlookDateManager = outlookDateManager;
        this.indexLifecycleManager = indexLifecycleManager;
        this.globalPermissionManager = globalPermissionManager;
        this.taskManager = taskManager;
        this.authenticationContext = authenticationContext;
        this.indexPathManager = indexPathManager;
        this.fileFactory = fileFactory;
        this.indexMode = indexPathManager.getMode();
        this.indexPath = indexPathManager.getIndexRootPath();
    }

    public String getIndexPathOption() {
        return this.indexMode.toString();
    }

    public void setIndexPathOption(String indexPathOption) {
        this.indexMode = IndexPathManager.Mode.valueOf((String)indexPathOption);
    }

    public String getDefaultIndexPath() {
        return this.indexPathManager.getDefaultIndexRootPath();
    }

    public boolean getShowCustom() {
        return this.indexMode == IndexPathManager.Mode.CUSTOM || this.indexMode == IndexPathManager.Mode.DISABLED && this.indexPath != null;
    }

    @Override
    public String getIndexPath() {
        return this.indexPath;
    }

    private void validateIndexPath(String path) {
        if (StringUtils.isBlank((String)path)) {
            this.addError("indexPath", this.getText("admin.errors.you.must.specify.a.path"));
        } else {
            File actualPath = this.fileFactory.getFile(path);
            if (!actualPath.isAbsolute()) {
                this.addError("indexPath", this.getText("setup.error.filepath.notabsolute"));
            } else {
                if (!actualPath.exists()) {
                    actualPath.mkdirs();
                }
                if (!actualPath.exists() || !actualPath.isDirectory()) {
                    this.addError("indexPath", this.getText("admin.errors.path.entered.does.not.exist"));
                } else if (!actualPath.canRead() || !actualPath.canWrite()) {
                    this.addError("indexPath", this.getText("admin.errors.path.entered.is.not.readable"));
                }
            }
        }
    }

    public String doExecute() throws Exception {
        TaskDescriptor<IndexCommandResult> taskDescriptor = this.getCurrentTaskDescriptor();
        if (taskDescriptor != null) {
            return this.getRedirect(taskDescriptor.getProgressURL());
        }
        return super.doExecute();
    }

    @Override
    @RequiresXsrfCheck
    public String doActivate() throws Exception {
        if (!this.isHasSystemAdminPermission()) {
            this.addErrorMessage(this.getText("admin.errors.no.perm.to.activate"));
            return "error";
        }
        if (this.indexMode == IndexPathManager.Mode.DISABLED) {
            this.addErrorMessage(this.getText("admin.errors.you.must.specify.a.path"));
            return "error";
        }
        JohnsonEventContainer eventCont = null;
        ServletContext ctx = ServletActionContext.getServletContext();
        if (ctx != null) {
            eventCont = JohnsonEventContainer.get((ServletContext)ctx);
        }
        if (!this.isIndexing()) {
            if (this.indexMode == IndexPathManager.Mode.CUSTOM) {
                this.validateIndexPath(this.indexPath);
            }
            if (!this.invalidInput()) {
                this.updateIndexPathManager();
                ActivateAsyncIndexerCommand activateCommand = new ActivateAsyncIndexerCommand(false, eventCont, this.indexLifecycleManager, this.log, this.authenticationContext.getI18nHelper());
                String taskName = this.getText("admin.indexing.jira.indexing");
                try {
                    TaskDescriptor<IndexCommandResult> taskDescriptor = this.taskManager.submitTask(activateCommand, taskName, new IndexTaskContext());
                    return this.getRedirect(taskDescriptor.getProgressURL());
                }
                catch (AlreadyExecutingException e) {
                    return this.getRedirect(e.getTaskDescriptor().getProgressURL());
                }
                catch (RejectedExecutionException e) {
                    this.addErrorMessage(this.getText("common.tasks.rejected.execution.exception", e.getMessage()));
                    return "error";
                }
            }
            return "error";
        }
        return this.getRedirect(this.getRedirectUrl());
    }

    private boolean isCustomPathChanged() {
        return this.indexMode == IndexPathManager.Mode.CUSTOM && !this.indexPath.equals(this.indexPathManager.getIndexRootPath());
    }

    private boolean isModeChanged() {
        return this.indexMode != this.indexPathManager.getMode();
    }

    @Override
    @RequiresXsrfCheck
    public String doReindex() throws Exception {
        JohnsonEventContainer eventCont = null;
        if (this.isIndexing()) {
            AbstractAsyncIndexerCommand indexCallable;
            ServletContext ctx = ServletActionContext.getServletContext();
            if (ctx != null) {
                eventCont = JohnsonEventContainer.get((ServletContext)ctx);
            }
            if (this.isHasSystemAdminPermission()) {
                if (this.isCustomPathChanged()) {
                    this.validateIndexPath(this.indexPath);
                    if (this.invalidInput()) {
                        return "error";
                    }
                }
                if (this.isCustomPathChanged() || this.isModeChanged()) {
                    this.updateIndexPathManager();
                    indexCallable = new ActivateAsyncIndexerCommand(true, eventCont, this.indexLifecycleManager, this.log, this.authenticationContext.getI18nHelper());
                } else {
                    indexCallable = new ReIndexAsyncIndexerCommand(eventCont, this.indexLifecycleManager, this.log, this.authenticationContext.getI18nHelper());
                }
            } else {
                indexCallable = new ReIndexAsyncIndexerCommand(eventCont, this.indexLifecycleManager, this.log, this.authenticationContext.getI18nHelper());
            }
            String taskName = this.getText("admin.indexing.jira.indexing");
            try {
                return this.getRedirect(this.taskManager.submitTask(indexCallable, taskName, new IndexTaskContext()).getProgressURL());
            }
            catch (AlreadyExecutingException e) {
                return this.getRedirect(e.getTaskDescriptor().getProgressURL());
            }
            catch (RejectedExecutionException e) {
                this.addErrorMessage(this.getText("common.tasks.rejected.execution.exception", e.getMessage()));
                return "error";
            }
        }
        return this.getRedirect(this.getRedirectUrl());
    }

    private void updateIndexPathManager() {
        if (this.indexMode == IndexPathManager.Mode.DEFAULT) {
            this.indexPathManager.setUseDefaultDirectory();
        } else if (this.indexMode == IndexPathManager.Mode.CUSTOM) {
            this.indexPathManager.setIndexRootPath(this.indexPath);
        }
    }

    public String doProgress() throws ExecutionException, InterruptedException {
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.id"));
            return "error";
        }
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        if (this.currentTaskDescriptor == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.found"));
            return "error";
        }
        TaskContext context = this.currentTaskDescriptor.getTaskContext();
        if (!(context instanceof IndexTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", IndexTaskContext.class.getName(), context.getClass().getName()));
            return "error";
        }
        this.currentTask = new TaskDescriptorBean<IndexCommandResult>(this.currentTaskDescriptor, this.authenticationContext.getI18nHelper(), this.outlookDateManager, this.authenticationContext.getLoggedInUser());
        if (this.currentTaskDescriptor.isFinished()) {
            try {
                IndexCommandResult result = this.currentTaskDescriptor.getResult();
                if (result.isSuccessful()) {
                    this.reindexTime = result.getReindexTime();
                } else {
                    this.addErrorCollection(result.getErrorCollection());
                }
            }
            catch (ExecutionException e) {
                this.currentTask.setExceptionCause(e.getCause() == null ? e : e.getCause());
            }
            catch (InterruptedException e) {
                this.currentTask.setExceptionCause(e);
            }
        }
        return PROGRESS;
    }

    private String getRedirectUrl() {
        return "IndexAdmin.jspa";
    }

    @Override
    public long getReindexTime() {
        return this.reindexTime;
    }

    public void setReindexTime(long reindexTime) {
        this.reindexTime = reindexTime;
    }

    public boolean isAnyLiveTasks() {
        return !this.taskManager.getLiveTasks().isEmpty();
    }

    public boolean isHasSystemAdminPermission() {
        return this.globalPermissionManager.hasPermission(44, this.getLoggedInUser());
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public TaskDescriptorBean<IndexCommandResult> getOurTask() {
        return this.currentTask;
    }

    public TaskDescriptorBean<IndexCommandResult> getCurrentTask() {
        TaskDescriptor<IndexCommandResult> taskDescriptor;
        if (this.currentTask == null && (taskDescriptor = this.getCurrentTaskDescriptor()) != null) {
            this.currentTask = new TaskDescriptorBean<IndexCommandResult>(taskDescriptor, this.authenticationContext.getI18nHelper(), this.outlookDateManager, this.authenticationContext.getLoggedInUser());
        }
        return this.currentTask;
    }

    private TaskDescriptor<IndexCommandResult> getCurrentTaskDescriptor() {
        if (this.currentTaskDescriptor == null) {
            this.currentTaskDescriptor = this.taskManager.getLiveTask(new IndexTaskContext());
        }
        return this.currentTaskDescriptor;
    }

    public String getDestinationURL() {
        return "/secure/admin/jira/IndexAdmin.jspa?reindexTime=" + this.reindexTime;
    }
}

