/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Locale;

@WebSudoRequired
public class ViewApplicationProperties
extends ProjectActionSupport {
    protected final UserPickerSearchService searchService;
    private final LocaleManager localeManager;
    protected final TimeZoneService timeZoneService;
    protected final RendererManager rendererManager;

    public ViewApplicationProperties(UserPickerSearchService searchService, LocaleManager localeManager, TimeZoneService timeZoneService, RendererManager rendererManager) {
        this.searchService = searchService;
        this.localeManager = localeManager;
        this.timeZoneService = timeZoneService;
        this.rendererManager = rendererManager;
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public String getJiraMode() {
        StringBuilder i18nString = new StringBuilder("admin.jira.mode.").append(this.getApplicationProperties().getString("jira.mode"));
        return this.getText(i18nString.toString());
    }

    public String getDisplayNameOfLocale(Locale locale) {
        return locale.getDisplayName(this.getLocale());
    }

    public boolean useSystemTimeZone() {
        return this.timeZoneService.useSystemTimeZone();
    }

    public TimeZoneInfo getDefaultTimeZoneInfo() {
        return this.timeZoneService.getDefaultTimeZoneInfo(this.getJiraServiceContext());
    }

    public String getContactAdministratorsMessage() {
        String message = this.getApplicationProperties().getDefaultBackedString("jira.contact.administrators.message");
        return this.rendererManager.getRendererForType("atlassian-wiki-renderer").render(message, null);
    }

    public boolean getShowPluginHints() {
        return this.getApplicationProperties().getOption("show.plugin.marketing.hints");
    }

    public String getTacUrl() {
        return HelpUtil.getInstance().getHelpPath("application.properties.server.language.from.tac").getUrl();
    }
}

