/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.apache.commons.lang.StringUtils;

public class MyJiraHome
extends JiraWebActionSupport {
    public static String FEATURE_KEY = "atlassian.darkfeature.jira.myjirahome";
    private final UserPreferencesManager userPreferencesManager;
    private final FeatureManager featureManager;
    String target;

    public MyJiraHome(UserPreferencesManager userPreferencesManager, FeatureManager featureManager) {
        this.userPreferencesManager = userPreferencesManager;
        this.featureManager = featureManager;
    }

    protected String doExecute() throws Exception {
        String myHome;
        if (this.featureManager.isEnabled(FEATURE_KEY)) {
            myHome = this.whereIWantToGo();
            if (StringUtils.isEmpty((String)myHome) || myHome.equalsIgnoreCase("default") || myHome.endsWith("Dashboard.jspa")) {
                myHome = "/secure/Dashboard.jspa";
            }
        } else {
            myHome = "/secure/Dashboard.jspa";
        }
        return this.getRedirect(myHome);
    }

    private String whereIWantToGo() {
        return this.userPreferencesManager.getPreferences(this.getLoggedInUser()).getString("my.jira.home");
    }

    public String doSet() throws Exception {
        if (this.getLoggedInUser() != null) {
            this.userPreferencesManager.getPreferences(this.getLoggedInUser()).setString("my.jira.home", this.target);
        }
        return this.doExecute();
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }
}

