/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.resourcebundle;

import com.atlassian.gzipfilter.org.apache.commons.lang.builder.ToStringBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class DebuggingResourceBundle
extends ResourceBundle {
    public static final Logger log = Logger.getLogger(DebuggingResourceBundle.class);
    private static final int MAX_BUNDLES_SEARCHED = 3;
    private static final Locale LOCALE_EN_AU = new Locale("en", "AU");
    private AtomicLong lastModified = new AtomicLong(0L);
    private AtomicReference<PropertyResourceBundle> propertyResourceBundle = new AtomicReference();
    private final File propertiesFile;
    private final Locale locale;

    public static DebuggingResourceBundle getDebuggingResourceBundle(String baseName, Locale locale) {
        return DebuggingResourceBundle.getBundleImpl(baseName, locale, DebuggingResourceBundle.class.getClassLoader());
    }

    private static DebuggingResourceBundle getBundleImpl(String baseName, Locale locale, ClassLoader classLoader) {
        Assertions.notNull((String)"baseName", (Object)baseName);
        Assertions.notNull((String)"locale", (Object)locale);
        Assertions.notNull((String)"classLoader", (Object)classLoader);
        DebuggingResourceBundle resourceBundle = null;
        try {
            List<BundleInfo> bundleInfos = DebuggingResourceBundle.calculateBundleNames(baseName, locale);
            int index = 0;
            for (BundleInfo bundleInfo : bundleInfos) {
                resourceBundle = DebuggingResourceBundle.loadBundle(classLoader, bundleInfo);
                if (resourceBundle != null) {
                    DebuggingResourceBundle.fixUpParents(resourceBundle, bundleInfos, index + 1, classLoader);
                    break;
                }
                ++index;
            }
        }
        catch (MissingResourceException mre) {
            resourceBundle = null;
            log.error((Object)("Unable to load debugging resource bundle : " + mre.getMessage()), (Throwable)mre);
        }
        return resourceBundle;
    }

    private static void fixUpParents(DebuggingResourceBundle resourceBundle, List<BundleInfo> bundleInfos, int index, ClassLoader classLoader) {
        DebuggingResourceBundle currentBundle = resourceBundle;
        for (int i = index; i < bundleInfos.size(); ++i) {
            BundleInfo info = bundleInfos.get(i);
            DebuggingResourceBundle loadedBundledPlugin = DebuggingResourceBundle.loadBundle(classLoader, info);
            if (loadedBundledPlugin == null) continue;
            currentBundle.setParent(loadedBundledPlugin);
            currentBundle = loadedBundledPlugin;
        }
    }

    private static DebuggingResourceBundle loadBundle(ClassLoader classLoader, BundleInfo bundledInfo) {
        String propertiesFileName = bundledInfo.bundleName.replace('.', '/') + ".properties";
        URL resource = classLoader.getResource(propertiesFileName);
        if (resource != null) {
            File propertiesFile;
            URI resourceURI;
            try {
                resourceURI = resource.toURI();
            }
            catch (URISyntaxException e) {
                return null;
            }
            try {
                propertiesFile = new File(resourceURI);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
            return new DebuggingResourceBundle(propertiesFile, bundledInfo.locale);
        }
        return null;
    }

    private static List<BundleInfo> calculateBundleNames(String baseName, Locale locale) {
        ArrayList<BundleInfo> bundleInfos = new ArrayList<BundleInfo>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        BundleInfo bundleInfoLang = null;
        BundleInfo bundleInfoLang_Country = null;
        BundleInfo bundleInfoLang_Country_Variant = null;
        if (languageLength + countryLength + variantLength != 0) {
            StringBuffer temp = new StringBuffer(baseName);
            temp.append('_');
            temp.append(language);
            if (languageLength > 0) {
                bundleInfoLang = new BundleInfo(temp.toString(), new Locale(language));
            }
            if (countryLength + variantLength != 0) {
                temp.append('_');
                temp.append(country);
                if (countryLength > 0) {
                    bundleInfoLang_Country = new BundleInfo(temp.toString(), new Locale(language, country));
                }
                if (variantLength != 0) {
                    temp.append('_');
                    temp.append(variant);
                    bundleInfoLang_Country_Variant = new BundleInfo(temp.toString(), new Locale(language, country, variant));
                }
            }
        }
        if (bundleInfoLang_Country_Variant != null) {
            bundleInfos.add(bundleInfoLang_Country_Variant);
        }
        if (bundleInfoLang_Country != null) {
            bundleInfos.add(bundleInfoLang_Country);
        }
        if (bundleInfoLang != null) {
            bundleInfos.add(bundleInfoLang);
        }
        if (Locale.ROOT.equals(locale) || LOCALE_EN_AU.equals(locale)) {
            bundleInfos.add(new BundleInfo(baseName, Locale.ROOT));
        }
        return bundleInfos;
    }

    public DebuggingResourceBundle(File propertiesFile, Locale locale) {
        Assertions.notNull((String)"propertiesFile", (Object)propertiesFile);
        Assertions.notNull((String)"locale", (Object)locale);
        this.propertiesFile = propertiesFile;
        this.locale = locale;
        this.propertyResourceBundle.set(this.refreshFromDisk());
    }

    private PropertyResourceBundle refreshFromDisk() {
        try {
            return new PropertyResourceBundle(new FileInputStream(this.propertiesFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void refreshIfNeeded() {
        File checkModified = new File(this.propertiesFile.getAbsolutePath());
        long lastModification = checkModified.lastModified();
        long previousValue = this.lastModified.getAndSet(lastModification);
        if (previousValue != lastModification) {
            this.propertyResourceBundle.set(this.refreshFromDisk());
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        this.refreshIfNeeded();
        return this.propertyResourceBundle.get().handleGetObject(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        this.refreshIfNeeded();
        return this.propertyResourceBundle.get().getKeys();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("locale", (Object)this.locale).append("file", (Object)this.propertiesFile).toString();
    }

    private static class BundleInfo {
        private final String bundleName;
        private final Locale locale;

        private BundleInfo(String bundleName, Locale locale) {
            this.bundleName = bundleName;
            this.locale = locale;
        }
    }
}

