/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.cache;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class GenericCompositeKeyCache<K, L, V> {
    private final ConcurrentMap<Pair<K, L>, V> cache = new ConcurrentHashMap<Pair<K, L>, V>();
    private final Function<Pair<K, L>, V> valueRetriever;

    public static <M, N, W> GenericCompositeKeyCache<M, N, W> newCache(Function<Pair<M, N>, W> valueRetriever) {
        return new GenericCompositeKeyCache<M, N, W>(valueRetriever);
    }

    public GenericCompositeKeyCache(Function<Pair<K, L>, V> valueRetriever) {
        Assertions.notNull((String)"valueRetriever", valueRetriever);
        this.valueRetriever = valueRetriever;
    }

    public V get(K first, L second) {
        Pair<K, L> theKey = this.buildKey(first, second);
        V answer = this.getFromCache(theKey);
        if (answer == null) {
            return this.intoCache(theKey, this.getFromSource(theKey));
        }
        return answer;
    }

    private Pair<K, L> buildKey(K first, L second) {
        return Pair.of(first, second);
    }

    private V getFromCache(Pair theKey) {
        return this.cache.get(theKey);
    }

    private V getFromSource(Pair<K, L> key) {
        return (V)this.valueRetriever.get(key);
    }

    private V intoCache(Pair<K, L> key, V value) {
        V actual = this.cache.putIfAbsent(key, value);
        return actual != null ? actual : value;
    }
}

