/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.core.action.ActionUtils;
import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.action.ActionNames;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.user.UserEventDispatcher;
import com.atlassian.jira.exception.AddException;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.plugin.studio.StudioHooks;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.PasswordResetTokenBuilder;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.query.Query;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.Nullable;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.dispatcher.ActionResult;

public class UserUtilImpl
implements UserUtil,
Startable {
    private static final Logger log = Logger.getLogger(UserUtilImpl.class);
    private final ComponentLocator componentLocator;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final CrowdService crowdService;
    private final DirectoryManager directoryManager;
    private final PermissionManager permissionManager;
    private final ApplicationProperties applicationProperties;
    private final SearchProvider searchProvider;
    private final ProjectManager projectManager;
    private final ProjectRoleService projectRoleService;
    private final ProjectComponentManager componentManager;
    private final SubscriptionManager subscriptionManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final UserHistoryManager userHistoryManager;
    private final UserManager userManager;
    private final ResettableLazyReference<Integer> activeUsersCount = new ResettableLazyReference<Integer>(){

        protected Integer create() throws Exception {
            Set<String> groupsWithUsePermission = UserUtilImpl.this.getGroupsWithUsePermission();
            HashSet<User> allUsers = new HashSet<User>();
            for (String groupName : groupsWithUsePermission) {
                Iterable users = UserUtilImpl.this.getGroupMembers(groupName);
                for (User user : users) {
                    allUsers.add(user);
                }
            }
            return allUsers.size();
        }
    };
    private final EventPublisher eventPublisher;
    private final StudioHooks hooks;

    public UserUtilImpl(ComponentLocator componentLocator, IssueSecurityLevelManager issueSecurityLevelManager, GlobalPermissionManager globalPermissionManager, CrowdService crowdService, DirectoryManager directoryManager, PermissionManager permissionManager, ApplicationProperties applicationProperties, SearchProvider searchProvider, ProjectManager projectManager, ProjectRoleService projectRoleService, ProjectComponentManager componentManager, SubscriptionManager subscriptionManager, NotificationSchemeManager notificationSchemeManager, UserHistoryManager userHistoryManager, UserManager userManager, EventPublisher eventPublisher, StudioHooks hooks) {
        this.directoryManager = directoryManager;
        this.eventPublisher = eventPublisher;
        this.componentLocator = (ComponentLocator)Assertions.notNull((String)"componentLocator", (Object)componentLocator);
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
        this.applicationProperties = applicationProperties;
        this.searchProvider = searchProvider;
        this.projectManager = projectManager;
        this.projectRoleService = projectRoleService;
        this.componentManager = componentManager;
        this.subscriptionManager = subscriptionManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.userHistoryManager = userHistoryManager;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.hooks = hooks;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.flushUserCaches();
    }

    @EventListener
    public void onDirectoryModified(DirectoryEvent event) {
        this.activeUsersCount.reset();
    }

    @EventListener
    public void onDirectorySynchronisation(RemoteDirectorySynchronisedEvent event) {
        this.activeUsersCount.reset();
    }

    public void flushUserCaches() {
        this.activeUsersCount.reset();
        this.eventPublisher.publish((Object)new XMLRestoreFinishedEvent((Object)this));
    }

    protected SearchRequestService getSearchRequestService() {
        return (SearchRequestService)this.componentLocator.getComponentInstanceOfType(SearchRequestService.class);
    }

    protected PortalPageService getPortalPageService() {
        return (PortalPageService)this.componentLocator.getComponentInstanceOfType(PortalPageService.class);
    }

    protected JiraServiceContext getServiceContext(User user) {
        return new JiraServiceContextImpl(user);
    }

    public User createUserNoNotification(String username, String password, String emailAddress, String displayName) throws PermissionException, CreateException {
        User user;
        ImmutableUser.Builder builder = ImmutableUser.newUser().directoryId(-1L).name(username).displayName(displayName).emailAddress(emailAddress).active(true);
        try {
            if (StringUtils.isEmpty((String)password)) {
                password = UserUtilImpl.generatePassword();
            }
            user = this.crowdService.addUser(builder.toUser(), password);
        }
        catch (OperationNotPermittedException e) {
            throw new PermissionException((Exception)((Object)e));
        }
        catch (InvalidCredentialException e) {
            throw new CreateException((Exception)((Object)e));
        }
        catch (InvalidUserException e) {
            throw new CreateException((Exception)((Object)e));
        }
        this.addToJiraUsePermission(user);
        return user;
    }

    public User createUserNoNotification(String username, String password, String emailAddress, String displayName, Long directoryId) throws PermissionException, CreateException {
        if (directoryId == null) {
            return this.createUserNoNotification(username, password, emailAddress, displayName);
        }
        UserTemplate userTemplate = new UserTemplate(username, directoryId.longValue());
        userTemplate.setEmailAddress(emailAddress);
        userTemplate.setDisplayName(displayName);
        userTemplate.setActive(true);
        if (StringUtils.isEmpty((String)password)) {
            password = UserUtilImpl.generatePassword();
        }
        try {
            com.atlassian.crowd.model.user.User user = this.directoryManager.addUser(directoryId.longValue(), userTemplate, new PasswordCredential(password));
            this.addToJiraUsePermission((User)user);
            return user;
        }
        catch (InvalidCredentialException e) {
            throw new CreateException((Exception)((Object)e));
        }
        catch (InvalidUserException e) {
            throw new CreateException((Exception)((Object)e));
        }
        catch (DirectoryPermissionException e) {
            throw new PermissionException((Exception)((Object)e));
        }
        catch (DirectoryNotFoundException e) {
            throw new CreateException((Exception)((Object)e));
        }
        catch (UserAlreadyExistsException e) {
            throw new CreateException((Exception)((Object)e));
        }
        catch (OperationFailedException e) {
            throw new com.atlassian.crowd.exception.runtime.OperationFailedException((Throwable)e);
        }
    }

    public static String generatePassword() {
        Random random = new Random();
        return new BigInteger(130, random).toString(32) + "ABab23";
    }

    public User createUserWithNotification(String username, String password, String email, String fullname, int userEventType) throws PermissionException, CreateException {
        return this.createUserWithNotification(username, password, email, fullname, null, userEventType);
    }

    public User createUserWithNotification(String username, String password, String email, String fullname, Long directoryId, int userEventType) throws PermissionException, CreateException {
        User user = this.createUserNoNotification(username, password, email, fullname, directoryId);
        Directory directory = this.userManager.getDirectory(Long.valueOf(user.getDirectoryId()));
        Map eventParams = EasyMap.build((Object)"username", (Object)username, (Object)"email", (Object)email, (Object)"fullname", (Object)fullname, (Object)"directoryName", (Object)directory.getName());
        if (this.userManager.canUpdateUserPassword(user)) {
            UserUtil.PasswordResetToken passwordResetToken = this.generatePasswordResetToken(user);
            eventParams.put("password.token", passwordResetToken.getToken());
            eventParams.put("password.hours", passwordResetToken.getExpiryHours());
        }
        this.dispatchEvent(user, userEventType, eventParams);
        return user;
    }

    protected void dispatchEvent(User user, int userEventType, Map<?, ?> args) {
        UserEventDispatcher.dispatchEvent(userEventType, user, args);
    }

    public void removeUser(User loggedInUser, User user) {
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        try {
            String userForDeleteName = user.getName();
            this.projectRoleService.removeAllRoleActorsByNameAndType(userForDeleteName, "atlassian-user-role-actor");
            this.permissionManager.removeUserPermissions(userForDeleteName);
            this.removeWatchesForUser(user);
            this.removeVotesForUser(user);
            this.subscriptionManager.deleteSubscriptionsForUser(user);
            this.notificationSchemeManager.removeEntities("Single_User", user.getName());
            this.removeComponentLeadsForUser(user, i18nBean, (ErrorCollection)errors);
            this.getSearchRequestService().deleteAllFiltersForUser(this.getServiceContext(loggedInUser), user);
            this.getPortalPageService().deleteAllPortalPagesForUser(user);
            this.userHistoryManager.removeHistoryForUser(user);
            try {
                this.crowdService.removeUser(user);
            }
            catch (OperationNotPermittedException e) {
                throw new PermissionException((Exception)((Object)e));
            }
        }
        catch (Exception e) {
            log.error((Object)("There was an error trying to remove user: " + user.getDisplayName()), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.clearActiveUserCount();
    }

    public long getNumberOfReportedIssuesIgnoreSecurity(User loggedInUser, User user) throws SearchException {
        Query query = JqlQueryBuilder.newBuilder().where().reporterUser(user.getName()).buildQuery();
        return this.searchProvider.searchCountOverrideSecurity(query, loggedInUser);
    }

    public long getNumberOfAssignedIssuesIgnoreSecurity(User loggedInUser, User user) throws SearchException {
        Query query = JqlQueryBuilder.newBuilder().where().assigneeUser(user.getName()).buildQuery();
        return this.searchProvider.searchCountOverrideSecurity(query, loggedInUser);
    }

    public Collection<ProjectComponent> getComponentsUserLeads(User user) {
        return this.componentManager.findComponentsByLead(user.getName());
    }

    public Collection<Project> getProjectsLeadBy(User user) {
        return this.projectManager.getProjectsLeadBy(user);
    }

    public Collection<GenericValue> getProjectsUserLeads(User user) {
        return this.projectManager.getProjectsByLead(user);
    }

    public boolean isNonSysAdminAttemptingToDeleteSysAdmin(User loggedInUser, User user) {
        return this.permissionManager.hasPermission(44, user) && !this.permissionManager.hasPermission(44, loggedInUser);
    }

    private void removeVotesForUser(User userForDelete) {
        VoteManager voteManager = ComponentAccessor.getVoteManager();
        if (this.applicationProperties.getOption("jira.option.voting")) {
            voteManager.removeVotesForUser(userForDelete);
        }
    }

    private void removeWatchesForUser(User userForDelete) {
        WatcherManager watcherManager = ComponentAccessor.getWatcherManager();
        if (this.applicationProperties.getOption("jira.option.watching")) {
            watcherManager.removeAllWatchesForUser(userForDelete);
        }
    }

    private void removeComponentLeadsForUser(User user, I18nHelper i18nHelper, ErrorCollection errorCollection) throws Exception {
        for (ProjectComponent component : this.getComponentsUserLeads(user)) {
            GenericValue genericValue = component.getGenericValue();
            Map map = EasyMap.build((Object)"entity", (Object)genericValue, (Object)"name", (Object)component.getName(), (Object)"description", (Object)component.getDescription(), (Object)"lead", null, (Object)"project", (Object)this.projectManager.getProject(component.getProjectId()));
            ActionResult aResult = CoreFactory.getActionDispatcher().execute(ActionNames.COMPONENT_EDIT, map);
            try {
                ActionUtils.checkForErrors(aResult);
            }
            catch (Exception e) {
                errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.projectentity.could.not.edit", "component", e.toString()));
            }
        }
    }

    public void addUserToGroup(Group group, User userToAdd) throws PermissionException, AddException {
        this.doAddUserToGroup(group, userToAdd);
    }

    void doAddUserToGroup(Group group, User userToAdd) throws PermissionException, AddException {
        this.validateParameters(group, userToAdd);
        if (!this.crowdService.isUserMemberOfGroup(userToAdd, group)) {
            try {
                this.crowdService.addUserToGroup(userToAdd, group);
            }
            catch (OperationNotPermittedException e) {
                throw new PermissionException((Exception)((Object)e));
            }
            catch (com.atlassian.crowd.exception.runtime.OperationFailedException e) {
                throw new AddException((Exception)((Object)e));
            }
        }
        this.clearUsersLevels();
        this.clearActiveUserCount();
    }

    public void addUserToGroups(Collection<Group> groups, User userToAdd) throws PermissionException, AddException {
        for (Group group : groups) {
            this.addUserToGroup(group, userToAdd);
        }
        this.clearUsersLevels();
    }

    public void removeUserFromGroup(Group group, User userToRemove) throws PermissionException, RemoveException {
        this.validateParameters(group, userToRemove);
        if (this.crowdService.isUserDirectGroupMember(userToRemove, group)) {
            try {
                this.crowdService.removeUserFromGroup(userToRemove, group);
            }
            catch (OperationNotPermittedException e) {
                throw new PermissionException((Exception)((Object)e));
            }
            catch (com.atlassian.crowd.exception.runtime.OperationFailedException e) {
                throw new RemoveException((Exception)((Object)e));
            }
        }
        this.clearUsersLevels();
        this.clearActiveUserCount();
    }

    public void removeUserFromGroups(Collection<Group> groups, User userToRemove) throws PermissionException, RemoveException {
        for (Group group : groups) {
            this.removeUserFromGroup(group, userToRemove);
        }
        this.clearUsersLevels();
    }

    public UserUtil.PasswordResetToken generatePasswordResetToken(User user) {
        return new PasswordResetTokenBuilder(this.crowdService).generateToken(user);
    }

    public UserUtil.PasswordResetTokenValidation validatePasswordResetToken(User user, String token) {
        Assertions.notNull((String)"user", (Object)user);
        final UserUtil.PasswordResetTokenValidation.Status status = new PasswordResetTokenBuilder(this.crowdService).validateToken(user, token);
        return new UserUtil.PasswordResetTokenValidation(){

            public UserUtil.PasswordResetTokenValidation.Status getStatus() {
                return status;
            }
        };
    }

    public void changePassword(User user, String newPassword) throws PermissionException {
        Assertions.notNull((String)"user", (Object)user);
        new PasswordResetTokenBuilder(this.crowdService).resetToken(user);
        ((RememberMeTokenDao)this.componentLocator.getComponent(RememberMeTokenDao.class)).removeAllForUser(user.getName());
        ((LoginManager)this.componentLocator.getComponent(LoginManager.class)).resetFailedLoginCount(user);
        try {
            this.crowdService.updateUserCredential(user, newPassword);
        }
        catch (OperationNotPermittedException e) {
            throw new PermissionException((Exception)((Object)e));
        }
        catch (InvalidCredentialException e) {
            throw new RuntimeException(e);
        }
    }

    public int getActiveUserCount() {
        return (Integer)this.activeUsersCount.get();
    }

    public void clearActiveUserCount() {
        this.hooks.getLicenseHooks().clearActiveUserCount(new Function<Void, Void>(){

            public Void get(Void input) {
                UserUtilImpl.this.activeUsersCount.reset();
                return null;
            }
        });
    }

    public boolean hasExceededUserLimit() {
        return this.hooks.getLicenseHooks().hasExceededUserLimit(new Function<Void, Boolean>(){

            public Boolean get(Void input) {
                return UserUtilImpl.this.hasExceededUserLimitInternal();
            }
        });
    }

    private boolean hasExceededUserLimitInternal() {
        LicenseDetails licenseDetails = this.getLicenseDetails();
        if (!licenseDetails.isLicenseSet()) {
            return false;
        }
        if (!licenseDetails.isUnlimitedNumberOfUsers()) {
            return this.getActiveUserCount() > licenseDetails.getMaximumNumberOfUsers();
        }
        return false;
    }

    public boolean canActivateNumberOfUsers(int numUsers) {
        return this.hooks.getLicenseHooks().canActivateNumberOfUsers(numUsers, new Function<Integer, Boolean>(){

            public Boolean get(Integer input) {
                Preconditions.checkNotNull((Object)input, (Object)"numUsers is null.");
                return UserUtilImpl.this.canActivateNumberOfUsersInternal(input);
            }
        });
    }

    private boolean canActivateNumberOfUsersInternal(int numUsers) {
        if (numUsers < 0) {
            throw new IllegalArgumentException("numUsers must be non-negative");
        }
        if (numUsers == 0) {
            return true;
        }
        LicenseDetails licenseDetails = this.getLicenseDetails();
        if (!licenseDetails.isLicenseSet()) {
            return false;
        }
        if (!licenseDetails.isUnlimitedNumberOfUsers()) {
            return this.getActiveUserCount() + numUsers <= licenseDetails.getMaximumNumberOfUsers();
        }
        return true;
    }

    public boolean canActivateUsers(Collection<String> userNames) {
        return this.hooks.getLicenseHooks().canActivateUsers(userNames, new Function<Collection<String>, Boolean>(){

            public Boolean get(Collection<String> input) {
                return UserUtilImpl.this.canActivateUsersInternal(input);
            }
        });
    }

    private boolean canActivateUsersInternal(Collection<String> userNames) {
        Assertions.notNull((String)"userNames", userNames);
        LicenseDetails licenseDetails = this.getLicenseDetails();
        if (!licenseDetails.isLicenseSet()) {
            return true;
        }
        if (!licenseDetails.isUnlimitedNumberOfUsers()) {
            Set<String> groupsWithUsePermission = this.getGroupsWithUsePermission();
            int numInactiveUsers = 0;
            Iterator<String> i$ = userNames.iterator();
            while (i$.hasNext()) {
                String element;
                String userName = element = i$.next();
                ArrayList<String> groupNames = new ArrayList<String>();
                Iterable<Group> userGroups = this.getGroupsForUserFromCrowd(userName);
                for (Group group : userGroups) {
                    groupNames.add(group.getName());
                }
                if (CollectionUtils.containsAny(groupNames, groupsWithUsePermission)) continue;
                ++numInactiveUsers;
            }
            int userCount = this.getActiveUserCount();
            if (numInactiveUsers != 0 && userCount + numInactiveUsers > licenseDetails.getMaximumNumberOfUsers()) {
                return false;
            }
        }
        return true;
    }

    public Set<User> getAllUsers() {
        return (Set)this.getUsers();
    }

    public Collection<User> getUsers() {
        NullRestriction restriction = NullRestrictionImpl.INSTANCE;
        UserQuery query = new UserQuery(User.class, (SearchRestriction)restriction, 0, -1);
        Iterable crowdUsers = this.crowdService.search((com.atlassian.crowd.embedded.api.Query)query);
        if (crowdUsers instanceof Collection) {
            return (Collection)crowdUsers;
        }
        HashSet<User> allUsers = new HashSet<User>();
        for (User crowdUser : crowdUsers) {
            allUsers.add(crowdUser);
        }
        return allUsers;
    }

    public int getTotalUserCount() {
        NullRestriction restriction = NullRestrictionImpl.INSTANCE;
        UserQuery query = new UserQuery(User.class, (SearchRestriction)restriction, 0, -1);
        Iterable crowdUsers = this.crowdService.search((com.atlassian.crowd.embedded.api.Query)query);
        if (crowdUsers instanceof Collection) {
            return ((Collection)crowdUsers).size();
        }
        int count = 0;
        for (User crowdUser : crowdUsers) {
            ++count;
        }
        return count;
    }

    private User getUserCwd(String userName) {
        return this.crowdService.getUser(userName);
    }

    public User getUser(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            return this.getUserCwd(userName);
        }
        return null;
    }

    public User getUserObject(String userName) {
        return this.getUser(userName);
    }

    public boolean userExists(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            return this.getUserCwd(userName) != null;
        }
        return false;
    }

    public Collection<User> getAdministrators() {
        return this.getJiraAdministrators();
    }

    public Collection<User> getJiraAdministrators() {
        return this.getAllUsersInGroups(this.globalPermissionManager.getGroupsWithPermission(0));
    }

    public Collection<User> getSystemAdministrators() {
        return this.getJiraSystemAdministrators();
    }

    public Collection<User> getJiraSystemAdministrators() {
        return this.getAllUsersInGroups(this.globalPermissionManager.getGroupsWithPermission(44));
    }

    public void addToJiraUsePermission(User user) {
        if (this.canActivateNumberOfUsers(1)) {
            Collection<Group> groups = this.getGroupsWithUsePermissionAndNoAdminsitrativePermissions();
            for (Group group : groups) {
                try {
                    this.doAddUserToGroup(group, user);
                }
                catch (PermissionException e) {
                }
                catch (AddException e) {}
            }
        }
    }

    private Collection<Group> getGroupsWithUsePermissionAndNoAdminsitrativePermissions() {
        ArrayList useGroups = new ArrayList(this.globalPermissionManager.getGroupsWithPermission(1));
        useGroups.removeAll(this.globalPermissionManager.getGroupsWithPermission(0));
        useGroups.removeAll(this.globalPermissionManager.getGroupsWithPermission(44));
        return Collections.unmodifiableCollection(useGroups);
    }

    public String getDisplayableNameSafely(User user) {
        if (user == null) {
            return null;
        }
        String fullName = user.getDisplayName();
        if (StringUtils.isNotBlank((String)fullName)) {
            return fullName;
        }
        return user.getName();
    }

    public SortedSet<User> getAllUsersInGroups(Collection<Group> groups) {
        return this.getUsersInGroups(groups);
    }

    public SortedSet<User> getUsersInGroups(Collection<Group> groups) {
        Assertions.notNull((String)"groups", groups);
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Group group : groups) {
            if (group == null) continue;
            groupNames.add(group.getName());
        }
        return this.getUsersInGroupNames(groupNames);
    }

    public SortedSet<User> getAllUsersInGroupNames(Collection<String> groupNames) {
        return this.getUsersInGroupNames(groupNames);
    }

    public SortedSet<User> getUsersInGroupNames(Collection<String> groupNames) {
        Assertions.notNull((String)"groupNames", groupNames);
        TreeSet<User> setOfUsers = new TreeSet<User>((Comparator<User>)new UserBestNameComparator());
        for (String groupName : groupNames) {
            if (groupName == null) continue;
            Iterable<User> users = this.getGroupMembers(groupName);
            for (User user : users) {
                setOfUsers.add(user);
            }
        }
        return Collections.unmodifiableSortedSet(setOfUsers);
    }

    public SortedSet<Group> getGroupsForUser(String userName) {
        Assertions.notNull((String)"userName", (Object)userName);
        TreeSet<Group> setOfGroups = new TreeSet<Group>();
        Iterable<Group> groups = this.getGroupsForUserFromCrowd(userName);
        for (Group group : groups) {
            setOfGroups.add(group);
        }
        return Collections.unmodifiableSortedSet(setOfGroups);
    }

    public SortedSet<String> getGroupNamesForUser(String userName) {
        Assertions.notNull((String)"userName", (Object)userName);
        TreeSet<String> setOfGroups = new TreeSet<String>();
        Iterable<String> groups = this.getGroupNamesForUserFromCrowd(userName);
        for (String groupName : groups) {
            setOfGroups.add(groupName);
        }
        return Collections.unmodifiableSortedSet(setOfGroups);
    }

    private Group getGroupCwd(String groupName) {
        return this.crowdService.getGroup(groupName);
    }

    public Group getGroup(String groupName) {
        if (StringUtils.isNotEmpty((String)groupName)) {
            return this.getGroupCwd(groupName);
        }
        return null;
    }

    public Group getGroupObject(@Nullable String groupName) {
        return this.getGroup(groupName);
    }

    private void validateParameters(Group group, User userParam) {
        if (group == null) {
            throw new DataAccessException("Group must not be null if trying to add or delete a user from it.");
        }
        if (userParam == null) {
            throw new DataAccessException("User must not be null if trying to add or delete them from a group.");
        }
    }

    private void clearUsersLevels() {
        try {
            if (this.issueSecurityLevelManager != null) {
                this.issueSecurityLevelManager.clearUsersLevels();
            }
        }
        catch (UnsupportedOperationException uoe) {
            log.debug((Object)"Unsupported operation was thrown when trying to clear the issue security level manager cache", (Throwable)uoe);
        }
    }

    LicenseDetails getLicenseDetails() {
        return ((JiraLicenseService)this.componentLocator.getComponentInstanceOfType(JiraLicenseService.class)).getLicense();
    }

    Set<String> getGroupsWithUsePermission() {
        HashSet<String> groupsWithUsePermission = new HashSet<String>();
        for (Integer permission : Permissions.getUsePermissions()) {
            groupsWithUsePermission.addAll(this.globalPermissionManager.getGroupNames(permission.intValue()));
        }
        return groupsWithUsePermission;
    }

    I18nHelper getI18nBean(User user) {
        return new I18nBean(user);
    }

    private Iterable<User> getGroupMembers(String groupName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1);
        return this.crowdService.search((com.atlassian.crowd.embedded.api.Query)membershipQuery);
    }

    private Iterable<Group> getGroupsForUserFromCrowd(String userName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1);
        return this.crowdService.search((com.atlassian.crowd.embedded.api.Query)membershipQuery);
    }

    private Iterable<String> getGroupNamesForUserFromCrowd(String userName) {
        MembershipQuery membershipQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(userName).returningAtMost(-1);
        return this.crowdService.search((com.atlassian.crowd.embedded.api.Query)membershipQuery);
    }
}

