/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.profile.AbstractUserProfileFragment;
import com.atlassian.jira.util.VelocityParamFactory;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.velocity.VelocityManager;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.ofbiz.core.entity.GenericValue;

public class AssignedAndOpenUserProfileFragment
extends AbstractUserProfileFragment {
    private final PermissionManager permissionManager;
    private final SearchService searchService;

    public AssignedAndOpenUserProfileFragment(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, VelocityManager velocityManager, VelocityParamFactory velocityParamFactory, PermissionManager permissionManager, SearchService searchService) {
        super(applicationProperties, jiraAuthenticationContext, velocityManager, velocityParamFactory);
        this.permissionManager = permissionManager;
        this.searchService = searchService;
    }

    @Override
    @SuppressWarnings(value={"NM_WRONG_PACKAGE"}, justification="OSUser is deprecated and dying anyway. Plus the method in question is final so we can't override it.")
    public boolean showFragment(User profileUser, User currentUser) {
        return CollectionUtils.containsAny((Collection)this.permissionManager.getProjectObjects(10, currentUser), (Collection)this.permissionManager.getProjectObjects(17, profileUser));
    }

    @Override
    protected Map<String, Object> createVelocityParams(User profileUser, User currentUser) {
        Map<String, Object> params = super.createVelocityParams(profileUser, currentUser);
        params.put("projects", this.getProjects(profileUser, currentUser));
        params.put("urlBuilder", new UrlBuilder(profileUser, currentUser));
        return params;
    }

    @Override
    public String getId() {
        return "assigned-and-open";
    }

    private StatisticMapWrapper getProjects(User profileUser, User currentUser) {
        JqlClauseBuilder builder = this.getBaseQuery(profileUser, currentUser);
        SearchRequest request = new SearchRequest(builder.buildQuery());
        try {
            StatisticAccessorBean bean = new StatisticAccessorBean(currentUser, request);
            StatisticMapWrapper mapWrapper = bean.getAllFilterBy("project");
            return mapWrapper;
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    private JqlClauseBuilder getBaseQuery(User profileUser, User currentUser) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().unresolved();
        if (profileUser.equals(currentUser)) {
            builder.and().assigneeIsCurrentUser();
        } else {
            builder.and().assignee().eq(profileUser.getName());
        }
        return builder;
    }

    public class UrlBuilder {
        private final User profileUser;
        private final User currentUser;

        public UrlBuilder(User profileUser, User currentUser) {
            this.profileUser = profileUser;
            this.currentUser = currentUser;
        }

        public String getUrl(GenericValue project) {
            JqlClauseBuilder builder = AssignedAndOpenUserProfileFragment.this.getBaseQuery(this.profileUser, this.currentUser);
            builder.and().project(new Long[]{project.getLong("id")});
            return AssignedAndOpenUserProfileFragment.this.searchService.getQueryString(this.currentUser, builder.buildQuery());
        }
    }
}

