/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.CachingUserHistoryStore;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.UserQueryHistoryManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;

public class DefaultUserQueryHistoryManager
implements UserQueryHistoryManager {
    private final UserHistoryManager userHistoryManager;
    private ApplicationProperties applicationProperties;

    public DefaultUserQueryHistoryManager(UserHistoryManager userHistoryManager, ApplicationProperties applicationProperties) {
        this.userHistoryManager = userHistoryManager;
        this.applicationProperties = applicationProperties;
    }

    public void addQueryToHistory(User user, String query) {
        Assertions.notNull((String)"query", (Object)query);
        this.userHistoryManager.addItemToHistory(UserHistoryItem.JQL_QUERY, user, String.valueOf(query.hashCode()), query);
    }

    public List<UserHistoryItem> getUserQueryHistory(User user) {
        List history = this.userHistoryManager.getHistory(UserHistoryItem.JQL_QUERY, user);
        int max = CachingUserHistoryStore.getMaxItems(UserHistoryItem.JQL_QUERY, this.applicationProperties);
        if (history.size() > max) {
            return history.subList(0, max);
        }
        return history;
    }
}

