/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.jql.util.JqlDateSupportImpl;
import com.atlassian.jira.upgrade.tasks.jql.AbstractDateXmlHandler;
import com.atlassian.jira.upgrade.tasks.jql.JqlXmlSupport;
import com.atlassian.jira.util.Function;
import com.atlassian.util.concurrent.Assertions;
import electric.xml.Element;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RelativeDateXmlHandler
extends AbstractDateXmlHandler {
    private static final Logger log = Logger.getLogger(RelativeDateXmlHandler.class);
    private static final String ELEMENT_FROM_DURATION = "previousOffset";
    private static final String ELEMENT_TO_DURATION = "nextOffset";
    private final Function<Long, String> durationConverter;

    public RelativeDateXmlHandler(Collection<String> supportedXmlFieldNames) {
        this(supportedXmlFieldNames, new DurationConverter());
    }

    RelativeDateXmlHandler(Collection<String> supportedXmlFieldNames, Function<Long, String> durationConverter) {
        super(supportedXmlFieldNames);
        this.durationConverter = (Function)Assertions.notNull((String)"durationConverter", durationConverter);
    }

    @Override
    protected String getLowerBound(String fieldName, Element element) {
        return this.getBound(fieldName, element, ELEMENT_FROM_DURATION);
    }

    @Override
    protected String getUpperBound(String fieldName, Element element) {
        return this.getBound(fieldName, element, ELEMENT_TO_DURATION);
    }

    private String getBound(String fieldName, Element element, String subElement) {
        String dateString = JqlXmlSupport.getTextFromSubElement(element, subElement);
        if (dateString != null) {
            try {
                long dateLong = Long.parseLong(dateString);
                return (String)this.durationConverter.get((Object)dateLong);
            }
            catch (NumberFormatException e) {
                log.warn((Object)String.format("Date parameter '%s' in element '%s' is and invalid duration for field '%s'.", dateString, subElement, fieldName));
            }
        }
        return null;
    }

    static final class DurationConverter
    implements Function<Long, String> {
        DurationConverter() {
        }

        public String get(Long input) {
            return JqlDateSupportImpl.getDurationString(-input.longValue());
        }
    }
}

