/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build605
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build605.class);
    static final String JIRA_OPTION_CACHE_PROJECTS = "jira.option.cache.projects";
    static final String JIRA_OPTION_CACHE_PERMISSIONS = "jira.option.cache.permissions";
    static final String JIRA_OPTION_CACHE_ISSUES = "jira.option.cache.issues";
    public static final String ISSUE_CACHE_LISTENER_CLASS = "com.atlassian.jira.event.listeners.cache.IssueCacheListener";
    private final PropertiesManager propertiesManager;

    public UpgradeTask_Build605(PropertiesManager propertiesManager) {
        super(false);
        this.propertiesManager = propertiesManager;
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        List listenerConfigs = this.getDelegator().findAll("ListenerConfig");
        ArrayList<GenericValue> toRemove = new ArrayList<GenericValue>();
        for (GenericValue listenerConfig : listenerConfigs) {
            if (!listenerConfig.getString("clazz").equals(ISSUE_CACHE_LISTENER_CLASS)) continue;
            toRemove.add(listenerConfig);
        }
        this.getDelegator().removeAll(toRemove);
        this.removeOption(JIRA_OPTION_CACHE_ISSUES);
        this.removeOption(JIRA_OPTION_CACHE_PERMISSIONS);
        this.removeOption(JIRA_OPTION_CACHE_PROJECTS);
        log.debug((Object)"Removed JIRA issue cache configuration and listener");
    }

    private void removeOption(String key) {
        PropertySet ps = this.propertiesManager.getPropertySet();
        if (ps.exists(key)) {
            ps.remove(key);
        }
    }

    @Override
    public String getBuildNumber() {
        return "605";
    }
}

