/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.portal.OfBizPortalPageStore;
import com.atlassian.jira.portal.PortalPageStore;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build437
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build437.class);
    private final OfBizDelegator delegator;
    private final PortalPageStore portalPageStore;

    public UpgradeTask_Build437(OfBizDelegator delegator, PortalPageStore portalPageStore) {
        super(false);
        this.delegator = delegator;
        this.portalPageStore = portalPageStore;
    }

    @Override
    public String getBuildNumber() {
        return "437";
    }

    @Override
    public String getShortDescription() {
        return "Initialising dashboard version numbers for optimistic locking.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        OfBizListIterator iterator = this.delegator.findListIteratorByCondition(OfBizPortalPageStore.Table.NAME, (EntityCondition)new EntityExpr("version", EntityOperator.EQUALS, null));
        ArrayList<Long> portalPageIds = new ArrayList<Long>();
        try {
            GenericValue portalPageGv = iterator.next();
            while (portalPageGv != null) {
                portalPageIds.add(portalPageGv.getLong("id"));
                portalPageGv = iterator.next();
            }
        }
        finally {
            iterator.close();
        }
        try {
            int rowsUpdated = this.delegator.bulkUpdateByPrimaryKey(OfBizPortalPageStore.Table.NAME, MapBuilder.newBuilder().add((Object)"version", (Object)0L).toMap(), portalPageIds);
            log.info((Object)("Initialised " + rowsUpdated + " dashboard versions to 0."));
        }
        finally {
            this.portalPageStore.flush();
        }
    }
}

