/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpgradeTask_Build205
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build205.class);
    private final OfBizDelegator ofBizDelegator;
    private final EventTypeManager eventTypeManager;
    static final String ISSUE_COMMENT_EDITED_NAME_KEY = "event.type.issuecommentedited.name";
    static final String ISSUE_COMMENT_EDITED_DESC_KEY = "event.type.issuecommentedited.desc";
    static final String ISSUE_COMMENT_EDITED_NAME = "Issue Comment Edited";
    static final String ISSUE_COMMENT_EDITED_DESC = "This is the 'Issue Comment Edited' event type.";

    public UpgradeTask_Build205(OfBizDelegator ofBizDelegator, EventTypeManager eventTypeManager) {
        super(false);
        this.ofBizDelegator = ofBizDelegator;
        this.eventTypeManager = eventTypeManager;
    }

    @Override
    public String getBuildNumber() {
        return "205";
    }

    @Override
    public String getShortDescription() {
        return "Creates the notification event for the Issue Comment Edited event";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws DataAccessException {
        try {
            Map eventTypeParamasMap = EasyMap.build((Object)"id", (Object)EventType.ISSUE_COMMENT_EDITED_ID, (Object)"name", (Object)this.getI18nTextWithDefault(ISSUE_COMMENT_EDITED_NAME_KEY, ISSUE_COMMENT_EDITED_NAME), (Object)"description", (Object)this.getI18nTextWithDefault(ISSUE_COMMENT_EDITED_DESC_KEY, ISSUE_COMMENT_EDITED_DESC), (Object)"type", (Object)"jira.system.event.type");
            this.ofBizDelegator.createValue("EventType", eventTypeParamasMap);
            this.eventTypeManager.clearCache();
        }
        catch (DataAccessException e) {
            log.error((Object)"JIRA was unable to create the new notification event type of 'Issue Comment Edited' with an id of 14.");
            throw e;
        }
    }

    private String getI18nTextWithDefault(String key, String defaultResult) {
        String result = this.getApplicationI18n().getText(key);
        if (result.equals(key)) {
            return defaultResult;
        }
        return result;
    }

    I18nHelper getApplicationI18n() {
        return new I18nBean();
    }
}

