/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.JiraListener;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.event.listeners.history.IssueAssignHistoryListener;
import com.atlassian.jira.event.listeners.mail.MailListener;
import com.atlassian.jira.event.listeners.search.IssueIndexListener;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.startup.JiraStartupLogger;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.upgrade.ConsistencyChecker;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.CompositeShutdown;
import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.Shutdown;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.system.check.PluginVersionCheck;
import com.atlassian.jira.util.system.check.SystemEnvironmentChecklist;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.PluginAccessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.lucene.search.BooleanQuery;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ConsistencyCheckImpl
implements ConsistencyChecker {
    private static final Logger log = Logger.getLogger(ConsistencyCheckImpl.class);
    private final JiraStartupLogger startupLog = new JiraStartupLogger();
    static final String INIT_KEY = ConsistencyCheckImpl.class.getName() + ":initialized";

    @Override
    public void destroy(ServletContext context) {
        Boolean initialized = (Boolean)context.getAttribute(INIT_KEY);
        if (initialized == null || !initialized.booleanValue()) {
            return;
        }
        Collection<JiraServiceContainer> services = this.getServices();
        Iterator<JiraServiceContainer> i$ = services.iterator();
        while (i$.hasNext()) {
            JiraServiceContainer element;
            JiraServiceContainer service = element = i$.next();
            try {
                service.destroy();
            }
            catch (RuntimeException e) {
                log.error((Object)("Failed to destroy service '" + (service != null && service.getName() != null ? service.getName() : "Unknown") + "' " + e.getMessage()), (Throwable)e);
            }
        }
        try {
            this.getShutdown().shutdown();
        }
        catch (RuntimeException e) {
            log.error((Object)"Failed to run shutdown hooks.", (Throwable)e);
        }
    }

    private Shutdown getShutdown() {
        return new CompositeShutdown(this.getIndexManagerShutdown(), this.getComponentManager(), new Shutdown(){

            public void shutdown() {
                ConsistencyCheckImpl.this.getTaskManager().shutdownAndWait(0L);
            }
        });
    }

    Shutdown getComponentManager() {
        return ComponentManager.getInstance();
    }

    IndexLifecycleManager getIndexManager() {
        return ComponentManager.getComponent(IndexLifecycleManager.class);
    }

    LuceneDirectoryUtils getLuceneDirectoryUtils() {
        return (LuceneDirectoryUtils)ComponentAccessor.getComponent(LuceneDirectoryUtils.class);
    }

    private Shutdown getIndexManagerShutdown() {
        try {
            return this.getIndexManager();
        }
        catch (RuntimeException e) {
            log.error((Object)"Failed to get IndexManager, cannot shut it down cleanly...", (Throwable)e);
            return new Shutdown(){

                public void shutdown() {
                }

                public String toString() {
                    return "NullShutdownForIndexManager";
                }
            };
        }
    }

    TaskManager getTaskManager() {
        return ComponentManager.getComponent(TaskManager.class);
    }

    protected Collection<JiraServiceContainer> getServices() {
        return ComponentManager.getComponent(ServiceManager.class).getServices();
    }

    @Override
    public void initialise(ServletContext servletContext) {
        this.setStartupTime(servletContext);
        this.checkConsistency(servletContext);
        this.checkAndInitLucene(servletContext);
        new PluginVersionCheck(ComponentManager.getComponentInstanceOfType(PluginAccessor.class), ComponentManager.getComponentInstanceOfType(BuildUtilsInfo.class)).check(servletContext);
        this.printJIRAStartupMessage(servletContext);
        ServletContextProvider.getServletContext().setAttribute(INIT_KEY, (Object)Boolean.TRUE);
    }

    private void printJIRAStartupMessage(ServletContext context) {
        JohnsonEventContainer eventCont = JohnsonEventContainer.get((ServletContext)context);
        if (eventCont == null || !eventCont.hasEvents()) {
            this.startupLog.printStartedMessage();
        }
        this.checkSystemEnvironment();
    }

    public void checkConsistency(ServletContext context) {
        try {
            log.debug((Object)"Checking JIRA consistency");
            boolean connection = this.checkConnection(context);
            if (connection) {
                this.checkDataConsistency();
            }
        }
        catch (Throwable e) {
            log.error((Object)("Exception during consistency check: " + e), e);
        }
    }

    @Override
    public void checkDataConsistency() throws Exception {
        this.checkMailListenerAndService();
        this.checkIssueAssignHistoryListener();
        this.checkAttachmentPath();
        this.checkIndexingSetup();
        this.checkLanguageExists();
        this.checkAndInitSID();
    }

    private void checkSystemEnvironment() {
        List<String> messages = SystemEnvironmentChecklist.getEnglishWarningMessages();
        for (String message : messages) {
            this.startupLog.printMessage(message, Level.WARN);
        }
    }

    private void checkAndInitLucene(ServletContext context) {
        ApplicationProperties ap = ManagerFactory.getApplicationProperties();
        if (ap.getOption("jira.option.indexing")) {
            IndexLifecycleManager indexManager = this.getIndexManager();
            Collection existingLockFilepaths = this.getLuceneDirectoryUtils().getStaleLockPaths(indexManager.getAllIndexPaths());
            if (existingLockFilepaths != null && !existingLockFilepaths.isEmpty()) {
                StringBuffer sb = new StringBuffer();
                for (String filePath : existingLockFilepaths) {
                    if (filePath == null) continue;
                    sb.append(filePath).append(' ');
                }
                if (sb.length() > 1) {
                    sb.deleteCharAt(sb.length() - 1);
                }
                List messages = CollectionBuilder.newBuilder((Object[])new String[]{"Index lock file(s) found. This occurs either because JIRA was not cleanly shutdown", "or because there is another instance of this JIRA installation currently running.", "Please ensure that no other instance of this JIRA installation is running", "and then remove the following lock file(s) and restart JIRA:", "", sb.toString(), "", "Once restarted you will need to reindex your data to ensure that indexes are up to date.", "", "Do NOT delete the lock file(s) if there is another JIRA running with the same index directory", "instead cleanly shutdown the other instance."}).asList();
                this.startupLog.printMessage(messages, Level.ERROR);
                Event event = new Event(EventType.get((String)"index-lock-already-exists"), "An existing index lock was found.", EventLevel.get((String)"error"));
                event.addAttribute((Object)"lockfiles", (Object)sb.toString());
                JohnsonEventContainer eventCont = JohnsonEventContainer.get((ServletContext)context);
                if (eventCont != null) {
                    eventCont.addEvent(event);
                }
            }
        }
        int maxClausesCount = 65000;
        try {
            maxClausesCount = Integer.parseInt(ap.getDefaultBackedString("jira.search.maxclauses"));
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Could not read the property 'jira.search.maxclauses' for the number of maximum search clauses. Using default " + maxClausesCount));
        }
        BooleanQuery.setMaxClauseCount((int)maxClausesCount);
    }

    private void checkLanguageExists() {
        ApplicationProperties ap = ManagerFactory.getApplicationProperties();
        if (ap.getString("jira.i18n.language.index") == null) {
            log.info((Object)"Input Language has not been set.  Setting to 'English'");
            ap.setString("jira.i18n.language.index", "english");
        }
    }

    private boolean checkConnection(ServletContext context) {
        boolean worked;
        block6: {
            worked = true;
            try {
                GenericDelegator delegator = CoreFactory.getGenericDelegator();
                if (delegator == null) {
                    log.error((Object)"Could not get GenericDelegator");
                    worked = false;
                    break block6;
                }
                try {
                    delegator.findAll("Project");
                }
                catch (GenericEntityException e) {
                    log.error((Object)("Could not connect to database. Check your entityengine.xml settings: " + (Object)((Object)e)), (Throwable)e);
                    worked = false;
                    Event event = new Event(EventType.get((String)"database"), "Could not connect to database", e.getMessage(), EventLevel.get((String)"error"));
                    JohnsonEventContainer eventCont = JohnsonEventContainer.get((ServletContext)context);
                    if (eventCont != null) {
                        eventCont.addEvent(event);
                    }
                }
            }
            catch (Throwable t) {
                log.error((Object)("Could not check database connection. Check your entityengine.xml settings: " + t), t);
                worked = false;
                Event event = new Event(EventType.get((String)"database"), "Could not connect to database.", t.getMessage(), EventLevel.get((String)"error"));
                JohnsonEventContainer eventCont = JohnsonEventContainer.get((ServletContext)context);
                if (eventCont == null) break block6;
                eventCont.addEvent(event);
            }
        }
        return worked;
    }

    private void checkMailListenerAndService() throws Exception {
        this.ensureSingleListener(MailListener.class, "Mail Listener");
        this.ensureSingleService("com.atlassian.jira.service.services.mail.MailQueueService", "Mail Queue Service");
    }

    private void checkIssueAssignHistoryListener() throws Exception {
        this.ensureSingleListener(IssueAssignHistoryListener.class, "Issue Assignment Listener");
    }

    private void checkAttachmentPath() throws Exception {
        String attachmentPath;
        ApplicationProperties ap = ManagerFactory.getApplicationProperties();
        if (ap.getOption("jira.option.allowattachments") && ((attachmentPath = ComponentAccessor.getAttachmentPathManager().getAttachmentPath()) == null || !this.directoryExists(attachmentPath))) {
            log.error((Object)("Attachments are turned on, but attachment path [" + attachmentPath + "] invalid - disabling attachments"));
            ap.setOption("jira.option.allowattachments", false);
        }
    }

    private void checkIndexingSetup() throws Exception {
        ApplicationProperties ap = ManagerFactory.getApplicationProperties();
        if (ap.getOption("jira.option.indexing")) {
            String indexPath = ComponentAccessor.getIndexPathManager().getIndexRootPath();
            if (!this.directoryExists(indexPath)) {
                log.error((Object)("Indexing is turned on, but index path [" + indexPath + "] invalid - disabling indexing"));
                this.removeListeners(IssueIndexListener.class);
                ap.setOption("jira.option.indexing", false);
                return;
            }
            this.ensureSingleListener(IssueIndexListener.class, "Issue Index Listener");
        }
    }

    private boolean directoryExists(String path) {
        File dir;
        return path != null && (dir = new File(path)).exists() && dir.isDirectory();
    }

    private void ensureSingleListener(Class<? extends JiraListener> clazz, String name) throws Exception {
        String classname = clazz.getName();
        List listenerConfigs = CoreFactory.getGenericDelegator().findAll("ListenerConfig");
        boolean foundOne = false;
        ArrayList<GenericValue> toRemove = new ArrayList<GenericValue>();
        for (GenericValue element : listenerConfigs) {
            GenericValue listenerConfig = element;
            if (!listenerConfig.getString("clazz").equals(classname)) continue;
            if (foundOne) {
                toRemove.add(listenerConfig);
                continue;
            }
            foundOne = true;
        }
        if (!foundOne) {
            if ("true".equals(ManagerFactory.getApplicationProperties().getString("jira.setup"))) {
                log.error((Object)("Could not find " + name + ", adding."));
            } else {
                log.info((Object)("Could not find " + name + ", adding."));
            }
            ListenerManager listenerManager = (ListenerManager)ComponentAccessor.getComponent(ListenerManager.class);
            try {
                listenerManager.createListener(name, clazz);
            }
            catch (Exception e) {
                log.error((Object)("Error adding listener: " + e), (Throwable)e);
            }
        } else if (toRemove.size() > 0) {
            log.debug((Object)("Removing " + toRemove.size() + " extra listeners with class " + classname));
            CoreFactory.getGenericDelegator().removeAll(toRemove);
            ComponentAccessor.getListenerManager().refresh();
        }
    }

    private void ensureSingleService(String clazz, String name) throws Exception {
        Collection<JiraServiceContainer> serviceConfigs = this.getServices();
        boolean foundOne = false;
        ArrayList<JiraServiceContainer> toRemove = new ArrayList<JiraServiceContainer>();
        for (JiraServiceContainer service : serviceConfigs) {
            if (!service.getServiceClass().equals(clazz)) continue;
            if (foundOne) {
                toRemove.add(service);
                continue;
            }
            foundOne = true;
        }
        if (!foundOne) {
            if ("true".equals(ManagerFactory.getApplicationProperties().getString("jira.setup"))) {
                log.error((Object)("Could not find " + name + ", adding."));
            } else {
                log.info((Object)("Could not find " + name + ", adding."));
            }
            try {
                ManagerFactory.getServiceManager().addService(name, clazz, DateUtils.MINUTE_MILLIS);
            }
            catch (Exception e) {
                log.error((Object)("Error adding service: " + e), (Throwable)e);
            }
        } else if (!toRemove.isEmpty()) {
            log.debug((Object)("Removing " + toRemove.size() + " extra services with class " + clazz));
            Iterator<Object> i$ = toRemove.iterator();
            while (i$.hasNext()) {
                JiraServiceContainer element;
                JiraServiceContainer serviceContainer = element = (JiraServiceContainer)i$.next();
                ManagerFactory.getServiceManager().removeService(serviceContainer.getId());
            }
        }
    }

    private void setStartupTime(ServletContext context) {
        if (context != null) {
            context.setAttribute("jira_startup_time", (Object)System.currentTimeMillis());
        }
    }

    private void removeListeners(Class<? extends JiraListener> clazz) {
        ((ListenerManager)ComponentAccessor.getComponent(ListenerManager.class)).deleteListener(clazz);
    }

    private void checkAndInitSID() {
        String serverId = ComponentManager.getComponentInstanceOfType(JiraLicenseService.class).getServerId();
        if (log.isInfoEnabled()) {
            log.info((Object)("The Server ID for this JIRA instance is: [" + serverId + "]"));
        }
    }
}

