/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.timezone;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.timezone.RegionInfo;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.web.HttpRequestLocal;
import com.google.common.base.Preconditions;
import java.util.List;

public class TimeZoneServiceCachingDecorator
implements TimeZoneService {
    private final HttpRequestLocal<TimeZoneInfo> userTimeZoneCache = new HttpRequestLocal(TimeZoneServiceCachingDecorator.class.getName().replace('/', '.') + "#userTimeZone");
    private final TimeZoneService service;

    public TimeZoneServiceCachingDecorator(TimeZoneService timeZoneService) {
        this.service = (TimeZoneService)Preconditions.checkNotNull((Object)timeZoneService);
    }

    public void setUserDefaultTimeZone(String timeZoneId, JiraServiceContext serviceContext) {
        this.service.setUserDefaultTimeZone(timeZoneId, serviceContext);
        this.userTimeZoneCache.remove();
    }

    public void clearUserDefaultTimeZone(JiraServiceContext serviceContext) {
        this.service.clearUserDefaultTimeZone(serviceContext);
        this.userTimeZoneCache.remove();
    }

    public void setDefaultTimeZone(String timeZoneId, JiraServiceContext serviceContext) {
        this.service.setDefaultTimeZone(timeZoneId, serviceContext);
        this.userTimeZoneCache.remove();
    }

    public void clearDefaultTimeZone(JiraServiceContext serviceContext) {
        this.service.clearDefaultTimeZone(serviceContext);
        this.userTimeZoneCache.remove();
    }

    public TimeZoneInfo getUserTimeZoneInfo(JiraServiceContext serviceContext) {
        TimeZoneInfo timeZoneInfo = this.userTimeZoneCache.get();
        if (timeZoneInfo != null) {
            return timeZoneInfo;
        }
        TimeZoneInfo userTimeZoneInfo = this.service.getUserTimeZoneInfo(serviceContext);
        this.userTimeZoneCache.set(userTimeZoneInfo);
        return userTimeZoneInfo;
    }

    public TimeZoneInfo getJVMTimeZoneInfo(JiraServiceContext serviceContext) {
        return this.service.getJVMTimeZoneInfo(serviceContext);
    }

    public TimeZoneInfo getDefaultTimeZoneInfo(JiraServiceContext serviceContext) {
        return this.service.getDefaultTimeZoneInfo(serviceContext);
    }

    public List<RegionInfo> getTimeZoneRegions(JiraServiceContext serviceContext) {
        return this.service.getTimeZoneRegions(serviceContext);
    }

    public List<TimeZoneInfo> getTimeZoneInfos(JiraServiceContext serviceContext) {
        return this.service.getTimeZoneInfos(serviceContext);
    }

    public String getDefaultTimeZoneRegionKey() {
        return this.service.getDefaultTimeZoneRegionKey();
    }

    public boolean useSystemTimeZone() {
        return this.service.useSystemTimeZone();
    }

    public boolean usesJiraTimeZone(JiraServiceContext serviceContext) {
        return this.service.usesJiraTimeZone(serviceContext);
    }
}

