/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.AbstractIssueFieldSecurityType;
import com.atlassian.jira.security.util.GroupSelectorUtils;
import com.atlassian.jira.user.util.UserUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.ofbiz.core.entity.GenericValue;

public class GroupCF
extends AbstractIssueFieldSecurityType {
    private static final Logger log = Logger.getLogger(GroupCF.class);
    public static final String TYPE = "groupCF";
    private String desc = "groupCF";
    private JiraAuthenticationContext jiraAuthenticationContext;
    private GroupSelectorUtils groupSelectorUtils;
    private final CustomFieldManager customFieldManager;
    private final UserUtil userUtil;

    public GroupCF(JiraAuthenticationContext jiraAuthenticationContext, GroupSelectorUtils groupSelectorUtils, CustomFieldManager customFieldManager, UserUtil userUtil) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.groupSelectorUtils = groupSelectorUtils;
        this.customFieldManager = customFieldManager;
        this.userUtil = userUtil;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.group.custom.field");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Query getQuery(User searcher, GenericValue entity, String parameter) {
        this.desc = parameter;
        return super.getQuery(searcher, entity, parameter);
    }

    @Override
    protected BooleanQuery getQueryForProject(GenericValue project, User searcher) {
        SortedSet groupNames = this.userUtil.getGroupNamesForUser(searcher.getName());
        if (groupNames != null && !groupNames.isEmpty()) {
            BooleanQuery projectAndGroupQuery = new BooleanQuery();
            TermQuery projectQuery = new TermQuery(new Term("projid", project.getString("id")));
            projectAndGroupQuery.add((Query)projectQuery, BooleanClause.Occur.MUST);
            BooleanQuery groupQuery = this.getQueryForGroups(groupNames);
            projectAndGroupQuery.add((Query)groupQuery, BooleanClause.Occur.MUST);
            return projectAndGroupQuery;
        }
        return null;
    }

    private BooleanQuery getQueryForGroups(Collection groupNames) {
        BooleanQuery groupQuery = new BooleanQuery();
        for (String groupName : groupNames) {
            CustomField customField = this.customFieldManager.getCustomFieldObject(this.desc);
            groupQuery.add(this.getQueryForGroupName(customField, groupName), BooleanClause.Occur.SHOULD);
        }
        return groupQuery;
    }

    private Query getQueryForGroupName(CustomField customField, String groupName) {
        Query termQuery = null;
        if (customField.getCustomFieldType() instanceof GroupSelectorField) {
            GroupSelectorField groupSelector = (GroupSelectorField)customField.getCustomFieldType();
            termQuery = groupSelector.getQueryForGroup(this.getFieldName(), groupName);
        } else {
            termQuery = new TermQuery(new Term(this.getFieldName(), groupName));
        }
        return termQuery;
    }

    @Override
    protected BooleanQuery getQueryForSecurityLevel(GenericValue issueSecurity, User searcher) {
        SortedSet groupNames = this.userUtil.getGroupNamesForUser(searcher.getName());
        if (groupNames != null && !groupNames.isEmpty()) {
            BooleanQuery securityLevelAndGroupQuery = new BooleanQuery();
            TermQuery securityLevelQuery = new TermQuery(new Term("issue_security_level", issueSecurity.getString("id")));
            securityLevelAndGroupQuery.add((Query)securityLevelQuery, BooleanClause.Occur.MUST);
            BooleanQuery groupQuery = this.getQueryForGroups(groupNames);
            securityLevelAndGroupQuery.add((Query)groupQuery, BooleanClause.Occur.MUST);
            return securityLevelAndGroupQuery;
        }
        return null;
    }

    @Override
    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
        String customFieldOption = (String)parameters.get(this.getType());
        if (StringUtils.isEmpty((String)customFieldOption)) {
            String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.please.select.group.customfield");
            jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
        } else {
            CustomField customField = this.customFieldManager.getCustomFieldObject(customFieldOption);
            if (customField != null && customField.getCustomFieldSearcher() == null) {
                String localisedMessage = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.customfieldnotindexed", customField.getName());
                jiraServiceContext.getErrorCollection().addErrorMessage(localisedMessage);
            }
        }
    }

    @Override
    protected String getFieldName() {
        return this.desc;
    }

    @Override
    protected boolean hasProjectPermission(User user, boolean issueCreation, GenericValue project) {
        return !issueCreation;
    }

    @Override
    protected boolean hasIssuePermission(User user, boolean issueCreation, GenericValue issueGv, String customFieldName) {
        CustomFieldManager customFieldManager = ComponentAccessor.getCustomFieldManager();
        boolean hasPermission = false;
        CustomField field = customFieldManager.getCustomFieldObject(customFieldName);
        if (field == null) {
            log.warn((Object)("custom field '" + customFieldName + "' is missing, can't use it to determine permissions."));
        } else {
            IssueFactory issueFactory = ComponentManager.getComponentInstanceOfType(IssueFactory.class);
            hasPermission = this.groupSelectorUtils.isUserInCustomFieldGroup((Issue)issueFactory.getIssue(issueGv), field, user);
        }
        return hasPermission;
    }

    public List getDisplayFields() {
        return this.groupSelectorUtils.getCustomFieldsSpecifyingGroups();
    }

    @Override
    public String getArgumentDisplay(String argument) {
        FieldManager fieldManager = ComponentManager.getInstance().getFieldManager();
        if (fieldManager.isCustomField(argument)) {
            CustomField field = fieldManager.getCustomField(argument);
            return field.getName();
        }
        return argument;
    }

    @Override
    public Set<User> getUsers(PermissionContext ctx, String customFieldId) {
        return this.groupSelectorUtils.getUsers(ctx.getIssue(), customFieldId);
    }
}

