/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.jira.plugin.roles.ProjectRoleActorModuleDescriptor;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PluginDelegatingRoleActorFactory
implements RoleActorFactory {
    private final PluginAccessor pluginAccessor;

    public PluginDelegatingRoleActorFactory(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String parameter) throws RoleActorDoesNotExistException {
        Map implementations = this.getImplementations();
        ProjectRoleActorModuleDescriptor roleActorModuleDescriptor = this.getRoleActorModuleDescriptor(type, implementations);
        if (roleActorModuleDescriptor == null) {
            throw new IllegalArgumentException("Type " + type + " is not a registered RoleActor implementation");
        }
        RoleActorFactory roleActorFactory = (RoleActorFactory)roleActorModuleDescriptor.getModule();
        return roleActorFactory.createRoleActor(id, projectRoleId, projectId, type, parameter);
    }

    public Set optimizeRoleActorSet(Set roleActors) {
        for (ProjectRoleActorModuleDescriptor moduleDescriptor : this.getImplementations().values()) {
            RoleActorFactory roleActorFactory = (RoleActorFactory)moduleDescriptor.getModule();
            roleActors = roleActorFactory.optimizeRoleActorSet(roleActors);
        }
        return roleActors;
    }

    private ProjectRoleActorModuleDescriptor getRoleActorModuleDescriptor(String type, Map implementations) {
        if (implementations == null) {
            return null;
        }
        return (ProjectRoleActorModuleDescriptor)((Object)implementations.get(type));
    }

    Map getImplementations() {
        UtilTimerStack.push((String)"DefaultRoleActorFactory.getImplementations");
        UtilTimerStack.push((String)"DefaultRoleActorFactory.getImplementations-getEnabledModuleDescriptorByClass");
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectRoleActorModuleDescriptor.class);
        UtilTimerStack.pop((String)"DefaultRoleActorFactory.getImplementations-getEnabledModuleDescriptorByClass");
        HashMap<String, ProjectRoleActorModuleDescriptor> actorsByType = new HashMap<String, ProjectRoleActorModuleDescriptor>(descriptors.size());
        for (ProjectRoleActorModuleDescriptor projectRoleModuleDescriptor : descriptors) {
            actorsByType.put(projectRoleModuleDescriptor.getKey(), projectRoleModuleDescriptor);
        }
        UtilTimerStack.pop((String)"DefaultRoleActorFactory.getImplementations");
        return actorsByType;
    }
}

