/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.mapper;

import com.atlassian.jira.scheme.mapper.SchemeTransformResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SchemeTransformResults {
    private List associatedTransformedResults = new ArrayList();
    private List unassociatedTransformedResults = new ArrayList();
    private List unassociatedUntransformedResults = new ArrayList();
    private List associatedUntransformedResults = new ArrayList();
    private int associatedProjectsCount = 0;

    public Collection getAll() {
        ArrayList allResults = new ArrayList();
        allResults.addAll(this.associatedTransformedResults);
        allResults.addAll(this.associatedUntransformedResults);
        allResults.addAll(this.unassociatedTransformedResults);
        allResults.addAll(this.unassociatedUntransformedResults);
        return allResults;
    }

    public Collection getAllSchemeTransformResults() {
        ArrayList transformedResults = new ArrayList();
        if (this.associatedTransformedResults != null) {
            transformedResults.addAll(this.associatedTransformedResults);
        }
        if (this.unassociatedTransformedResults != null) {
            transformedResults.addAll(this.unassociatedTransformedResults);
        }
        return transformedResults;
    }

    public void addResult(SchemeTransformResult schemeTransformResult) {
        boolean associated;
        boolean transformed = schemeTransformResult.originalSchemeTransformed();
        boolean bl = associated = !schemeTransformResult.getAssociatedProjects().isEmpty();
        if (transformed && associated) {
            this.associatedTransformedResults.add(schemeTransformResult);
            this.associatedProjectsCount += schemeTransformResult.getAssociatedProjects().size();
        } else if (transformed && !associated) {
            this.unassociatedTransformedResults.add(schemeTransformResult);
        } else if (!transformed && associated) {
            this.associatedUntransformedResults.add(schemeTransformResult);
        } else if (!transformed && !associated) {
            this.unassociatedUntransformedResults.add(schemeTransformResult);
        }
    }

    public List getUnassociatedTransformedResults() {
        return this.unassociatedTransformedResults;
    }

    public List getAssociatedTransformedResults() {
        return this.associatedTransformedResults;
    }

    public List getUnassociatedUntransformedResults() {
        return this.unassociatedUntransformedResults;
    }

    public List getAssociatedUntransformedResults() {
        return this.associatedUntransformedResults;
    }

    public int getAssociatedProjectsCount() {
        return this.associatedProjectsCount;
    }
}

