/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.portal.FlushablePortletConfigurationStore;
import com.atlassian.jira.portal.PortletConfiguration;
import com.atlassian.jira.portal.PortletConfigurationImpl;
import com.atlassian.jira.portal.PortletConfigurationStore;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.LRUMap;
import com.atlassian.jira.util.dbc.Assertions;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CachingPortletConfigurationStore
implements FlushablePortletConfigurationStore,
Startable {
    private final PortletConfigurationStore delegateStore;
    private final Lock cacheLock = new ReentrantLock(false);
    private final Map<Long, List<Long>> cacheByPageId = LRUMap.newLRUMap((int)1000);
    private final Map<Long, PortletConfiguration> cacheById = LRUMap.newLRUMap((int)4000);
    private final EventPublisher eventPublisher;

    public CachingPortletConfigurationStore(PortletConfigurationStore delegateStore, EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        Assertions.notNull((String)"delegateStore", (Object)delegateStore);
        this.delegateStore = delegateStore;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        try {
            this.cacheLock.lock();
            this.cacheByPageId.clear();
            this.cacheById.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PortletConfiguration> getByPortalPage(Long portalPageId) {
        List<Object> returnList;
        Assertions.notNull((String)"portalPageId", (Object)portalPageId);
        this.cacheLock.lock();
        List<Long> configIds = null;
        try {
            configIds = this.cacheByPageId.get(portalPageId);
        }
        finally {
            this.cacheLock.unlock();
        }
        if (configIds == null) {
            List<PortletConfiguration> configsFromDatabase = this.delegateStore.getByPortalPage(portalPageId);
            this.cacheLock.lock();
            try {
                if (configsFromDatabase != null) {
                    configIds = new ArrayList<Long>(configsFromDatabase.size());
                    returnList = new ArrayList(configsFromDatabase.size());
                    for (PortletConfiguration portletConfiguration : configsFromDatabase) {
                        if (!this.cacheById.containsKey(portletConfiguration.getId())) {
                            this.putInCacheById(portletConfiguration);
                        }
                        configIds.add(portletConfiguration.getId());
                        returnList.add(this.copyConfiguration(portletConfiguration));
                    }
                } else {
                    configIds = Collections.emptyList();
                    returnList = Collections.emptyList();
                }
                this.cacheByPageId.put(portalPageId, configIds);
            }
            finally {
                this.cacheLock.unlock();
            }
        } else {
            returnList = new ArrayList<PortletConfiguration>(configIds.size());
            for (Long element : configIds) {
                Long id = element;
                PortletConfiguration portletConfiguration = this.getByPortletId(id);
                if (portletConfiguration == null) continue;
                returnList.add(portletConfiguration);
            }
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortletConfiguration getByPortletId(Long portletId) {
        PortletConfiguration portletConfiguration;
        Assertions.notNull((String)"portletId", (Object)portletId);
        this.cacheLock.lock();
        try {
            portletConfiguration = this.cacheById.get(portletId);
        }
        finally {
            this.cacheLock.unlock();
        }
        if (portletConfiguration == null && (portletConfiguration = this.delegateStore.getByPortletId(portletId)) != null) {
            this.cacheLock.lock();
            try {
                this.putInCacheById(portletConfiguration);
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return this.copyConfiguration(portletConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(PortletConfiguration pc) {
        Assertions.notNull((String)"pc", (Object)pc);
        Assertions.notNull((String)"pc.id", (Object)pc.getId());
        try {
            this.delegateStore.delete(pc);
        }
        finally {
            this.cacheLock.lock();
            try {
                this.removePageFromCache(pc);
                this.cacheById.remove(pc.getId());
            }
            finally {
                this.cacheLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGadgetPosition(Long gadgetId, int row, int column, Long dashboardId) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"dashboardId", (Object)dashboardId);
        this.cacheLock.lock();
        try {
            Long existingDashboardId;
            PortletConfiguration portletConfiguration = this.cacheById.remove(gadgetId);
            Long l = existingDashboardId = portletConfiguration == null ? null : portletConfiguration.getDashboardPageId();
            if (existingDashboardId == null) {
                PortletConfiguration pc = this.delegateStore.getByPortletId(gadgetId);
                existingDashboardId = pc.getDashboardPageId();
            }
            this.cacheByPageId.remove(existingDashboardId);
            this.cacheByPageId.remove(dashboardId);
            this.delegateStore.updateGadgetPosition(gadgetId, row, column, dashboardId);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateGadgetColor(Long gadgetId, Color color) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"color", (Object)color);
        this.cacheLock.lock();
        try {
            this.cacheById.remove(gadgetId);
            this.delegateStore.updateGadgetColor(gadgetId, color);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserPrefs(Long gadgetId, Map<String, String> userPrefs) {
        Assertions.notNull((String)"gadgetId", (Object)gadgetId);
        Assertions.notNull((String)"userPrefs", userPrefs);
        this.cacheLock.lock();
        try {
            this.cacheById.remove(gadgetId);
            this.delegateStore.updateUserPrefs(gadgetId, userPrefs);
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(PortletConfiguration pc) {
        Assertions.notNull((String)"pc", (Object)pc);
        Assertions.notNull((String)"pc.id", (Object)pc.getId());
        try {
            this.delegateStore.store(pc);
        }
        finally {
            this.cacheLock.lock();
            try {
                this.cacheById.remove(pc.getId());
                this.removePageFromCache(pc);
                this.cacheByPageId.remove(pc.getDashboardPageId());
            }
            finally {
                this.cacheLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"UL_UNRELEASED_LOCK_EXCEPTION_PATH"}, justification="This appears to be doing exactly the right thing with the finally-clause to release the lock")
    public PortletConfiguration addGadget(Long pageId, Long portletConfigurationId, Integer column, Integer row, URI gadgetXml, Color color, Map<String, String> userPreferences) {
        Assertions.notNull((String)"pageId", (Object)pageId);
        Assertions.notNull((String)"column", (Object)column);
        Assertions.notNull((String)"row", (Object)row);
        Assertions.notNull((String)"gadgetXml", (Object)gadgetXml);
        Assertions.notNull((String)"userPreferences", userPreferences);
        Assertions.notNull((String)"color", (Object)color);
        PortletConfiguration returnConfig = null;
        try {
            returnConfig = this.delegateStore.addGadget(pageId, portletConfigurationId, column, row, gadgetXml, color, userPreferences);
        }
        finally {
            if (returnConfig != null) {
                this.cacheLock.lock();
                try {
                    this.cacheByPageId.remove(returnConfig.getDashboardPageId());
                    this.putInCacheById(returnConfig);
                }
                finally {
                    this.cacheLock.unlock();
                }
            }
        }
        return this.copyConfiguration(returnConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.cacheLock.lock();
        try {
            this.cacheByPageId.clear();
            this.cacheById.clear();
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public EnclosedIterable<PortletConfiguration> getAllPortletConfigurations() {
        return this.delegateStore.getAllPortletConfigurations();
    }

    private void removePageFromCache(PortletConfiguration portletConfiguration) {
        Iterator<List<Long>> iterator = this.cacheByPageId.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().contains(portletConfiguration.getId())) continue;
            iterator.remove();
        }
    }

    private void putInCacheById(PortletConfiguration portletConfiguration) {
        if (portletConfiguration.getId() != null) {
            this.cacheById.put(portletConfiguration.getId(), portletConfiguration);
        }
    }

    private PortletConfiguration copyConfiguration(PortletConfiguration portletConfiguration) {
        if (portletConfiguration != null) {
            return new PortletConfigurationImpl(portletConfiguration.getId(), portletConfiguration.getDashboardPageId(), portletConfiguration.getColumn(), portletConfiguration.getRow(), portletConfiguration.getGadgetURI(), portletConfiguration.getColor(), portletConfiguration.getUserPrefs());
        }
        return null;
    }
}

