/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.PluginInjector;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.plugin.webfragment.CacheableContextProviderDecorator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.impl.AbstractDelegatingPlugin;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class JiraWebFragmentHelper
implements WebFragmentHelper {
    private static final Logger log = Logger.getLogger(JiraWebFragmentHelper.class);
    private final VelocityManager velocityManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public JiraWebFragmentHelper(VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext) {
        this.velocityManager = velocityManager;
        this.authenticationContext = authenticationContext;
        this.velocityRequestContextFactory = new DefaultVelocityRequestContextFactory(applicationProperties);
    }

    public Condition loadCondition(String className, Plugin plugin) throws ConditionLoadingException {
        try {
            Class conditionClass = plugin.loadClass(className, this.getClass());
            return (Condition)PluginInjector.newInstance(conditionClass, plugin);
        }
        catch (Exception e) {
            throw new ConditionLoadingException((Throwable)e);
        }
    }

    public ContextProvider loadContextProvider(String className, Plugin plugin) throws ConditionLoadingException {
        try {
            ContextProvider contextProvider;
            Class providerClass = plugin.loadClass(className, this.getClass());
            if (plugin instanceof AbstractDelegatingPlugin) {
                plugin = ((AbstractDelegatingPlugin)plugin).getDelegate();
            }
            if ((contextProvider = (ContextProvider)PluginInjector.newInstance(providerClass, plugin)) instanceof CacheableContextProvider) {
                return new CacheableContextProviderDecorator((CacheableContextProvider)contextProvider);
            }
            return contextProvider;
        }
        catch (Exception e) {
            throw new ConditionLoadingException((Throwable)e);
        }
    }

    public String getI18nValue(String key, List arguments, Map context) {
        block3: {
            Object i18nObject = context.get("i18n");
            if (i18nObject != null) {
                try {
                    return ((I18nHelper)i18nObject).getText(key, (Object)arguments);
                }
                catch (ClassCastException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Expected an instance of I18nHelper in the context under key: 'i18n' but it was " + i18nObject.getClass()), (Throwable)e);
                }
            }
        }
        return this.authenticationContext.getI18nHelper().getText(key, (Object)arguments);
    }

    public String renderVelocityFragment(String fragment, Map context) {
        if (!this.needToRender(fragment)) {
            return fragment;
        }
        return this.getHtml(fragment, this.getDefaultParams(context));
    }

    protected String getHtml(String fragment, Map startingParams) {
        try {
            if (TextUtils.stringSet((String)fragment)) {
                return this.velocityManager.getEncodedBodyForContent(fragment, this.getBaseUrl(), startingParams);
            }
        }
        catch (VelocityException e) {
            log.error((Object)("Error while rendering velocity fragment: '" + fragment + "'."), (Throwable)e);
        }
        return "";
    }

    private Map getDefaultParams(Map startingParams) {
        return JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
    }

    private boolean needToRender(String velocity) {
        return TextUtils.stringSet((String)velocity) && (velocity.indexOf("$") >= 0 || velocity.indexOf("#") >= 0);
    }

    private String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }
}

