/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.projectpanel.fragment.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugin.projectpanel.fragment.MenuFragment;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.velocity.VelocityManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class ReportsMenuFragment
implements MenuFragment {
    private static final String TEMPLATE = "reportsmenu.vm";
    private static final String TEMPLATE_DIRECTORY_PATH = "templates/plugins/jira/projectpanels/fragments/summary/menu/";
    private static final String REPORTS_ID = "reports";
    private static final Logger log = Logger.getLogger(ReportsMenuFragment.class);
    private final VelocityManager velocityManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;

    public ReportsMenuFragment(VelocityManager velocityManager, JiraAuthenticationContext jiraAuthenticationContext, ApplicationProperties applicationProperties, PluginAccessor pluginAccessor) {
        this.velocityManager = velocityManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
    }

    @Override
    public String getId() {
        return REPORTS_ID;
    }

    @Override
    public String getHtml(BrowseContext ctx) {
        try {
            Map<String, Object> velocityParams = JiraVelocityUtils.getDefaultVelocityParams(this.jiraAuthenticationContext);
            velocityParams.put("project", ctx.getProject());
            velocityParams.put("i18n", this.jiraAuthenticationContext.getI18nHelper());
            velocityParams.put(REPORTS_ID, this.getReports());
            velocityParams.put("browseContext", ctx);
            return this.velocityManager.getEncodedBody(TEMPLATE_DIRECTORY_PATH, TEMPLATE, this.applicationProperties.getEncoding(), velocityParams);
        }
        catch (VelocityException e) {
            log.error((Object)"Error occurred while rendering velocity template for 'templates/plugins/jira/projectpanels/fragments/summary/menu/reportsmenu.vm'.", (Throwable)e);
            return "";
        }
    }

    private List<ReportModuleDescriptor> getReports() {
        ArrayList<ReportModuleDescriptor> reports = new ArrayList<ReportModuleDescriptor>(this.pluginAccessor.getEnabledModuleDescriptorsByClass(ReportModuleDescriptor.class));
        Iterator iterator = reports.iterator();
        while (iterator.hasNext()) {
            ReportModuleDescriptor descriptor = (ReportModuleDescriptor)iterator.next();
            if (descriptor.getModule().showReport()) continue;
            iterator.remove();
        }
        return reports;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return !this.getReports().isEmpty();
    }
}

