/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.keyboardshortcut;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcut;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CachingKeyboardShortcutManager
implements KeyboardShortcutManager,
Startable {
    private static final String REST_PREFIX = "/rest/api/1.0/shortcuts/";
    private static final String REST_RESOURCE = "/shortcuts.js";
    private static final String REQUEST_CACHE_KEY = "keyboard.shortcuts.contexts";
    private final Map<String, KeyboardShortcut> shortcuts = new ConcurrentHashMap<String, KeyboardShortcut>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final BuildUtilsInfo buildUtilsInfo;
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;
    private final WebResourceIntegration webResourceIntegration;
    private final JiraAuthenticationContext authenticationContext;
    private final UserPreferencesManager userPreferencesManager;
    private final ResettableLazyReference<List<KeyboardShortcut>> ref = new ResettableLazyReference<List<KeyboardShortcut>>(){

        protected List<KeyboardShortcut> create() throws Exception {
            ArrayList<KeyboardShortcut> ret = new ArrayList<KeyboardShortcut>(CachingKeyboardShortcutManager.this.shortcuts.values());
            Collections.sort(ret);
            return ret;
        }
    };
    private final ResettableLazyReference<String> resourceRef = new ResettableLazyReference<String>(){

        protected String create() throws Exception {
            MessageDigest messageDigest = this.getMessageDigest("MD5");
            if (messageDigest == null) {
                messageDigest = this.getMessageDigest("SHA");
            }
            if (messageDigest == null) {
                throw new RuntimeException("Unable to retrieve a valid message digest!");
            }
            messageDigest.update(CachingKeyboardShortcutManager.this.getAllShortcuts().toString().getBytes());
            byte[] digest = messageDigest.digest();
            BigInteger bigInt = new BigInteger(1, digest);
            String hash = bigInt.toString(16);
            return CachingKeyboardShortcutManager.REST_PREFIX + CachingKeyboardShortcutManager.this.buildUtilsInfo.getCurrentBuildNumber() + "/" + hash + CachingKeyboardShortcutManager.REST_RESOURCE;
        }

        private MessageDigest getMessageDigest(String digestName) {
            try {
                return MessageDigest.getInstance(digestName);
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }
    };

    public CachingKeyboardShortcutManager(BuildUtilsInfo buildUtilsInfo, EventPublisher eventPublisher, PluginAccessor pluginAccessor, WebResourceIntegration webResourceIntegration, JiraAuthenticationContext authenticationContext, UserPreferencesManager userPreferencesManager) {
        this.buildUtilsInfo = buildUtilsInfo;
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
        this.webResourceIntegration = webResourceIntegration;
        this.authenticationContext = authenticationContext;
        this.userPreferencesManager = userPreferencesManager;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.lock.writeLock().lock();
        try {
            this.shortcuts.clear();
            this.ref.reset();
            this.resourceRef.reset();
            List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(KeyboardShortcutModuleDescriptor.class);
            for (KeyboardShortcutModuleDescriptor descriptor : descriptors) {
                this.shortcuts.put(descriptor.getCompleteKey(), (KeyboardShortcut)descriptor.getModule());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerShortcut(String pluginModuleKey, KeyboardShortcut shortcut) {
        this.lock.writeLock().lock();
        try {
            this.shortcuts.put(pluginModuleKey, shortcut);
            this.ref.reset();
            this.resourceRef.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterShortcut(String pluginModuleKey) {
        this.lock.writeLock().lock();
        try {
            this.shortcuts.remove(pluginModuleKey);
            this.ref.reset();
            this.resourceRef.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyboardShortcut> getAllShortcuts() {
        this.lock.readLock().lock();
        try {
            List list = (List)this.ref.get();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void requireShortcutsForContext(KeyboardShortcutManager.Context context) {
        this.getRequiredContexts().add(context);
    }

    private Set<KeyboardShortcutManager.Context> getRequiredContexts() {
        Map requestCache = this.webResourceIntegration.getRequestCache();
        LinkedHashSet requiredContexts = (LinkedHashSet)requestCache.get(REQUEST_CACHE_KEY);
        if (requiredContexts == null) {
            requiredContexts = new LinkedHashSet();
            requestCache.put(REQUEST_CACHE_KEY, requiredContexts);
        }
        return requiredContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String includeShortcuts() {
        UrlBuilder url;
        this.lock.readLock().lock();
        try {
            url = new UrlBuilder((String)this.resourceRef.get());
        }
        finally {
            this.lock.readLock().unlock();
        }
        for (KeyboardShortcutManager.Context context : this.getRequiredContexts()) {
            url.addParameterUnsafe("context", context.toString());
        }
        return url.asUrlString();
    }

    public boolean isKeyboardShortcutsEnabled() {
        User user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return true;
        }
        Preferences userPrefs = this.userPreferencesManager.getPreferences(user);
        return !userPrefs.getBoolean("user.keyboard.shortcuts.disabled");
    }
}

